/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.generator.java;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.error.WarnBadAngle;
import com.ticxo.modelengine.api.error.WarnBadTranslation;
import com.ticxo.modelengine.api.error.WarnBoneTooLarge;
import com.ticxo.modelengine.api.error.WarnMultipleAngle;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchElement;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchFace;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchTexture;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class JavaItemModel {
    private final List<JavaCube> elements = new ArrayList<JavaCube>();
    private final Map<Integer, String> textures = Maps.newConcurrentMap();
    private final Map<String, JavaDisplay> display = Maps.newConcurrentMap();
    private final transient String name;
    private final transient JavaDisplay head;
    private final transient Set<Integer> usedTexture = Sets.newConcurrentHashSet();
    private final transient Map<Integer, BlockbenchTexture> texturesUV = Maps.newConcurrentMap();
    private final transient BlueprintBone bone;

    public JavaItemModel(String string, List<BlockbenchTexture> list, BlueprintBone blueprintBone) {
        this.name = string;
        int n = 0;
        for (BlockbenchTexture blockbenchTexture : list) {
            this.textures.put(n, blockbenchTexture.getNamespace() + ":" + blockbenchTexture.getFolder() + "/" + blockbenchTexture.getName());
            this.texturesUV.put(n++, blockbenchTexture);
        }
        this.bone = blueprintBone;
        this.head = new JavaDisplay();
        this.display.put("head", this.head);
    }

    public void addElement(BlockbenchElement blockbenchElement) {
        JavaCube javaCube = new JavaCube();
        javaCube.setFrom(blockbenchElement.getFrom().clone().subtract(this.bone.getItemOrigin()));
        javaCube.setTo(blockbenchElement.getTo().clone().subtract(this.bone.getItemOrigin()));
        javaCube.inflate(blockbenchElement.getInflate());
        JavaRotation javaRotation = new JavaRotation();
        javaRotation.setRotation(blockbenchElement.getRotation(), new WarnMultipleAngle(this.name, blockbenchElement.getName()), new WarnBadAngle(this.name, blockbenchElement.getName()));
        javaRotation.setOrigin(blockbenchElement.getOrigin().clone().subtract(this.bone.getItemOrigin()));
        javaCube.setRotation(javaRotation);
        for (String string : blockbenchElement.getFaces().keySet()) {
            BlockbenchFace blockbenchFace = blockbenchElement.getFaces().get(string);
            if (blockbenchFace.getTexture() != null) {
                this.usedTexture.add(blockbenchFace.getTexture());
            }
            javaCube.getFaces().put(string, new JavaFace(blockbenchFace, this.texturesUV));
        }
        this.elements.add(javaCube);
    }

    public void shrinkModel(double d) {
        for (JavaCube javaCube : this.elements) {
            javaCube.shrink(d);
        }
    }

    public void offsetModel(float f, float f2, float f3) {
        for (JavaCube javaCube : this.elements) {
            javaCube.offset(f, f2, f3);
        }
    }

    public void normalizeModel(WarnBoneTooLarge warnBoneTooLarge, WarnBadTranslation warnBadTranslation) {
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MAX_VALUE;
        float f4 = -3.4028235E38f;
        float f5 = -3.4028235E38f;
        float f6 = -3.4028235E38f;
        for (JavaCube javaCube : this.elements) {
            float[] fArray = javaCube.getFrom();
            float[] fArray2 = javaCube.getTo();
            f = Math.min(f, fArray[0]);
            f2 = Math.min(f2, fArray[1]);
            f3 = Math.min(f3, fArray[2]);
            f4 = Math.max(f4, fArray2[0]);
            f5 = Math.max(f5, fArray2[1]);
            f6 = Math.max(f6, fArray2[2]);
        }
        float f7 = f4 - f;
        float f8 = f5 - f2;
        float f9 = f6 - f3;
        float f10 = 0.5714286f;
        if (f7 > 84.0f || f8 > 84.0f || f9 > 84.0f) {
            this.bone.setOption("large");
            f10 = 0.4f;
        }
        this.shrinkModel(f10);
        f *= f10;
        f2 *= f10;
        f3 *= f10;
        f4 *= f10;
        f5 *= f10;
        f6 *= f10;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        f11 += f < -24.0f ? -24.0f - f : 0.0f;
        f12 += f2 < -24.0f ? -24.0f - f2 : 0.0f;
        f13 += f3 < -24.0f ? -24.0f - f3 : 0.0f;
        this.offsetModel(f11 += f4 > 24.0f ? 24.0f - f4 : 0.0f, f12 += f5 > 24.0f ? 24.0f - f5 : 0.0f, f13 += f6 > 24.0f ? 24.0f - f6 : 0.0f);
        this.head.offsetTranslation(f11, f12, f13);
        this.offsetModel(8.0f, 8.0f, 8.0f);
        if (f7 > 120.0f || f8 > 120.0f || f9 > 120.0f) {
            warnBoneTooLarge.setX(f7);
            warnBoneTooLarge.setY(f8);
            warnBoneTooLarge.setZ(f9);
            warnBoneTooLarge.log();
        } else if (Math.abs(this.head.translation[0]) > 80.0f || Math.abs(this.head.translation[1]) > 80.0f || Math.abs(this.head.translation[2]) > 80.0f) {
            warnBadTranslation.setX(this.head.translation[0]);
            warnBadTranslation.setY(this.head.translation[1]);
            warnBadTranslation.setZ(this.head.translation[2]);
            warnBadTranslation.log();
        }
    }

    public void cleanUpTextures() {
        for (int n : this.textures.keySet()) {
            if (this.usedTexture.contains(n)) continue;
            this.textures.remove(n);
            this.texturesUV.remove(n);
        }
    }

    public List<JavaCube> getElements() {
        return this.elements;
    }

    public Map<Integer, String> getTextures() {
        return this.textures;
    }

    public Map<String, JavaDisplay> getDisplay() {
        return this.display;
    }

    public String getName() {
        return this.name;
    }

    public JavaDisplay getHead() {
        return this.head;
    }

    public Set<Integer> getUsedTexture() {
        return this.usedTexture;
    }

    public Map<Integer, BlockbenchTexture> getTexturesUV() {
        return this.texturesUV;
    }

    public BlueprintBone getBone() {
        return this.bone;
    }

    static class JavaDisplay {
        private final float[] translation = new float[]{0.0f, -6.4f, 0.0f};
        private final float[] scale = new float[]{4.0f, 4.0f, 4.0f};

        JavaDisplay() {
        }

        public void offsetTranslation(double d, double d2, double d3) {
            this.translation[0] = (float)((double)this.translation[0] - d * (double)this.scale[0]);
            this.translation[1] = (float)((double)this.translation[1] - d2 * (double)this.scale[1]);
            this.translation[2] = (float)((double)this.translation[2] - d3 * (double)this.scale[2]);
        }

        public float[] getTranslation() {
            return this.translation;
        }

        public float[] getScale() {
            return this.scale;
        }
    }

    static class JavaCube {
        private final float[] from = new float[3];
        private final float[] to = new float[3];
        private JavaRotation rotation;
        private final Map<String, JavaFace> faces = Maps.newConcurrentMap();

        JavaCube() {
        }

        private void setFrom(Vector vector) {
            this.from[0] = (float)vector.getX();
            this.from[1] = (float)vector.getY();
            this.from[2] = (float)vector.getZ();
        }

        private void setTo(Vector vector) {
            this.to[0] = (float)vector.getX();
            this.to[1] = (float)vector.getY();
            this.to[2] = (float)vector.getZ();
        }

        private void inflate(double d) {
            this.from[0] = (float)((double)this.from[0] - d);
            this.from[1] = (float)((double)this.from[1] - d);
            this.from[2] = (float)((double)this.from[2] - d);
            this.to[0] = (float)((double)this.to[0] + d);
            this.to[1] = (float)((double)this.to[1] + d);
            this.to[2] = (float)((double)this.to[2] + d);
        }

        private void shrink(double d) {
            this.from[0] = (float)((double)this.from[0] * d);
            this.from[1] = (float)((double)this.from[1] * d);
            this.from[2] = (float)((double)this.from[2] * d);
            this.to[0] = (float)((double)this.to[0] * d);
            this.to[1] = (float)((double)this.to[1] * d);
            this.to[2] = (float)((double)this.to[2] * d);
            if (this.rotation != null) {
                this.rotation.shrink(d);
            }
        }

        private void offset(float f, float f2, float f3) {
            this.from[0] = this.from[0] + f;
            this.from[1] = this.from[1] + f2;
            this.from[2] = this.from[2] + f3;
            this.to[0] = this.to[0] + f;
            this.to[1] = this.to[1] + f2;
            this.to[2] = this.to[2] + f3;
            if (this.rotation != null) {
                this.rotation.offset(f, f2, f3);
            }
        }

        public float[] getFrom() {
            return this.from;
        }

        public float[] getTo() {
            return this.to;
        }

        public JavaRotation getRotation() {
            return this.rotation;
        }

        public Map<String, JavaFace> getFaces() {
            return this.faces;
        }

        public void setRotation(JavaRotation javaRotation) {
            this.rotation = javaRotation;
        }
    }

    static class JavaRotation {
        private float angle;
        private String axis;
        private final float[] origin = new float[3];

        JavaRotation() {
        }

        private void setRotation(EulerAngle eulerAngle, WarnMultipleAngle warnMultipleAngle, WarnBadAngle warnBadAngle) {
            double d = Math.abs(eulerAngle.getX());
            double d2 = Math.abs(eulerAngle.getY());
            double d3 = Math.abs(eulerAngle.getZ());
            if (d > 0.0 && d2 > 0.0 || d3 > 0.0 && d2 > 0.0 || d > 0.0 && d3 > 0.0) {
                warnMultipleAngle.log();
            }
            if (d > d2) {
                if (d > d3) {
                    this.angle = (float)Math.toDegrees(eulerAngle.getX());
                    this.axis = "x";
                } else {
                    this.angle = (float)Math.toDegrees(eulerAngle.getZ());
                    this.axis = "z";
                }
            } else if (d3 > d2) {
                this.angle = (float)Math.toDegrees(eulerAngle.getZ());
                this.axis = "z";
            } else {
                this.angle = (float)Math.toDegrees(eulerAngle.getY());
                this.axis = "y";
            }
            this.angle = (float)((int)(this.angle * 10.0f)) / 10.0f;
            if (Math.abs(this.angle) > 45.0f || (double)this.angle % 22.5 != 0.0) {
                warnBadAngle.setAngle(this.angle);
                warnBadAngle.log();
            }
            this.angle = (float)((int)((double)TMath.clamp(this.angle, -45.0f, 45.0f) / 22.5)) * 22.5f;
        }

        private void setOrigin(Vector vector) {
            this.origin[0] = (float)vector.getX();
            this.origin[1] = (float)vector.getY();
            this.origin[2] = (float)vector.getZ();
        }

        private void shrink(double d) {
            this.origin[0] = (float)((double)this.origin[0] * d);
            this.origin[1] = (float)((double)this.origin[1] * d);
            this.origin[2] = (float)((double)this.origin[2] * d);
        }

        private void offset(float f, float f2, float f3) {
            this.origin[0] = this.origin[0] + f;
            this.origin[1] = this.origin[1] + f2;
            this.origin[2] = this.origin[2] + f3;
        }

        public float getAngle() {
            return this.angle;
        }

        public String getAxis() {
            return this.axis;
        }

        public float[] getOrigin() {
            return this.origin;
        }

        public void setAngle(float f) {
            this.angle = f;
        }

        public void setAxis(String string) {
            this.axis = string;
        }
    }

    static class JavaFace {
        private final float[] uv = new float[4];
        private int rotation;
        private String texture;
        private final int tintindex = 0;

        protected JavaFace(BlockbenchFace blockbenchFace, Map<Integer, BlockbenchTexture> map) {
            if (blockbenchFace.getTexture() != null) {
                BlockbenchTexture blockbenchTexture = map.get(blockbenchFace.getTexture());
                this.setUV(blockbenchTexture.getUvWidth(), blockbenchTexture.getUvHeight(), blockbenchFace.getX1(), blockbenchFace.getY1(), blockbenchFace.getX2(), blockbenchFace.getY2());
            } else {
                this.setUV(16, 16, blockbenchFace.getX1(), blockbenchFace.getY1(), blockbenchFace.getX2(), blockbenchFace.getY2());
            }
            this.rotation = blockbenchFace.getRotation();
            this.texture = blockbenchFace.getTexture() != null ? "#" + blockbenchFace.getTexture() : "#missing";
        }

        private void setUV(int n, int n2, double d, double d2, double d3, double d4) {
            float f = 16.0f / (float)n;
            float f2 = 16.0f / (float)n2;
            this.uv[0] = (float)d * f;
            this.uv[1] = (float)d2 * f2;
            this.uv[2] = (float)d3 * f;
            this.uv[3] = (float)d4 * f2;
        }

        public float[] getUv() {
            return this.uv;
        }

        public int getRotation() {
            return this.rotation;
        }

        public String getTexture() {
            return this.texture;
        }

        public int getTintindex() {
            return this.tintindex;
        }

        public void setRotation(int n) {
            this.rotation = n;
        }

        public void setTexture(String string) {
            this.texture = string;
        }
    }
}

