/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.listener;

import com.google.gson.JsonSyntaxException;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.events.ModelRegistrationEvent;
import com.ticxo.modelengine.api.generator.ModelGenerator;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.utils.data.EntityData;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.persistence.PersistentDataType;

public class WorldListener
implements Listener {
    private final ModelGenerator generator = ModelEngineAPI.api.getGenerator();

    @EventHandler
    public void onEntityLoad(ChunkLoadEvent chunkLoadEvent) {
        if (this.generator.isInitialized()) {
            this.loadEntities(chunkLoadEvent.getChunk());
        } else {
            this.generator.queueTask(ModelRegistrationEvent.Phase.POST, () -> this.loadEntities(chunkLoadEvent.getChunk()));
        }
    }

    @EventHandler
    public void onEntityUnload(ChunkUnloadEvent chunkUnloadEvent) {
        if (this.generator.isInitialized()) {
            this.unloadEntities(chunkUnloadEvent.getChunk());
        } else {
            this.generator.queueTask(ModelRegistrationEvent.Phase.POST, () -> this.unloadEntities(chunkUnloadEvent.getChunk()));
        }
    }

    private void loadEntities(Chunk chunk) {
        for (Entity entity : chunk.getEntities()) {
            String string;
            if (entity instanceof Player || ModelEngineAPI.isModeledEntity(entity.getUniqueId()) || (string = (String)entity.getPersistentDataContainer().get(EntityData.DATA_KEY, PersistentDataType.STRING)) == null) continue;
            try {
                EntityData entityData = (EntityData)ModelEngineAPI.gson.fromJson(string, EntityData.class);
                ModeledEntity modeledEntity = ModelEngineAPI.createModeledEntity(entity);
                entityData.load(modeledEntity);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                jsonSyntaxException.printStackTrace();
            }
        }
    }

    private void unloadEntities(Chunk chunk) {
        for (Entity entity : chunk.getEntities()) {
            ModeledEntity modeledEntity;
            if (entity instanceof Player || (modeledEntity = ModelEngineAPI.getModeledEntity(entity.getUniqueId())) == null) continue;
            EntityData entityData = new EntityData();
            entityData.save(modeledEntity);
            entity.getPersistentDataContainer().set(EntityData.DATA_KEY, PersistentDataType.STRING, (Object)ModelEngineAPI.gson.toJson((Object)entityData));
            ModelEngineAPI.removeModeledEntity(entity.getUniqueId());
        }
    }
}

