/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.listener_v17;

import com.google.gson.JsonSyntaxException;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.events.ModelRegistrationEvent;
import com.ticxo.modelengine.api.generator.ModelGenerator;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.utils.data.EntityData;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.persistence.PersistentDataType;

public class WorldListener_v17
implements Listener {
    private final ModelGenerator generator = ModelEngineAPI.api.getGenerator();

    @EventHandler
    public void onEntityLoad(EntitiesLoadEvent entitiesLoadEvent) {
        if (this.generator.isInitialized()) {
            this.loadEntities(entitiesLoadEvent.getEntities());
        } else {
            this.generator.queueTask(ModelRegistrationEvent.Phase.POST, () -> this.loadEntities(entitiesLoadEvent.getEntities()));
        }
    }

    @EventHandler
    public void onEntityUnload(EntitiesUnloadEvent entitiesUnloadEvent) {
        if (this.generator.isInitialized()) {
            this.unloadEntities(entitiesUnloadEvent.getEntities());
        } else {
            this.generator.queueTask(ModelRegistrationEvent.Phase.POST, () -> this.unloadEntities(entitiesUnloadEvent.getEntities()));
        }
    }

    private void loadEntities(List<Entity> list) {
        for (Entity entity : list) {
            String string;
            if (entity instanceof Player || ModelEngineAPI.isModeledEntity(entity.getUniqueId()) || (string = (String)entity.getPersistentDataContainer().get(EntityData.DATA_KEY, PersistentDataType.STRING)) == null) continue;
            try {
                EntityData entityData = (EntityData)ModelEngineAPI.gson.fromJson(string, EntityData.class);
                ModeledEntity modeledEntity = ModelEngineAPI.createModeledEntity(entity);
                entityData.load(modeledEntity);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                jsonSyntaxException.printStackTrace();
            }
        }
    }

    private void unloadEntities(List<Entity> list) {
        for (Entity entity : list) {
            ModeledEntity modeledEntity;
            if (entity instanceof Player || (modeledEntity = ModelEngineAPI.getModeledEntity(entity.getUniqueId())) == null) continue;
            EntityData entityData = new EntityData();
            entityData.save(modeledEntity);
            entity.getPersistentDataContainer().set(EntityData.DATA_KEY, PersistentDataType.STRING, (Object)ModelEngineAPI.gson.toJson((Object)entityData));
            ModelEngineAPI.removeModeledEntity(entity.getUniqueId());
        }
    }
}

