/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.metrics;

import com.ticxo.modelengine.ModelEngine;
import com.ticxo.modelengine.api.utils.CompatibilityManager;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import com.ticxo.modelengine.metrics.bukkit.Metrics;
import com.ticxo.modelengine.metrics.charts.SimplePie;

public class bStats {
    public bStats(ModelEngine modelEngine) {
        if (!ConfigProperty.METRICS.getBoolean()) {
            return;
        }
        try {
            Metrics metrics = new Metrics(modelEngine, 20756);
            metrics.addCustomChart(new SimplePie("registered_models", () -> {
                int n = modelEngine.getModelRegistry().getAllBlueprintId().size();
                if (n == 0) {
                    return "0";
                }
                if (n <= 5) {
                    return "1 to 5";
                }
                if (n <= 10) {
                    return "5 to 10";
                }
                if (n <= 25) {
                    return "10 to 25";
                }
                if (n <= 50) {
                    return "25 to 50";
                }
                if (n <= 100) {
                    return "50 to 100";
                }
                if (n <= 150) {
                    return "100 to 150";
                }
                if (n <= 200) {
                    return "150 to 200";
                }
                if (n <= 250) {
                    return "200 to 250";
                }
                if (n <= 500) {
                    return "250 to 500";
                }
                if (n <= 750) {
                    return "500 to 750";
                }
                if (n <= 1000) {
                    return "750 to 1000";
                }
                return "1000+";
            }));
            CompatibilityManager compatibilityManager = modelEngine.getCompatibilityManager();
            metrics.addCustomChart(new SimplePie("uses_citizens", () -> compatibilityManager.hasPlugin("Citizens") ? "Yes" : "No"));
            metrics.addCustomChart(new SimplePie("uses_mythicmobs", () -> compatibilityManager.hasPlugin("MythicMobs") ? "Yes" : "No"));
            TLogger.log("bStats enabled");
        }
        catch (Exception exception) {
            TLogger.log("Couldn't to enable bStats");
        }
    }
}

