/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.model.bone;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.bone.ItemHolder;
import com.ticxo.modelengine.api.nms.entity.fake.FakeEntity;
import com.ticxo.modelengine.api.nms.entity.fake.HandRenderer;
import com.ticxo.modelengine.model.bone.BasicBone;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class HandBone
extends BasicBone
implements ItemHolder {
    protected final HandRenderer handRenderer;
    protected EquipmentSlot trackedSlot;
    protected boolean leftHand;
    protected ItemStack itemStack;
    protected FakeEntity.DisplaySlot display;

    public HandBone(@NotNull ActiveModel activeModel, @NotNull BlueprintBone blueprintBone, FakeEntity.DisplaySlot displaySlot) {
        super(activeModel, blueprintBone);
        this.display = displaySlot;
        this.handRenderer = ModelEngineAPI.getEntityHandler().createHandRenderer(this);
        activeModel.getItemHolderHandler().registerSpecialBone(this);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.trackedSlot == null) {
            return;
        }
        ItemStack itemStack = this.activeModel.getModeledEntity().getBase().getItemInSlot(this.trackedSlot);
        if (itemStack == null) {
            itemStack = EMPTY;
        }
        this.setItemStack(itemStack);
    }

    @Override
    public void spawn() {
        super.spawn();
        this.handRenderer.initialize();
        this.handRenderer.spawn();
    }

    @Override
    public void destroy() {
        this.handRenderer.despawn();
        this.activeModel.getRendererHandler().unregisterSpecialBone(this.boneId);
        super.destroy();
    }

    @Override
    public void setItemStack(@NotNull ItemStack itemStack) {
        if (itemStack.isSimilar(this.itemStack)) {
            return;
        }
        this.itemStack = itemStack;
        this.handRenderer.setModel(itemStack);
    }

    @Override
    public void setDisplay(FakeEntity.DisplaySlot displaySlot) {
        if (this.display == displaySlot) {
            return;
        }
        this.display = displaySlot;
        this.handRenderer.setDisplay(this.display);
    }

    @Override
    public HandRenderer getHandRenderer() {
        return this.handRenderer;
    }

    @Override
    public void setTrackedSlot(EquipmentSlot equipmentSlot) {
        this.trackedSlot = equipmentSlot;
    }

    public boolean isLeftHand() {
        return this.leftHand;
    }

    @Override
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public FakeEntity.DisplaySlot getDisplay() {
        return this.display;
    }
}

