/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.model.bone;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.bone.Renderer;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.model.bone.BasicBone;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;

public class RendererBone
extends BasicBone
implements Renderer {
    private static final Color whiteColor = Color.WHITE;
    private static final Color hurtColor = Color.fromRGB((int)0xFF6666);
    protected final BoneRenderer renderer;
    protected final boolean isGhost;
    protected int colorState;
    protected Color white = whiteColor;
    protected Color hurt = hurtColor;

    public RendererBone(@NotNull ActiveModel activeModel, @NotNull BlueprintBone blueprintBone) {
        super(activeModel, blueprintBone);
        this.renderer = ModelEngineAPI.getEntityHandler().createBoneRenderer(this);
        activeModel.getRendererHandler().registerSpecialBone(this);
        this.isGhost = blueprintBone.check("ghost");
    }

    @Override
    public void spawn() {
        super.spawn();
        this.renderer.initialize();
        this.renderer.spawn();
    }

    @Override
    public void destroy() {
        this.renderer.despawn();
        this.activeModel.getRendererHandler().unregisterSpecialBone(this.boneId);
        super.destroy();
    }

    @Override
    public void setWhite(Color color) {
        this.white = color;
        if (this.colorState == 0) {
            this.renderer.setColor(color);
        }
    }

    @Override
    public void setHurt(Color color) {
        this.hurt = color;
        if (this.colorState == 1) {
            this.renderer.setColor(color);
        }
    }

    @Override
    public BoneRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public boolean isGhost() {
        return this.isGhost;
    }

    @Override
    public int getColorState() {
        return this.colorState;
    }

    @Override
    public void setColorState(int n) {
        this.colorState = n;
    }

    @Override
    public Color getWhite() {
        return this.white;
    }

    @Override
    public Color getHurt() {
        return this.hurt;
    }
}

