/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.compatibility;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.model.MobModel;
import org.bukkit.entity.Entity;

public class MEGModel
extends MobModel {
    private final String id;
    private String mode = "A";
    private String nameplate = "";
    private double stepHeight = 0.5;
    private int viewRadius = 0;
    private boolean useHitbox = true;
    private boolean invisible = true;
    private boolean doDamageTint = true;
    private boolean canDrive = false;
    private boolean canRide = false;
    private boolean lockPitch = false;
    private boolean lockYaw = false;

    public MEGModel(MythicMob mythicMob, MythicConfig mythicConfig) {
        super(mythicMob, mythicConfig);
        if (mythicConfig.isConfigurationSection("Model")) {
            this.id = mythicConfig.getString("Model.Id", null);
            this.nameplate = mythicConfig.getString("Model.Nameplate", null);
            this.stepHeight = mythicConfig.getDouble("Model.Step", 0.5);
            this.viewRadius = mythicConfig.getInteger("Model.ViewRadius", 0);
            this.useHitbox = mythicConfig.getBoolean("Model.Hitbox", true);
            this.invisible = mythicConfig.getBoolean("Model.Invisible", true);
            this.doDamageTint = mythicConfig.getBoolean("Model.DamageTint", true);
            this.canDrive = mythicConfig.getBoolean("Model.Drive", false);
            this.canRide = mythicConfig.getBoolean("Model.Ride", false);
            this.lockPitch = mythicConfig.getBoolean("Model.LockPitch", false);
            this.lockYaw = mythicConfig.getBoolean("Model.LockYaw", false);
        } else {
            this.id = mythicConfig.getString("Model");
        }
    }

    public void apply(AbstractEntity abstractEntity) {
        if (this.id == null) {
            MythicLogger.error((String)"ModelEngine ID not specified");
            return;
        }
        Entity entity = BukkitAdapter.adapt((AbstractEntity)abstractEntity);
        ModelBlueprint modelBlueprint = ModelEngineAPI.getBlueprint(this.id);
        if (modelBlueprint == null) {
            return;
        }
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(entity.getUniqueId());
        if (modeledEntity == null) {
            modeledEntity = ModelEngineAPI.createModeledEntity(entity);
        }
        modeledEntity.setBaseEntityVisible(!this.invisible);
        modeledEntity.setStepHeight(this.stepHeight);
        modeledEntity.getMountManager().setCanSteer(this.canDrive);
        modeledEntity.getMountManager().setCanRide(this.canRide);
        if (this.viewRadius > 0) {
            modeledEntity.getRangeManager().setRenderDistance(this.viewRadius);
        }
        if (modeledEntity.getModel(this.id) == null) {
            ActiveModel activeModel = ModelEngineAPI.createActiveModel(modelBlueprint);
            activeModel.setCanHurt(this.doDamageTint);
            activeModel.setLockPitch(this.lockPitch);
            activeModel.setLockYaw(this.lockYaw);
            modeledEntity.addModel(activeModel, this.useHitbox);
        }
    }
}

