/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Map;

public class MechanicChangeParent
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString parentPart;
    private final PlaceholderString childPart;

    public MechanicChangeParent(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.parentPart = mythicLineConfig.getPlaceholderString(new String[]{"p", "parent"}, null, new String[0]);
        this.childPart = mythicLineConfig.getPlaceholderString(new String[]{"c", "child"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(modeledEntity, string);
        if (activeModel == null) {
            return SkillResult.CONDITION_FAILED;
        }
        Map<String, ModelBone> map = activeModel.getBoneIndex();
        String string2 = MythicUtils.getOrNull(this.parentPart, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string2 == null) {
            return SkillResult.INVALID_CONFIG;
        }
        ModelBone modelBone = map.get(string2);
        if (modelBone == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String string3 = MythicUtils.getOrNull(this.childPart, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string3 == null) {
            return SkillResult.INVALID_CONFIG;
        }
        ModelBone modelBone2 = map.get(string3);
        if (modelBone2 == null) {
            return SkillResult.INVALID_CONFIG;
        }
        modelBone.addChild(modelBone2);
        return SkillResult.SUCCESS;
    }
}

