/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicDismountModel
implements ITargetedEntitySkill {
    private final boolean driver;
    private PlaceholderString modelId;
    private PlaceholderString pBone;

    public MechanicDismountModel(MythicLineConfig mythicLineConfig) {
        this.driver = mythicLineConfig.getBoolean(new String[]{"d", "drive", "driver"}, true);
        if (!this.driver) {
            this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
            this.pBone = mythicLineConfig.getPlaceholderString(new String[]{"p", "pbone", "seat"}, null, new String[0]);
        }
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(skillMetadata.getCaster().getEntity().getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        MountManager mountManager = modeledEntity.getMountManager();
        if (this.driver) {
            mountManager.removeDriver();
        } else {
            ModelBone modelBone = mountManager.getPassengers().get(abstractEntity.getBukkitEntity());
            if (modelBone == null) {
                return SkillResult.CONDITION_FAILED;
            }
            String string = MythicUtils.getOrNull(this.pBone, (PlaceholderMeta)skillMetadata, abstractEntity);
            if (string == null) {
                return SkillResult.INVALID_CONFIG;
            }
            String[] stringArray = string.split(",");
            String string2 = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
            if (string2 == null || modelBone.getActiveModel().getBlueprint().getModelId().equals(string2)) {
                if (!this.contains(modelBone.getBoneId(), stringArray)) {
                    return SkillResult.CONDITION_FAILED;
                }
                mountManager.removePassenger(abstractEntity.getBukkitEntity());
            }
        }
        return SkillResult.SUCCESS;
    }

    private boolean contains(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }
}

