/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Map;

public class MechanicEnchant
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final boolean enchant;
    private final boolean exactMatch;

    public MechanicEnchant(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mythicLineConfig.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, "", new String[0]);
        this.enchant = mythicLineConfig.getBoolean(new String[]{"en", "enchant"}, true);
        this.exactMatch = mythicLineConfig.getBoolean(new String[]{"em", "exact", "match", "exactmatch"}, true);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        String string2 = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)skillMetadata, abstractEntity);
        MythicUtils.executeOptModelId(modeledEntity, string, activeModel -> this.enchant((ActiveModel)activeModel, string2));
        return SkillResult.SUCCESS;
    }

    private void enchant(ActiveModel activeModel, String string) {
        Map map = activeModel.getRendererHandler().getFakeEntity();
        if (this.exactMatch) {
            if (map.containsKey(string)) {
                ((BoneRenderer)map.get(string)).setEnchant(this.enchant);
            }
        } else {
            for (String string2 : map.keySet()) {
                if (!string2.contains(string)) continue;
                ((BoneRenderer)map.get(string2)).setEnchant(this.enchant);
            }
        }
    }
}

