/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Set;
import org.bukkit.entity.Entity;

public class MechanicMountModel
implements ITargetedEntitySkill {
    private final boolean isDriver;
    private final boolean force;
    private final boolean autoDismount;
    private final boolean canDamageMount;
    private final PlaceholderString mode;
    private PlaceholderString modelId;
    private PlaceholderString pbone;

    public MechanicMountModel(MythicLineConfig mythicLineConfig) {
        this.isDriver = mythicLineConfig.getBoolean(new String[]{"d", "drive", "driver"}, true);
        this.force = mythicLineConfig.getBoolean(new String[]{"f", "force"}, false);
        this.autoDismount = mythicLineConfig.getBoolean(new String[]{"ad", "autodismount"}, false);
        this.canDamageMount = mythicLineConfig.getBoolean(new String[]{"dmg", "damagemount"}, false);
        this.mode = mythicLineConfig.getPlaceholderString(new String[]{"m", "mode"}, "walking", new String[0]);
        if (!this.isDriver) {
            this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"mid", "model", "modelid"}, null, new String[0]);
            this.pbone = mythicLineConfig.getPlaceholderString(new String[]{"p", "pbone", "seat"}, null, new String[0]);
        }
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        AbstractEntity abstractEntity2 = skillMetadata.getCaster().getEntity();
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity2.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        MountManager mountManager = modeledEntity.getMountManager();
        String string = MythicUtils.getOrNull(this.mode, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (this.isDriver && mountManager.isCanSteer()) {
            if (this.force) {
                mountManager.removeDriver();
            } else if (mountManager.isControlled()) {
                return SkillResult.CONDITION_FAILED;
            }
            if (this.tryDismountOld(abstractEntity)) {
                mountManager.setDriver(abstractEntity.getBukkitEntity(), (MountController)ModelEngineAPI.getControllerRegistry().get(string));
                mountManager.setCanDamageMount(abstractEntity.getBukkitEntity(), this.canDamageMount);
                return SkillResult.SUCCESS;
            }
            return SkillResult.CONDITION_FAILED;
        }
        if (!this.isDriver && mountManager.isCanRide()) {
            String string2 = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
            if (string2 == null) {
                return SkillResult.INVALID_CONFIG;
            }
            String string3 = MythicUtils.getOrNull(this.pbone, (PlaceholderMeta)skillMetadata, abstractEntity);
            if (string3 == null) {
                return SkillResult.INVALID_CONFIG;
            }
            String[] stringArray = string3.split(",");
            if (this.force) {
                String string4 = null;
                int n = 0;
                for (String string5 : stringArray) {
                    Set<Entity> set = mountManager.getPassengersOnSeat(string2, string5);
                    if (!set.isEmpty()) {
                        if (string4 != null && set.size() >= n) continue;
                        string4 = string5;
                        n = set.size();
                        continue;
                    }
                    if (this.tryDismountOld(abstractEntity)) {
                        mountManager.addPassengerToSeat(string2, string5, abstractEntity.getBukkitEntity(), (MountController)ModelEngineAPI.getControllerRegistry().get(string));
                        mountManager.setCanDamageMount(abstractEntity.getBukkitEntity(), this.canDamageMount);
                        return SkillResult.SUCCESS;
                    }
                    return SkillResult.CONDITION_FAILED;
                }
                if (this.tryDismountOld(abstractEntity)) {
                    mountManager.addPassengerToSeat(string2, string4, abstractEntity.getBukkitEntity(), (MountController)ModelEngineAPI.getControllerRegistry().get(string));
                    mountManager.setCanDamageMount(abstractEntity.getBukkitEntity(), this.canDamageMount);
                    return SkillResult.SUCCESS;
                }
                return SkillResult.CONDITION_FAILED;
            }
            for (String string6 : stringArray) {
                Set<Entity> set = mountManager.getPassengersOnSeat(string2, string6);
                if (!set.isEmpty()) continue;
                if (this.tryDismountOld(abstractEntity)) {
                    mountManager.addPassengerToSeat(string2, string6, abstractEntity.getBukkitEntity(), (MountController)ModelEngineAPI.getControllerRegistry().get(string));
                    mountManager.setCanDamageMount(abstractEntity.getBukkitEntity(), this.canDamageMount);
                    return SkillResult.SUCCESS;
                }
                return SkillResult.CONDITION_FAILED;
            }
        }
        return SkillResult.CONDITION_FAILED;
    }

    private boolean tryDismountOld(AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getMountPair(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return true;
        }
        if (this.autoDismount) {
            modeledEntity.getMountManager().removeRiders(abstractEntity.getBukkitEntity());
            return true;
        }
        return false;
    }

    public boolean getTargetsCreatives() {
        return true;
    }
}

