/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.AnimationHandler;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicStateToggle
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString state;
    private final boolean ignoreLerp;
    private final boolean force;
    private final PlaceholderInt lerpIn;
    private final PlaceholderInt lerpOut;
    private final PlaceholderDouble speed;

    public MechanicStateToggle(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.state = mythicLineConfig.getPlaceholderString(new String[]{"s", "state"}, null, new String[0]);
        this.speed = mythicLineConfig.getPlaceholderDouble(new String[]{"sp", "speed"}, 1.0, new String[0]);
        this.lerpIn = mythicLineConfig.getPlaceholderInteger(new String[]{"li", "lerpin"}, 0, new String[0]);
        this.lerpOut = mythicLineConfig.getPlaceholderInteger(new String[]{"lo", "lerpout"}, 0, new String[0]);
        this.ignoreLerp = mythicLineConfig.getBoolean(new String[]{"i", "ignorelerp"}, false);
        this.force = mythicLineConfig.getBoolean(new String[]{"f", "force"}, true);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.state, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String string2 = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        MythicUtils.executeOptModelId(modeledEntity, string2, activeModel -> {
            AnimationHandler animationHandler = activeModel.getAnimationHandler();
            if (animationHandler.isPlayingAnimation(string2)) {
                this.removeAnimation((ActiveModel)activeModel, string);
            } else {
                this.addAnimation((ActiveModel)activeModel, string, skillMetadata, abstractEntity);
            }
        });
        return SkillResult.SUCCESS;
    }

    private void removeAnimation(ActiveModel activeModel, String string) {
        AnimationHandler animationHandler = activeModel.getAnimationHandler();
        if (this.ignoreLerp) {
            animationHandler.forceStopAnimation(string);
        } else {
            animationHandler.stopAnimation(string);
        }
    }

    private void addAnimation(ActiveModel activeModel, String string, SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        AnimationHandler animationHandler = activeModel.getAnimationHandler();
        int n = this.lerpIn.get((PlaceholderMeta)skillMetadata, abstractEntity);
        int n2 = this.lerpOut.get((PlaceholderMeta)skillMetadata, abstractEntity);
        double d = this.speed.get((PlaceholderMeta)skillMetadata, abstractEntity);
        animationHandler.playAnimation(string, (double)n / 20.0, (double)n2 / 20.0, d, this.force);
    }
}

