/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.UUID;

public class MechanicVFXChangeModel
implements ITargetedEntitySkill,
INoTargetSkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;

    public MechanicVFXChangeModel(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mythicLineConfig.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        String string2 = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string == null || string2 == null) {
            return SkillResult.INVALID_CONFIG;
        }
        VFX vFX = ModelEngineAPI.getVFXTicker().getVFX(abstractEntity.getUniqueId());
        if (vFX == null) {
            return SkillResult.CONDITION_FAILED;
        }
        vFX.useModel(string, string2);
        return SkillResult.SUCCESS;
    }

    public SkillResult cast(SkillMetadata skillMetadata) {
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata);
        String string2 = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)skillMetadata);
        if (string == null || string2 == null) {
            return SkillResult.INVALID_CONFIG;
        }
        UUID uUID = MythicUtils.getVFXUniqueId(skillMetadata);
        VFX vFX = ModelEngineAPI.getVFXTicker().getVFX(uUID);
        if (vFX == null) {
            return SkillResult.CONDITION_FAILED;
        }
        vFX.useModel(string, string2);
        return SkillResult.SUCCESS;
    }
}

