/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.UUID;

public class MechanicVFXCopyRotation
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;

    public MechanicVFXCopyRotation(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mythicLineConfig.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, "", new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(modeledEntity, MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity));
        if (activeModel == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String string = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ModelBone modelBone = activeModel.getBoneIndex().get(string);
        if (modelBone == null) {
            return SkillResult.INVALID_CONFIG;
        }
        UUID uUID = MythicUtils.getVFXUniqueId(skillMetadata);
        VFX vFX = ModelEngineAPI.getVFXTicker().getVFX(uUID);
        if (vFX == null || vFX.isAutoTick()) {
            return SkillResult.CONDITION_FAILED;
        }
        vFX.setRotation(modelBone.getRotation());
        return SkillResult.SUCCESS;
    }
}

