/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import java.util.UUID;

public class MechanicVFXPoint
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private final boolean lockRoll;

    public MechanicVFXPoint(MythicLineConfig mythicLineConfig) {
        this.lockRoll = mythicLineConfig.getBoolean(new String[]{"ov", "over", "overwrite"}, false);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        return this.castAtLocation(skillMetadata, abstractEntity.getLocation());
    }

    public SkillResult castAtLocation(SkillMetadata skillMetadata, AbstractLocation abstractLocation) {
        UUID uUID = MythicUtils.getVFXUniqueId(skillMetadata);
        VFX vFX = ModelEngineAPI.getVFXTicker().getVFX(uUID);
        if (vFX == null || vFX.isAutoTick()) {
            return SkillResult.CONDITION_FAILED;
        }
        vFX.point(abstractLocation.toPosition().toVector(), this.lockRoll);
        return SkillResult.SUCCESS;
    }
}

