/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import java.util.UUID;
import org.bukkit.entity.Player;

public class MechanicVFXSetObservers
implements ITargetedEntitySkill {
    private final boolean remove;
    private final boolean force;

    public MechanicVFXSetObservers(MythicLineConfig mythicLineConfig) {
        this.remove = mythicLineConfig.getBoolean(new String[]{"r", "remove"}, false);
        this.force = mythicLineConfig.getBoolean(new String[]{"f", "force"}, false);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        if (!abstractEntity.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        UUID uUID = MythicUtils.getVFXUniqueId(skillMetadata);
        VFX vFX = ModelEngineAPI.getVFXTicker().getVFX(uUID);
        if (vFX == null) {
            return SkillResult.CONDITION_FAILED;
        }
        if (this.remove) {
            vFX.getRangeManager().removePlayer((Player)abstractEntity.getBukkitEntity());
        } else if (this.force) {
            vFX.getRangeManager().forceSpawn((Player)abstractEntity.getBukkitEntity());
        } else {
            vFX.getRangeManager().updatePlayer((Player)abstractEntity.getBukkitEntity());
        }
        return SkillResult.SUCCESS;
    }

    public boolean getTargetsCreatives() {
        return true;
    }
}

