/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.tasks.Task;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.UUID;
import org.bukkit.Color;

public class MechanicVFXTint
implements ITargetedEntitySkill,
INoTargetSkill {
    private final PlaceholderInt duration;
    private final PlaceholderString colorA;
    private final PlaceholderString colorB;

    public MechanicVFXTint(MythicLineConfig mythicLineConfig) {
        this.duration = mythicLineConfig.getPlaceholderInteger(new String[]{"duration", "d"}, 0, new String[0]);
        this.colorA = mythicLineConfig.getPlaceholderString(new String[]{"c", "color", "ca", "colora"}, "FFFFFF", new String[0]);
        this.colorB = mythicLineConfig.getPlaceholderString(new String[]{"cb", "colorb"}, "FFFFFF", new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        VFX vFX = ModelEngineAPI.getVFXTicker().getVFX(abstractEntity.getUniqueId());
        if (vFX == null) {
            return SkillResult.CONDITION_FAILED;
        }
        int n = this.duration.get((PlaceholderMeta)skillMetadata, abstractEntity);
        Color color = MythicUtils.getColor(MythicUtils.getOrNull(this.colorA, (PlaceholderMeta)skillMetadata, abstractEntity));
        if (n <= 0) {
            vFX.setColor(color);
        } else {
            Color color2 = MythicUtils.getColor(MythicUtils.getOrNull(this.colorB, (PlaceholderMeta)skillMetadata, abstractEntity));
            new Animator(vFX, n, color, color2);
        }
        return SkillResult.SUCCESS;
    }

    public SkillResult cast(SkillMetadata skillMetadata) {
        UUID uUID = MythicUtils.getVFXUniqueId(skillMetadata);
        VFX vFX = ModelEngineAPI.getVFXTicker().getVFX(uUID);
        if (vFX == null) {
            return SkillResult.CONDITION_FAILED;
        }
        int n = this.duration.get((PlaceholderMeta)skillMetadata);
        Color color = MythicUtils.getColor(MythicUtils.getOrNull(this.colorA, (PlaceholderMeta)skillMetadata));
        if (n <= 0) {
            vFX.setColor(color);
        } else {
            Color color2 = MythicUtils.getColor(MythicUtils.getOrNull(this.colorB, (PlaceholderMeta)skillMetadata));
            new Animator(vFX, n, color, color2);
        }
        return SkillResult.SUCCESS;
    }

    private static class Animator
    implements Runnable {
        private final VFX target;
        private final double duration;
        private final FloatColor colorA;
        private final FloatColor colorB;
        private final Task task;
        private double iteration;

        public Animator(VFX vFX, int n, Color color, Color color2) {
            this.duration = n;
            this.task = Schedulers.sync().runRepeating((Runnable)this, 0L, 1L);
            this.colorA = new FloatColor(color);
            this.colorB = new FloatColor(color2);
            this.target = vFX;
        }

        @Override
        public void run() {
            if (this.iteration > this.duration) {
                this.task.terminate();
            } else {
                this.target.setColor(this.lerpColor(this.iteration / this.duration));
                this.iteration += 1.0;
            }
        }

        private Color lerpColor(double d) {
            int n = (int)(TMath.fastSqrt((1.0 - d) * (double)this.colorA.r + d * (double)this.colorB.r) * 255.0);
            int n2 = (int)(TMath.fastSqrt((1.0 - d) * (double)this.colorA.g + d * (double)this.colorB.g) * 255.0);
            int n3 = (int)(TMath.fastSqrt((1.0 - d) * (double)this.colorA.b + d * (double)this.colorB.b) * 255.0);
            return Color.fromRGB((int)n, (int)n2, (int)n3);
        }
    }

    private static class FloatColor {
        protected final float r;
        protected final float g;
        protected final float b;

        public FloatColor(Color color) {
            this.r = (float)(color.getRed() * color.getRed()) / 65025.0f;
            this.g = (float)(color.getGreen() * color.getGreen()) / 65025.0f;
            this.b = (float)(color.getBlue() * color.getBlue()) / 65025.0f;
        }
    }
}

