/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.UUID;

public class MechanicVFXUpdateRotation
implements ITargetedEntitySkill,
INoTargetSkill {
    private final PlaceholderString angle;
    private final boolean newOrigin;

    public MechanicVFXUpdateRotation(MythicLineConfig mythicLineConfig) {
        this.angle = mythicLineConfig.getPlaceholderString(new String[]{"angle", "a"}, null, new String[0]);
        this.newOrigin = mythicLineConfig.getBoolean(new String[]{"neworigin", "origin", "o"}, false);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        VFX vFX = ModelEngineAPI.getVFXTicker().getVFX(abstractEntity.getUniqueId());
        if (vFX == null || vFX.isAutoTick()) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.angle, (PlaceholderMeta)skillMetadata);
        if (string == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String[] stringArray = string.split(",");
        double d = Double.parseDouble(stringArray[0]);
        double d2 = Double.parseDouble(stringArray[1]);
        double d3 = Double.parseDouble(stringArray[2]);
        vFX.rotate(TMath.makeAngle(d, d2, d3), this.newOrigin);
        return SkillResult.SUCCESS;
    }

    public SkillResult cast(SkillMetadata skillMetadata) {
        UUID uUID = MythicUtils.getVFXUniqueId(skillMetadata);
        VFX vFX = ModelEngineAPI.getVFXTicker().getVFX(uUID);
        if (vFX == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.angle, (PlaceholderMeta)skillMetadata);
        if (string == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String[] stringArray = string.split(",");
        double d = Double.parseDouble(stringArray[0]);
        double d2 = Double.parseDouble(stringArray[1]);
        double d3 = Double.parseDouble(stringArray[2]);
        vFX.rotate(TMath.makeAngle(d, d2, d3), this.newOrigin);
        return SkillResult.SUCCESS;
    }
}

