/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.targeters;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.utils.math.Offset;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.api.skills.targeters.ILocationTargeter;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class TargeterModelPart
implements ILocationTargeter {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final PlaceholderString offset;
    private final PlaceholderDouble x;
    private final PlaceholderDouble y;
    private final PlaceholderDouble z;
    private final boolean exactMatch;
    private String part;
    private Mode offsetMode;
    private double oX;
    private double oY;
    private double oZ;
    private World world;

    public TargeterModelPart(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mythicLineConfig.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, null, new String[0]);
        this.offset = mythicLineConfig.getPlaceholderString(new String[]{"o", "off", "offset"}, "LOCAL", new String[0]);
        this.x = mythicLineConfig.getPlaceholderDouble("x", 0.0);
        this.y = mythicLineConfig.getPlaceholderDouble("y", 0.0);
        this.z = mythicLineConfig.getPlaceholderDouble("z", 0.0);
        this.exactMatch = mythicLineConfig.getBoolean(new String[]{"em", "exact", "match", "exactmatch"}, true);
    }

    public Collection<AbstractLocation> getLocations(SkillMetadata skillMetadata) {
        HashSet<AbstractLocation> hashSet = new HashSet<AbstractLocation>();
        SkillCaster skillCaster = skillMetadata.getCaster();
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(skillCaster.getEntity().getUniqueId());
        if (modeledEntity == null) {
            return hashSet;
        }
        this.part = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)skillMetadata);
        if (this.part == null) {
            return hashSet;
        }
        this.offsetMode = Mode.get(this.offset.get((PlaceholderMeta)skillMetadata).toUpperCase(Locale.ENGLISH));
        this.oX = this.x.get((PlaceholderMeta)skillMetadata);
        this.oY = this.y.get((PlaceholderMeta)skillMetadata);
        this.oZ = this.z.get((PlaceholderMeta)skillMetadata);
        this.world = modeledEntity.getBase().getWorld();
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata);
        MythicUtils.executeOptModelId(modeledEntity, string, activeModel -> this.searchModel((ActiveModel)activeModel, hashSet));
        return hashSet;
    }

    private void searchModel(ActiveModel activeModel, HashSet<AbstractLocation> hashSet) {
        if (activeModel == null) {
            return;
        }
        if (this.exactMatch) {
            ModelBone modelBone = activeModel.getBoneIndex().get(this.part);
            if (modelBone != null) {
                this.searchBone(modelBone, hashSet);
            }
            return;
        }
        for (String string : activeModel.getBoneIndex().keySet()) {
            if (!string.contains(this.part)) continue;
            ModelBone modelBone = activeModel.getBoneIndex().get(string);
            this.searchBone(modelBone, hashSet);
        }
    }

    private void searchBone(ModelBone modelBone, HashSet<AbstractLocation> hashSet) {
        Vector vector = modelBone.getPosition().clone();
        hashSet.add(switch (this.offsetMode) {
            case Mode.LOCAL -> {
                Vector var5_4 = new Vector(this.oX, this.oY, this.oZ);
                Offset.getRelativeLocation(modelBone.getRotation(), var5_4);
                Offset.rotateYaw(var5_4, Math.toRadians(modelBone.getYaw()));
                yield BukkitAdapter.adapt((Location)vector.toLocation(this.world).add(var5_4));
            }
            case Mode.MODEL -> {
                Vector var5_5 = new Vector(this.oX, this.oY, this.oZ);
                Offset.rotateYaw(var5_5, Math.toRadians(modelBone.getYaw()));
                yield BukkitAdapter.adapt((Location)vector.toLocation(this.world).add(var5_5));
            }
            case Mode.GLOBAL -> BukkitAdapter.adapt((Location)vector.toLocation(this.world).add(this.oX, this.oY, this.oZ));
            default -> throw new IllegalStateException();
        });
    }

    private static enum Mode {
        LOCAL,
        MODEL,
        GLOBAL;


        public static Mode get(String string) {
            try {
                return Mode.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return LOCAL;
            }
        }
    }
}

