/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.entity.controller;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.command.annotations.CommandAccessible;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.api.nms.entity.wrapper.LookController;
import com.ticxo.modelengine.api.utils.math.TMath;
import net.minecraft.server.v1_16_R3.ControllerLook;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.Vec3D;
import org.spigotmc.ActivationRange;

@CommandAccessible(value={LookController.class})
public class LookControlWrapper
extends ControllerLook
implements LookController {
    private final MountManager mountManager;
    private final ControllerLook original;
    private ModeledEntity modeledEntity;

    public LookControlWrapper(EntityInsentient entityInsentient, ControllerLook controllerLook, ModeledEntity modeledEntity) {
        super(entityInsentient);
        this.original = controllerLook;
        this.modeledEntity = modeledEntity;
        this.mountManager = modeledEntity.getMountManager();
    }

    public void a(Vec3D vec3D) {
        this.original.a(vec3D);
    }

    public void a(Entity entity, float f, float f2) {
        this.original.a(entity, f, f2);
    }

    public void a(double d, double d2, double d3) {
        this.original.a(d, d2, d3);
    }

    public void a(double d, double d2, double d3, float f, float f2) {
        this.original.a(d, d2, d3, f, f2);
    }

    public void a() {
        if (this.modeledEntity == null) {
            this.modeledEntity = ModelEngineAPI.getModeledEntity(this.a.getUniqueID());
        }
        if (this.mountManager != null && this.mountManager.isControlled()) {
            this.controlledTick();
        } else {
            this.defaultTick();
        }
    }

    protected void controlledTick() {
        MountController mountController = this.mountManager.getDriverController();
        mountController.updateDirection(this, this.modeledEntity);
    }

    protected void defaultTick() {
        if (this.isActive()) {
            this.original.a();
        }
    }

    private boolean isActive() {
        return ActivationRange.checkIfActive((Entity)this.a);
    }

    public boolean c() {
        return this.original.c();
    }

    public double d() {
        return this.original.d();
    }

    public double e() {
        return this.original.e();
    }

    public double f() {
        return this.original.f();
    }

    @Override
    public void lookAt(double d, double d2, double d3) {
        double d4 = d - this.a.locX();
        double d5 = d2 - this.a.getHeadY();
        double d6 = d3 - this.a.locZ();
        double d7 = TMath.fastSqrt(d4 * d4 + d6 * d6);
        float f = (float)Math.toDegrees(TMath.fastAtan2(-d5, d7));
        float f2 = (float)Math.toDegrees(TMath.fastAtan2(-d4, d6));
        this.setPitch(f);
        this.setHeadYaw(f2);
    }

    @Override
    public void setPitch(float f) {
        this.a.pitch = f;
    }

    @Override
    public void setHeadYaw(float f) {
        this.a.yaw = f;
        this.a.aC = f;
    }

    @Override
    public void setBodyYaw(float f) {
        this.a.aA = f;
    }
}

