/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.entity.fake.bone;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.bone.ItemHolder;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.nms.entity.fake.FakeEntity;
import com.ticxo.modelengine.api.nms.entity.fake.HandRenderer;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_16_R3.entity.fake.FakeArmorStand;
import com.ticxo.modelengine.nms.v1_16_R3.network.NetworkUtils;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketListenerPlayOut;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class HandRendererImplAC
implements HandRenderer {
    private ModelBone bone;
    private ItemHolder itemBone;
    private RangeManager rangeManager = RangeManager.EMPTY;
    private final FakeArmorStand armorStand;
    private ItemStack item;
    private boolean isItemDirty;
    private boolean isInitialized = false;
    private final boolean isC;

    public HandRendererImplAC(ModelBone modelBone, boolean bl) {
        this.setBone(modelBone);
        this.isC = bl;
        this.armorStand = new FakeArmorStand(modelBone.getPosition().getX(), modelBone.getPosition().getY(), modelBone.getPosition().getZ());
        this.armorStand.setRotation(this.getBoneRotation());
        this.armorStand.setInvisible(true);
        this.armorStand.setSmall(false);
        this.armorStand.setDisplay(this.itemBone.getDisplay());
    }

    @Override
    public void setBone(ModelBone modelBone) {
        this.bone = modelBone;
        this.itemBone = modelBone instanceof ItemHolder ? (ItemHolder)modelBone : null;
        this.rangeManager = modelBone.getActiveModel().getModeledEntity().getRangeManager();
    }

    @Override
    public void initialize() {
        this.armorStand.setLocation(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.isInitialized = true;
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.armorStand.updateMeta(true);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutSpawnEntity, packetPlayOutEntityMetadata});
        ModelEngineAPI.getModelTicker().queueTask(() -> NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{this.armorStand.updateEquipment(this.item)}));
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.armorStand.updateMeta(true);
        NetworkUtils.send(player, new Packet[]{packetPlayOutSpawnEntity, packetPlayOutEntityMetadata});
        ModelEngineAPI.getModelTicker().queueTask(() -> NetworkUtils.send(player, new Packet[]{this.armorStand.updateEquipment(this.item)}));
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityDestroy});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.getEntityId()});
        NetworkUtils.send(player, new Packet[]{packetPlayOutEntityDestroy});
    }

    @Override
    public void update() {
        if (!this.isInitialized) {
            return;
        }
        this.armorStand.setRotation(this.getBoneRotation());
        Packet<PacketListenerPlayOut> packet = this.isC ? this.armorStand.updatePositionCalibrated(this.bone.getYaw(), this.bone.getPosition()) : this.armorStand.updatePosition(this.bone.getYaw(), this.bone.getPosition());
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.armorStand.updateMeta(false);
        PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = null;
        if (this.isItemDirty) {
            packetPlayOutEntityEquipment = this.armorStand.updateEquipment(this.item);
            this.isItemDirty = false;
        }
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packet, packetPlayOutEntityMetadata, packetPlayOutEntityEquipment});
    }

    @Override
    public void updateModel() {
        PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = this.armorStand.updateEquipment(this.item);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityEquipment});
    }

    @Override
    public void setSmall(boolean bl) {
        this.armorStand.setSmall(bl);
    }

    @Override
    public void setModel(ItemStack itemStack) {
        this.item = itemStack;
        this.isItemDirty = true;
    }

    @Override
    public void setGlowing(boolean bl) {
        this.armorStand.setGlowing(bl);
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.armorStand.updateMeta(false);
        if (packetPlayOutEntityMetadata == null) {
            return;
        }
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityMetadata});
    }

    @Override
    public void setDisplay(FakeEntity.DisplaySlot displaySlot) {
        if (!this.isInitialized) {
            return;
        }
        this.armorStand.setDisplay(displaySlot);
    }

    @Override
    public void createRealRenderer() {
        this.armorStand.createRealRenderer(this.bone.getActiveModel().getModeledEntity().getBase().getWorld(), this.item);
    }

    private EulerAngle getBoneRotation() {
        if (this.isC) {
            return this.bone.getRotation();
        }
        EulerAngle eulerAngle = this.bone.getClientAproxRotation();
        if (eulerAngle != null) {
            return eulerAngle;
        }
        return this.bone.getRotation();
    }

    public FakeArmorStand getArmorStand() {
        return this.armorStand;
    }
}

