/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.entity.fake.bone;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.nms.entity.fake.SubHitboxEntity;
import com.ticxo.modelengine.api.nms.entity.hitbox.ModelHitbox;
import com.ticxo.modelengine.api.utils.FieldUtils;
import com.ticxo.modelengine.api.utils.RaceConditionUtil;
import com.ticxo.modelengine.api.utils.math.OrientedBoundingBox;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.nms.v1_16_R3.NMSFields;
import com.ticxo.modelengine.nms.v1_16_R3.entity.fake.hitbox.ModelHitboxImpl;
import com.ticxo.modelengine.nms.v1_16_R3.world.DamageSourceWrapper;
import com.ticxo.modelengine.nms.v1_16_R3.world.phys.OBB;
import java.util.UUID;
import net.minecraft.server.v1_16_R3.DamageSource;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntitySize;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumPistonReaction;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PlayerChunkMap;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.Consumer;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class SubHitboxEntityImpl
extends EntityInsentient
implements SubHitboxEntity {
    private ModelBone bone;
    private SubHitbox hitboxBone;
    private ModelHitbox modelHitbox;
    private BaseEntity<?> relayed;
    private boolean isUsingOBB;
    private OBB obb;
    private OrientedBoundingBox obbInstance;
    private final Vector location = new Vector();
    private EulerAngle rotation;
    private byte lastYaw;
    private double yOffset = 0.0;
    private boolean initialized;
    private boolean removeSelf;

    public SubHitboxEntityImpl(World world) {
        super(EntityTypes.PIG, world);
        this.setSilent(true);
        this.setNoGravity(true);
        this.setPersistent();
    }

    public void setPosition(double d, double d2, double d3) {
        if (!this.isUsingOBB) {
            super.setPosition(d, d2, d3);
            return;
        }
        if (this.obb == null) {
            return;
        }
        Vector vector = new Vector(d, d2, d3);
        EulerAngle eulerAngle = this.bone.getRotation();
        byte by = TMath.rotToByte(this.bone.getYaw());
        if (TMath.isSimilar(this.location, vector) && this.rotation.equals((Object)eulerAngle) && this.lastYaw == by) {
            return;
        }
        this.location.zero().add(vector);
        this.rotation = eulerAngle;
        this.lastYaw = by;
        super.setPositionRaw(d, d2, d3);
        OBB oBB = this.obb.makeOBBInstance(this.getPositionVector(), this.rotation, this.bone.getYaw());
        this.setOrientedBoundingBox(oBB);
        this.obbInstance = oBB.getBukkitOBB();
    }

    protected boolean cW() {
        return false;
    }

    public void tick() {
        if (this.bone == null || this.relayed == null || !this.initialized) {
            return;
        }
        if (this.removeSelf) {
            this.hitboxBone.onRemove();
            this.die();
            this.despawn();
            return;
        }
        Vector vector = this.getBonePosition();
        this.setPosition(vector.getX(), vector.getY(), vector.getZ());
        for (Entity entity : this.hitboxBone.getBoundEntities().values()) {
            net.minecraft.server.v1_16_R3.Entity entity2 = ((CraftEntity)entity).getHandle();
            entity2.setPosition(vector.getX(), vector.getY(), vector.getZ());
            entity2.fallDistance = 0.0f;
        }
        if (this.hurtTicks > 0) {
            --this.hurtTicks;
        }
        if (this.noDamageTicks > 0) {
            --this.noDamageTicks;
        }
        if (this.dl() || this.relayed.isDead()) {
            this.hitboxBone.onRemove();
            this.die();
            this.despawn();
            return;
        }
        if (this.lastDamageByPlayerTime > 0) {
            --this.lastDamageByPlayerTime;
        } else {
            this.killer = null;
        }
        if (this.getLastDamager() != null) {
            if (!this.getLastDamager().isAlive()) {
                this.setLastDamager(null);
            } else if (this.ticksLived - this.hurtTimestamp > 100) {
                this.setLastDamager(null);
            }
        }
    }

    public boolean isCollidable() {
        return false;
    }

    public Packet<?> P() {
        return null;
    }

    public boolean d(NBTTagCompound nBTTagCompound) {
        return false;
    }

    protected boolean addPassenger(net.minecraft.server.v1_16_R3.Entity entity) {
        entity.stopRiding();
        return false;
    }

    public EnumPistonReaction getPushReaction() {
        return EnumPistonReaction.IGNORE;
    }

    protected void setOrientedBoundingBox(OBB oBB) {
        try {
            FieldUtils.getField(net.minecraft.server.v1_16_R3.Entity.class, NMSFields.ENTITY_bb).set(this, (Object)oBB);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    @Override
    public void setBone(ModelBone modelBone) {
        this.bone = modelBone;
        this.hitboxBone = modelBone instanceof SubHitbox ? (SubHitbox)modelBone : null;
        this.relayed = modelBone.getActiveModel().getModeledEntity().getBase();
        ModelEngineAPI.getModelTicker().removeSubHitbox(this.getUniqueId());
        ModelEngineAPI.getModelTicker().registerSubHitbox(this.hitboxBone);
    }

    @Override
    public void initialize() {
        if (this.hitboxBone == null) {
            return;
        }
        Hitbox hitbox = this.hitboxBone.getHitbox();
        this.isUsingOBB = this.hitboxBone.isOBB();
        if (this.isUsingOBB) {
            this.rotation = this.hitboxBone.getRotation();
            this.lastYaw = TMath.rotToByte(this.hitboxBone.getYaw());
            this.obb = new OBB(hitbox.getWidth(), hitbox.getHeight(), hitbox.getDepth(), this.hitboxBone.getRotation(), this.hitboxBone.getYaw());
        } else {
            try {
                this.yOffset = hitbox.getHeight() / 2.0;
                EntitySize entitySize = new EntitySize((float)hitbox.getMaxWidth(), (float)hitbox.getHeight(), true);
                FieldUtils.getField(net.minecraft.server.v1_16_R3.Entity.class, NMSFields.ENTITY_dimensions).set(this, entitySize);
                this.a(entitySize.a(this.getPositionVector()));
                if (this.modelHitbox == null) {
                    this.modelHitbox = new ModelHitboxImpl(this.relayed, this.uniqueID, this.hitboxBone::getHitbox, this::getBonePosition);
                }
                this.modelHitbox.refresh();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        this.initialized = true;
    }

    @Override
    public int getEntityId() {
        return this.getId();
    }

    @Override
    public UUID getUniqueId() {
        return this.getUniqueID();
    }

    @Override
    public void onLevelSync(@NotNull ModelBone modelBone) {
        World world = this.world;
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer worldServer = (WorldServer)world;
        world = modelBone.getActiveModel().getModeledEntity().getBase().getLocation();
        this.setPosition(world.getX(), world.getY(), world.getZ());
        this.world.addEntity((net.minecraft.server.v1_16_R3.Entity)this);
        RaceConditionUtil.wrapAll(() -> {
            PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)worldServer.getChunkProvider().playerChunkMap.trackedEntities.get(this.getEntityId());
            try {
                FieldUtils.getField(PlayerChunkMap.EntityTracker.class, NMSFields.TRACKEDENTITY_range).setInt(entityTracker, 0);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }, 1L, 10);
    }

    public boolean damageEntity(DamageSource damageSource, float f) {
        this.hitboxBone.onHurt(new DamageSourceWrapper(damageSource), f);
        float f2 = (float)this.hitboxBone.getDamageMultiplier();
        if ((double)f2 <= 1.0E-5) {
            return false;
        }
        return this.relayed.onHurt(new DamageSourceWrapper(damageSource), f * f2);
    }

    @Override
    public void onFakeInteract(Player player, EquipmentSlot equipmentSlot) {
        this.relayed.onInteract(player, equipmentSlot);
    }

    @Override
    public void onRealInteract(Player player, EquipmentSlot equipmentSlot) {
        this.hitboxBone.onInteract(player, equipmentSlot);
    }

    @Override
    public void removeSelf() {
        this.removeSelf = true;
    }

    @Override
    public void spawn() {
        this.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)ModelHitbox::spawn));
    }

    @Override
    public void spawn(Player player) {
        this.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)modelHitbox -> modelHitbox.spawn(player)));
    }

    @Override
    public void despawn() {
        this.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)ModelHitbox::despawn));
    }

    @Override
    public void despawn(Player player) {
        this.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)modelHitbox -> modelHitbox.despawn(player)));
    }

    @Override
    public void update() {
        this.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)ModelHitbox::update));
    }

    private void updateModelHitbox(Consumer<ModelHitbox> consumer) {
        if (this.modelHitbox != null) {
            consumer.accept((Object)this.modelHitbox);
        }
    }

    @Override
    public ModelBone getBone() {
        return this.bone;
    }

    @Override
    public BaseEntity<?> getRelayed() {
        return this.relayed;
    }

    @Override
    public boolean isUsingOBB() {
        return this.isUsingOBB;
    }

    public OBB getObb() {
        return this.obb;
    }

    @Override
    public OrientedBoundingBox getObbInstance() {
        return this.obbInstance;
    }

    @Override
    public double getYOffset() {
        return this.yOffset;
    }
}

