/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.entity.fake.hitbox;

import com.ticxo.modelengine.api.nms.entity.hitbox.DynamicHitbox;
import com.ticxo.modelengine.nms.v1_16_R3.entity.fake.DataAccessors;
import com.ticxo.modelengine.nms.v1_16_R3.network.NetworkUtils;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.v1_16_R3.DataWatcher;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketDataSerializer;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_16_R3.PacketPlayOutMount;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntityLiving;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class DynamicHitboxImpl
implements DynamicHitbox {
    private static final double OFFSET = -0.6351;
    private final int slimeId;
    private final UUID slimeUUID;
    private final int cloudId;
    private final UUID cloudUUID;
    private final PacketPlayOutEntityMetadata slimeMeta;
    private final PacketPlayOutEntityMetadata cloudMeta;

    public DynamicHitboxImpl(AtomicInteger atomicInteger) {
        this.slimeId = atomicInteger.incrementAndGet();
        this.slimeUUID = UUID.randomUUID();
        this.cloudId = atomicInteger.incrementAndGet();
        this.cloudUUID = UUID.randomUUID();
        DataWatcher.Item item = new DataWatcher.Item(DataAccessors.COMMON_DATA, (Object)32);
        DataWatcher.Item item2 = new DataWatcher.Item(DataAccessors.AIR_TICK, (Object)Integer.MAX_VALUE);
        DataWatcher.Item item3 = new DataWatcher.Item(DataAccessors.SIZE_DATA, (Object)2);
        DataWatcher.Item item4 = new DataWatcher.Item(DataAccessors.CLOUD_RADIUS, (Object)Float.valueOf(0.0f));
        this.slimeMeta = this.meta(this.slimeId, List.of(item, item2, item3));
        this.cloudMeta = this.meta(this.cloudId, List.of(item, item4));
    }

    @Override
    public void spawn(Player player) {
        Location location = player.getLocation();
        PacketPlayOutSpawnEntityLiving packetPlayOutSpawnEntityLiving = this.spawnSlime(location.getX(), location.getY() + 60.0, location.getZ());
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = this.spawnCloud(location.getX(), location.getY() + 60.0, location.getZ());
        PacketPlayOutMount packetPlayOutMount = this.addPassengers();
        NetworkUtils.send(player, new Packet[]{packetPlayOutSpawnEntityLiving, packetPlayOutSpawnEntity, this.slimeMeta, this.cloudMeta, packetPlayOutMount});
    }

    @Override
    public void updateActive(Player player, RayTraceResult rayTraceResult) {
        Vector vector = rayTraceResult.getHitPosition();
        PacketPlayOutEntityTeleport packetPlayOutEntityTeleport = this.move(vector.getX(), vector.getY() + -0.6351, vector.getZ());
        NetworkUtils.send(player, new Packet[]{packetPlayOutEntityTeleport});
    }

    @Override
    public void updateInactive(Player player) {
        Location location = player.getLocation();
        PacketPlayOutEntityTeleport packetPlayOutEntityTeleport = this.move(location.getX(), Math.max(location.getY() + 60.0, -120.0), location.getZ());
        NetworkUtils.send(player, new Packet[]{packetPlayOutEntityTeleport});
    }

    private PacketPlayOutSpawnEntityLiving spawnSlime(double d, double d2, double d3) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.slimeId);
        packetDataSerializer.a(this.slimeUUID);
        packetDataSerializer.d(IRegistry.ENTITY_TYPE.a((Object)EntityTypes.SLIME));
        packetDataSerializer.writeDouble(d);
        packetDataSerializer.writeDouble(d2);
        packetDataSerializer.writeDouble(d3);
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeInt(0);
        packetDataSerializer.writeShort(0);
        packetDataSerializer.writeShort(0);
        packetDataSerializer.writeShort(0);
        return NetworkUtils.writeData(new PacketPlayOutSpawnEntityLiving(), packetDataSerializer);
    }

    private PacketPlayOutSpawnEntity spawnCloud(double d, double d2, double d3) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.cloudId);
        packetDataSerializer.a(this.cloudUUID);
        packetDataSerializer.d(IRegistry.ENTITY_TYPE.a((Object)EntityTypes.AREA_EFFECT_CLOUD));
        packetDataSerializer.writeDouble(d);
        packetDataSerializer.writeDouble(d2);
        packetDataSerializer.writeDouble(d3);
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeInt(0);
        packetDataSerializer.writeShort(0);
        packetDataSerializer.writeShort(0);
        packetDataSerializer.writeShort(0);
        return NetworkUtils.writeData(new PacketPlayOutSpawnEntity(), packetDataSerializer);
    }

    private PacketPlayOutEntityMetadata meta(int n, List<DataWatcher.Item<?>> list) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(n);
        NetworkUtils.packMeta(list, packetDataSerializer);
        return NetworkUtils.writeData(new PacketPlayOutEntityMetadata(), packetDataSerializer);
    }

    private PacketPlayOutEntityTeleport move(double d, double d2, double d3) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.cloudId);
        packetDataSerializer.writeDouble(d);
        packetDataSerializer.writeDouble(d2);
        packetDataSerializer.writeDouble(d3);
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeBoolean(false);
        return NetworkUtils.writeData(new PacketPlayOutEntityTeleport(), packetDataSerializer);
    }

    public PacketPlayOutMount addPassengers() {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.cloudId);
        packetDataSerializer.d(1);
        packetDataSerializer.d(this.slimeId);
        return NetworkUtils.writeData(new PacketPlayOutMount(), packetDataSerializer);
    }
}

