/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.network;

import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.entity.Dummy;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.Mountable;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.model.mananger.ModelTicker;
import com.ticxo.modelengine.api.model.mananger.VFXTicker;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.api.nms.world.IDamageSource;
import com.ticxo.modelengine.nms.v1_16_R3.network.NetworkUtils;
import com.ticxo.modelengine.nms.v1_16_R3.network.PacketInterceptor;
import com.ticxo.modelengine.nms.v1_16_R3.network.interact.ServerboundInteractPacketWrapper;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EnumChatFormat;
import net.minecraft.server.v1_16_R3.EnumHand;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketDataSerializer;
import net.minecraft.server.v1_16_R3.PacketPlayInSteerVehicle;
import net.minecraft.server.v1_16_R3.PacketPlayInUseEntity;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_16_R3.PacketPlayOutPosition;
import net.minecraft.server.v1_16_R3.PacketPlayOutRespawn;
import net.minecraft.server.v1_16_R3.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_16_R3.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftVector;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;

public class ModelEngineChannelHandler
extends ChannelDuplexHandler {
    private final Player bukkit;
    private final EntityPlayer player;
    private final ModelTicker ticker;
    private final VFXTicker vfxTicker;
    private final PacketInterceptor writeInterceptors;
    private final PacketInterceptor readInterceptors;

    public ModelEngineChannelHandler(Player player) {
        this.bukkit = player;
        this.player = ((CraftPlayer)player).getHandle();
        this.ticker = ModelEngineAPI.getModelTicker();
        this.vfxTicker = ModelEngineAPI.getVFXTicker();
        this.writeInterceptors = new PacketInterceptor().register(PacketPlayOutSpawnEntity.class, this::handleAddEntity).register(PacketPlayOutSpawnEntityLiving.class, this::handleAddMob).register(PacketPlayOutNamedEntitySpawn.class, this::handleAddPlayer).register(PacketPlayOutEntityDestroy.class, this::handleRemoveEntities).register(PacketPlayOutScoreboardTeam.class, this::handleSetPlayerTeam).register(PacketPlayOutEntityMetadata.class, this::handleSetEntityData).registerPost(PacketPlayOutRespawn.class, this::handleRespawn).registerPost(PacketPlayOutPosition.class, this::handlePlayerPosition).registerPost(PacketPlayOutSpawnEntity.class, this::handlePostAddEntity).registerPost(PacketPlayOutSpawnEntityLiving.class, this::handlePostAddMob).registerPost(PacketPlayOutNamedEntitySpawn.class, this::handlePostAddPlayer);
        this.readInterceptors = new PacketInterceptor().register(PacketPlayInSteerVehicle.class, this::handlePlayerInput).register(PacketPlayInUseEntity.class, this::handleInteract);
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object packet, ChannelPromise channelPromise) {
        Packet<?> packet2 = packet;
        if (!(packet2 instanceof Packet)) {
            super.write(channelHandlerContext, (Object)packet, channelPromise);
            return;
        }
        Packet packet3 = (Packet)packet2;
        packet = this.writeInterceptors.accept(packet3);
        if (packet == null) {
            return;
        }
        super.write(channelHandlerContext, packet, channelPromise);
        this.writeInterceptors.acceptPost(packet3);
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object packet) {
        Packet<?> packet2 = packet;
        if (!(packet2 instanceof Packet)) {
            super.channelRead(channelHandlerContext, (Object)packet);
            return;
        }
        Packet packet3 = (Packet)packet2;
        packet = this.readInterceptors.accept(packet3);
        if (packet == null) {
            return;
        }
        super.channelRead(channelHandlerContext, packet);
        this.readInterceptors.acceptPost(packet3);
    }

    private boolean showModel(int n) {
        VFX vFX;
        boolean bl = false;
        ModeledEntity modeledEntity = this.ticker.getModeledEntity(n);
        if (modeledEntity != null) {
            if (modeledEntity.getBase().isNpc()) {
                modeledEntity.getRangeManager().addTrackedPlayer(this.bukkit);
            }
            modeledEntity.showToPlayer(this.bukkit);
            boolean bl2 = bl = !modeledEntity.isBaseEntityVisible();
        }
        if ((vFX = this.vfxTicker.getVFX(n)) != null) {
            vFX.showToPlayer(this.bukkit);
            bl |= !vFX.isBaseEntityVisible();
        }
        return bl;
    }

    private boolean showModel(UUID uUID) {
        VFX vFX;
        boolean bl = false;
        ModeledEntity modeledEntity = this.ticker.getModeledEntity(uUID);
        if (modeledEntity != null) {
            if (modeledEntity.getBase().isNpc()) {
                modeledEntity.getRangeManager().addTrackedPlayer(this.bukkit);
            }
            modeledEntity.showToPlayer(this.bukkit);
            boolean bl2 = bl = !modeledEntity.isBaseEntityVisible();
        }
        if ((vFX = this.vfxTicker.getVFX(uUID)) != null) {
            vFX.showToPlayer(this.bukkit);
            bl |= !vFX.isBaseEntityVisible();
        }
        return bl;
    }

    private void hideModel(int n) {
        VFX vFX;
        ModeledEntity modeledEntity = this.ticker.getModeledEntity(n);
        if (modeledEntity != null && (!modeledEntity.getBase().isDead() || modeledEntity.getBase().isDead() && modeledEntity.getAnimationState(false))) {
            if (modeledEntity.getBase().isNpc()) {
                modeledEntity.getRangeManager().removeTrackedPlayer(this.bukkit);
            }
            modeledEntity.hideFromPlayer(this.bukkit);
        }
        if ((vFX = this.vfxTicker.getVFX(n)) != null) {
            vFX.hideFromPlayer(this.bukkit);
        }
    }

    private Packet<?> handleAddEntity(PacketPlayOutSpawnEntity packetPlayOutSpawnEntity) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.readData(packetPlayOutSpawnEntity);
        int n = packetDataSerializer.i();
        return this.showModel(n) ? null : packetPlayOutSpawnEntity;
    }

    private Packet<?> handleAddMob(PacketPlayOutSpawnEntityLiving packetPlayOutSpawnEntityLiving) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.readData(packetPlayOutSpawnEntityLiving);
        int n = packetDataSerializer.i();
        return this.showModel(n) ? null : packetPlayOutSpawnEntityLiving;
    }

    private Packet<?> handleAddPlayer(PacketPlayOutNamedEntitySpawn packetPlayOutNamedEntitySpawn) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.readData(packetPlayOutNamedEntitySpawn);
        packetDataSerializer.i();
        return this.showModel(packetDataSerializer.k()) ? null : packetPlayOutNamedEntitySpawn;
    }

    private Packet<?> handleRemoveEntities(PacketPlayOutEntityDestroy packetPlayOutEntityDestroy) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.readData(packetPlayOutEntityDestroy);
        for (int n : packetDataSerializer.b()) {
            this.hideModel(n);
        }
        return packetPlayOutEntityDestroy;
    }

    /*
     * WARNING - void declaration
     */
    private Packet<?> handleSetPlayerTeam(PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.readData(packetPlayOutScoreboardTeam);
        String string = packetDataSerializer.e(16);
        byte by = packetDataSerializer.readByte();
        if (by == 1 || by == 2) {
            return packetPlayOutScoreboardTeam;
        }
        IChatBaseComponent iChatBaseComponent = null;
        byte by2 = 0;
        String string2 = null;
        String string3 = null;
        EnumChatFormat enumChatFormat = null;
        IChatBaseComponent iChatBaseComponent2 = null;
        IChatBaseComponent iChatBaseComponent3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (by == 0) {
            iChatBaseComponent = packetDataSerializer.h();
            by2 = packetDataSerializer.readByte();
            string2 = packetDataSerializer.e(40);
            string3 = packetDataSerializer.e(40);
            enumChatFormat = (EnumChatFormat)packetDataSerializer.a(EnumChatFormat.class);
            iChatBaseComponent2 = packetDataSerializer.h();
            iChatBaseComponent3 = packetDataSerializer.h();
        }
        if (by == 0 || by == 3 || by == 4) {
            int n = packetDataSerializer.i();
            for (int i = 0; i < n; ++i) {
                arrayList.add(packetDataSerializer.e(40));
            }
        }
        if (arrayList.isEmpty()) {
            return packetPlayOutScoreboardTeam;
        }
        Set set = Sets.newConcurrentHashSet();
        for (String object : arrayList) {
            void var16_19;
            try {
                UUID uUID = UUID.fromString(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Player player = Bukkit.getPlayerExact((String)object);
                if (player == null) continue;
                UUID uUID = player.getUniqueId();
            }
            ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity((UUID)var16_19);
            if (modeledEntity == null) continue;
            for (ActiveModel activeModel : modeledEntity.getModels().values()) {
                for (BoneRenderer boneRenderer : activeModel.getRendererHandler().getFakeEntity().values()) {
                    set.add(boneRenderer.getRendererUUID().toString());
                }
            }
        }
        arrayList.addAll(set);
        PacketDataSerializer packetDataSerializer2 = NetworkUtils.createByteBuf();
        packetDataSerializer2.a(string);
        packetDataSerializer2.writeByte((int)by);
        if (by == 0) {
            packetDataSerializer2.a(iChatBaseComponent);
            packetDataSerializer2.writeByte((int)by2);
            packetDataSerializer2.a(string2);
            packetDataSerializer2.a(string3);
            packetDataSerializer2.a((Enum)enumChatFormat);
            packetDataSerializer2.a(iChatBaseComponent2);
            packetDataSerializer2.a(iChatBaseComponent3);
        }
        packetDataSerializer2.d(arrayList.size());
        for (String string4 : arrayList) {
            packetDataSerializer2.a(string4);
        }
        return NetworkUtils.writeData(new PacketPlayOutScoreboardTeam(), packetDataSerializer2);
    }

    private Packet<?> handleSetEntityData(PacketPlayOutEntityMetadata packetPlayOutEntityMetadata) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.readData(packetPlayOutEntityMetadata);
        int n = packetDataSerializer.i();
        if (n != this.player.getId()) {
            return packetPlayOutEntityMetadata;
        }
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(this.player.getUniqueID());
        if (modeledEntity == null || modeledEntity.isBaseEntityVisible()) {
            return packetPlayOutEntityMetadata;
        }
        ModelEngineAPI.getEntityHandler().setSelfFakeInvisible(this.bukkit, true);
        return null;
    }

    private void handleRespawn(PacketPlayOutRespawn packetPlayOutRespawn) {
        ModelEngineAPI.getEntityHandler().getDynamicHitbox().spawn(this.bukkit);
    }

    private void handlePlayerPosition(PacketPlayOutPosition packetPlayOutPosition) {
        ModelEngineAPI.getEntityHandler().getDynamicHitbox().spawn(this.bukkit);
    }

    private void handlePostAddEntity(PacketPlayOutSpawnEntity packetPlayOutSpawnEntity) {
        Mountable mountable;
        PacketDataSerializer packetDataSerializer = NetworkUtils.readData(packetPlayOutSpawnEntity);
        packetDataSerializer.i();
        UUID uUID = packetDataSerializer.readUUID();
        ModeledEntity modeledEntity = ModelEngineAPI.getMountPair(uUID);
        if (modeledEntity != null && (mountable = modeledEntity.getMountManager().getMountedBone(uUID)) != null) {
            mountable.getMountPoint().spawn(this.bukkit);
        }
    }

    private void handlePostAddMob(PacketPlayOutSpawnEntityLiving packetPlayOutSpawnEntityLiving) {
        Mountable mountable;
        PacketDataSerializer packetDataSerializer = NetworkUtils.readData(packetPlayOutSpawnEntityLiving);
        packetDataSerializer.i();
        UUID uUID = packetDataSerializer.readUUID();
        ModeledEntity modeledEntity = ModelEngineAPI.getMountPair(uUID);
        if (modeledEntity != null && (mountable = modeledEntity.getMountManager().getMountedBone(uUID)) != null) {
            mountable.getMountPoint().spawn(this.bukkit);
        }
    }

    private void handlePostAddPlayer(PacketPlayOutNamedEntitySpawn packetPlayOutNamedEntitySpawn) {
        Mountable mountable;
        PacketDataSerializer packetDataSerializer = NetworkUtils.readData(packetPlayOutNamedEntitySpawn);
        packetDataSerializer.i();
        UUID uUID = packetDataSerializer.readUUID();
        ModeledEntity modeledEntity = ModelEngineAPI.getMountPair(uUID);
        if (modeledEntity != null && (mountable = modeledEntity.getMountManager().getMountedBone(uUID)) != null) {
            mountable.getMountPoint().spawn(this.bukkit);
        }
    }

    private Packet<?> handlePlayerInput(PacketPlayInSteerVehicle packetPlayInSteerVehicle) {
        MountController mountController = ModelEngineAPI.getPlayerMountController(this.player.getUniqueID());
        if (mountController != null) {
            MountController.MountInput mountInput = new MountController.MountInput(packetPlayInSteerVehicle.b(), packetPlayInSteerVehicle.c(), packetPlayInSteerVehicle.d(), packetPlayInSteerVehicle.e());
            mountController.setInput(mountInput);
        }
        return packetPlayInSteerVehicle;
    }

    private Packet<?> handleInteract(PacketPlayInUseEntity packetPlayInUseEntity) {
        Object object;
        int n = packetPlayInUseEntity.getEntityId();
        UUID uUID = ModelEngineAPI.getInteractionTicker().getModelRelay(n);
        if (uUID != null) {
            object = this.ticker.getModeledEntity(uUID);
            if (object != null) {
                BaseEntity<?> baseEntity = object.getBase();
                if (baseEntity instanceof Dummy) {
                    Dummy dummy = (Dummy)baseEntity;
                    switch (packetPlayInUseEntity.b()) {
                        case INTERACT: {
                            dummy.onInteract(this.bukkit, packetPlayInUseEntity.c() == EnumHand.MAIN_HAND ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
                            break;
                        }
                        case ATTACK: {
                            dummy.onHurt(IDamageSource.UNKNOWN, 0.0f);
                            break;
                        }
                        case INTERACT_AT: {
                            dummy.onInteractAt(this.bukkit, packetPlayInUseEntity.c() == EnumHand.MAIN_HAND ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND, CraftVector.toBukkit((Vec3D)packetPlayInUseEntity.d()));
                        }
                    }
                    return null;
                }
                return new ServerboundInteractPacketWrapper(object.getBase().getEntityId(), packetPlayInUseEntity);
            }
            SubHitbox subHitbox = this.ticker.getSubHitboxBone(uUID);
            if (subHitbox != null) {
                return new ServerboundInteractPacketWrapper(subHitbox.getSubHitboxEntity().getEntityId(), packetPlayInUseEntity);
            }
        }
        if ((object = ModelEngineAPI.getInteractionTicker().getRelayedId(this.player.getId())) != null) {
            return new ServerboundInteractPacketWrapper((Integer)object, packetPlayInUseEntity);
        }
        return packetPlayInUseEntity;
    }
}

