/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.network;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.nms.v1_16_R3.PacketDataFixer;
import com.ticxo.modelengine.nms.v1_16_R3.entity.fake.FakeAreaEffectCloud;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelPipeline;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.server.v1_16_R3.DataWatcher;
import net.minecraft.server.v1_16_R3.EnumProtocol;
import net.minecraft.server.v1_16_R3.EnumProtocolDirection;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketDataSerializer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class NetworkUtils {
    private static boolean compressPacket = true;

    protected static void updateConfigs() {
        compressPacket = ConfigProperty.COMPRESS_PACKET.getBoolean();
    }

    public static PacketDataSerializer createByteBuf() {
        return new PacketDataSerializer(Unpooled.buffer());
    }

    public static Integer getPacketId(Packet<?> packet) {
        return EnumProtocol.PLAY.a(EnumProtocolDirection.CLIENTBOUND, packet);
    }

    public static void packMeta(List<DataWatcher.Item<?>> list, PacketDataSerializer packetDataSerializer) {
        try {
            DataWatcher.a(list, (PacketDataSerializer)packetDataSerializer);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Nullable
    public static PacketDataSerializer createCompressedPacket(Packet<?> packet) {
        Integer n = NetworkUtils.getPacketId(packet);
        if (n == null) {
            return null;
        }
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.writeByte(n.intValue());
        try {
            packet.b(packetDataSerializer);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return packetDataSerializer;
    }

    public static PacketDataSerializer readData(Packet<?> packet) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        try {
            packet.b(packetDataSerializer);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return packetDataSerializer;
    }

    public static <T extends Packet<?>> T writeData(T t, PacketDataSerializer packetDataSerializer) {
        try {
            t.a(packetDataSerializer);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return t;
    }

    public static void send(@Nullable Set<Player> set, Packet<?> ... packetArray) {
        if (set == null) {
            return;
        }
        for (Player player : new HashSet<Player>(set)) {
            NetworkUtils.send(player, packetArray);
        }
    }

    public static void send(Player player, Packet<?> ... packetArray) {
        ChannelPipeline channelPipeline = ModelEngineAPI.getNetworkHandler().getPipeline(player);
        if (channelPipeline == null) {
            return;
        }
        if (compressPacket) {
            for (Packet<?> packet : packetArray) {
                PacketDataSerializer packetDataSerializer;
                if (packet == null || (packetDataSerializer = NetworkUtils.createCompressedPacket(packet)) == null) continue;
                channelPipeline.write((Object)packetDataSerializer);
            }
        } else {
            for (Packet<?> packet : packetArray) {
                if (packet == null) continue;
                channelPipeline.write(packet);
            }
        }
        channelPipeline.flush();
    }

    public static void send(@Nullable Set<Player> set, List<Packet<?>> list) {
        if (set == null) {
            return;
        }
        for (Player player : new HashSet<Player>(set)) {
            NetworkUtils.send(player, list);
        }
    }

    public static void send(Player player, List<Packet<?>> list) {
        ChannelPipeline channelPipeline = ModelEngineAPI.getNetworkHandler().getPipeline(player);
        if (channelPipeline == null) {
            return;
        }
        if (compressPacket) {
            for (Packet<?> packet : list) {
                PacketDataSerializer packetDataSerializer;
                if (packet == null || (packetDataSerializer = NetworkUtils.createCompressedPacket(packet)) == null) continue;
                channelPipeline.write((Object)packetDataSerializer);
            }
        } else {
            for (Packet<?> packet : list) {
                if (packet == null) continue;
                channelPipeline.write(packet);
            }
        }
        channelPipeline.flush();
    }

    public static void sendProtocolDependant(@Nullable Set<Player> set, FakeAreaEffectCloud fakeAreaEffectCloud, @Nullable Packet<?> packet, PacketDataFixer ... packetDataFixerArray) {
        if (set == null) {
            return;
        }
        for (Player player : new HashSet<Player>(set)) {
            NetworkUtils.sendProtocolDependant(player, fakeAreaEffectCloud, packet, packetDataFixerArray);
        }
    }

    public static void sendProtocolDependant(Player player, FakeAreaEffectCloud fakeAreaEffectCloud, @Nullable Packet<?> packet, PacketDataFixer ... packetDataFixerArray) {
        ChannelPipeline channelPipeline = ModelEngineAPI.getNetworkHandler().getPipeline(player);
        if (channelPipeline == null) {
            return;
        }
        int n = ModelEngineAPI.getPlayerProtocolVersion(player.getUniqueId());
        if (compressPacket) {
            if (packet == null) {
                return;
            }
            for (PacketDataFixer packetDataFixer : packetDataFixerArray) {
                packet = packetDataFixer.fix(n, fakeAreaEffectCloud, packet);
            }
            channelPipeline.write((Object)NetworkUtils.createCompressedPacket(packet));
        } else {
            if (packet == null) {
                return;
            }
            for (PacketDataFixer packetDataFixer : packetDataFixerArray) {
                packet = packetDataFixer.fix(n, fakeAreaEffectCloud, packet);
            }
            channelPipeline.write(packet);
        }
        channelPipeline.flush();
    }

    public static void send(Player player, PacketDataSerializer ... packetDataSerializerArray) {
        ChannelPipeline channelPipeline = ModelEngineAPI.getNetworkHandler().getPipeline(player);
        if (channelPipeline == null) {
            return;
        }
        for (PacketDataSerializer packetDataSerializer : packetDataSerializerArray) {
            if (packetDataSerializer == null) continue;
            channelPipeline.write((Object)packetDataSerializer);
        }
        channelPipeline.flush();
    }
}

