/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.world;

import com.google.common.collect.Lists;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.nms.world.WorldHandler;
import com.ticxo.modelengine.api.utils.math.OrientedBoundingBox;
import com.ticxo.modelengine.api.utils.math.TMath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.v1_16_R3.AxisAlignedBB;
import net.minecraft.server.v1_16_R3.Chunk;
import net.minecraft.server.v1_16_R3.EntityComplexPart;
import net.minecraft.server.v1_16_R3.EntityEnderDragon;
import net.minecraft.server.v1_16_R3.IChunkProvider;
import net.minecraft.server.v1_16_R3.MathHelper;
import net.minecraft.server.v1_16_R3.MovingObjectPosition;
import net.minecraft.server.v1_16_R3.MovingObjectPositionBlock;
import net.minecraft.server.v1_16_R3.RayTrace;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R3.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftRayTraceResult;
import org.bukkit.entity.Entity;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Consumer;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class WorldHandlerImpl
implements WorldHandler {
    @Override
    public RayTraceResult asyncRayTrace(Location location, Vector vector, double d, FluidCollisionMode fluidCollisionMode, boolean bl, double d2, Predicate<Entity> predicate) {
        RayTraceResult rayTraceResult = this.asyncRayTraceBlocks(location, vector, d, fluidCollisionMode, bl);
        Vector vector2 = null;
        double d3 = d;
        if (rayTraceResult != null) {
            vector2 = location.toVector();
            d3 = TMath.fastSqrt(vector2.distanceSquared(rayTraceResult.getHitPosition()));
        }
        RayTraceResult rayTraceResult2 = this.asyncRayTraceEntities(location, vector, d3, d2, predicate);
        if (rayTraceResult == null) {
            return rayTraceResult2;
        }
        if (rayTraceResult2 == null) {
            return rayTraceResult;
        }
        double d4 = vector2.distanceSquared(rayTraceResult2.getHitPosition());
        return d4 < d3 * d3 ? rayTraceResult2 : rayTraceResult;
    }

    private RayTraceResult asyncRayTraceBlocks(Location location, Vector vector, double d, FluidCollisionMode fluidCollisionMode, boolean bl) {
        if (d < 0.0 || location.getWorld() == null) {
            return null;
        }
        WorldServer worldServer = ((CraftWorld)location.getWorld()).getHandle();
        Vector vector2 = vector.clone().normalize().multiply(d);
        Vec3D vec3D = new Vec3D(location.getX(), location.getY(), location.getZ());
        Vec3D vec3D2 = new Vec3D(location.getX() + vector2.getX(), location.getY() + vector2.getY(), location.getZ() + vector2.getZ());
        MovingObjectPositionBlock movingObjectPositionBlock = worldServer.rayTrace(new RayTrace(vec3D, vec3D2, bl ? RayTrace.BlockCollisionOption.COLLIDER : RayTrace.BlockCollisionOption.OUTLINE, CraftFluidCollisionMode.toNMS((FluidCollisionMode)fluidCollisionMode), null));
        return CraftRayTraceResult.fromNMS((org.bukkit.World)location.getWorld(), (MovingObjectPosition)movingObjectPositionBlock);
    }

    private RayTraceResult asyncRayTraceEntities(Location location, Vector vector, double d, double d2, Predicate<Entity> predicate) {
        if (d < 0.0 || location.getWorld() == null) {
            return null;
        }
        WorldServer worldServer = ((CraftWorld)location.getWorld()).getHandle();
        Vector vector2 = location.toVector();
        Vector vector3 = vector.clone().normalize().multiply(d);
        BoundingBox boundingBox2 = BoundingBox.of((Vector)vector2, (Vector)vector2).expandDirectional(vector3).expand(d2);
        Collection<Entity> collection = this.asyncGetNearbyEntities((World)worldServer, boundingBox2, predicate);
        Entity entity = null;
        RayTraceResult rayTraceResult = null;
        double d3 = Double.MAX_VALUE;
        for (Entity entity2 : collection) {
            double d4;
            RayTraceResult rayTraceResult2;
            SubHitbox subHitbox = ModelEngineAPI.getModelTicker().getSubHitboxBone(entity2.getUniqueId());
            if (subHitbox != null && subHitbox.isOBB()) {
                var21_18 = subHitbox.getSubHitboxEntity().getObbInstance();
                if (var21_18 == null) continue;
                rayTraceResult2 = ((OrientedBoundingBox)var21_18).rayTrace(vector2, vector, d, (Consumer<BoundingBox>)((Consumer)boundingBox -> boundingBox.expand(d2)));
            } else {
                var21_18 = entity2.getBoundingBox().expand(d2);
                rayTraceResult2 = var21_18.rayTrace(vector2, vector, d);
            }
            if (rayTraceResult2 == null || !((d4 = vector2.distanceSquared(rayTraceResult2.getHitPosition())) < d3)) continue;
            entity = entity2;
            rayTraceResult = rayTraceResult2;
            d3 = d4;
        }
        return entity == null ? null : new RayTraceResult(rayTraceResult.getHitPosition(), entity, rayTraceResult.getHitBlockFace());
    }

    private Collection<Entity> asyncGetNearbyEntities(World world, BoundingBox boundingBox, Predicate<Entity> predicate) {
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        List<net.minecraft.server.v1_16_R3.Entity> list = this.getEntities(world, axisAlignedBB, entity -> true);
        ArrayList<Entity> arrayList = new ArrayList<Entity>(list.size());
        Iterator<net.minecraft.server.v1_16_R3.Entity> iterator = list.iterator();
        while (iterator.hasNext()) {
            net.minecraft.server.v1_16_R3.Entity entity2 = iterator.next();
            CraftEntity craftEntity = entity2.getBukkitEntity();
            if (predicate != null && !predicate.test((Entity)craftEntity)) continue;
            arrayList.add((Entity)craftEntity);
        }
        return arrayList;
    }

    private List<net.minecraft.server.v1_16_R3.Entity> getEntities(World world, AxisAlignedBB axisAlignedBB, @Nullable Predicate<? super net.minecraft.server.v1_16_R3.Entity> predicate) {
        ArrayList arrayList = Lists.newArrayList();
        int n = MathHelper.floor((double)((axisAlignedBB.minX - 2.0) / 16.0));
        int n2 = MathHelper.floor((double)((axisAlignedBB.maxX + 2.0) / 16.0));
        int n3 = MathHelper.floor((double)((axisAlignedBB.minZ - 2.0) / 16.0));
        int n4 = MathHelper.floor((double)((axisAlignedBB.maxZ + 2.0) / 16.0));
        IChunkProvider iChunkProvider = world.getChunkProvider();
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                Chunk chunk = iChunkProvider.getChunkAt(i, j, false);
                if (chunk == null) continue;
                this.getEntitiesInChunk(chunk, axisAlignedBB, arrayList, predicate);
            }
        }
        return arrayList;
    }

    private void getEntitiesInChunk(Chunk chunk, AxisAlignedBB axisAlignedBB, List<net.minecraft.server.v1_16_R3.Entity> list, @Nullable Predicate<? super net.minecraft.server.v1_16_R3.Entity> predicate) {
        int n = MathHelper.floor((double)((axisAlignedBB.minY - 2.0) / 16.0));
        int n2 = MathHelper.floor((double)((axisAlignedBB.maxY + 2.0) / 16.0));
        n = MathHelper.clamp((int)n, (int)0, (int)(chunk.entitySlices.length - 1));
        n2 = MathHelper.clamp((int)n2, (int)0, (int)(chunk.entitySlices.length - 1));
        try {
            for (int i = n; i <= n2; ++i) {
                List<net.minecraft.server.v1_16_R3.Entity> list2 = Collections.synchronizedList(chunk.entitySlices[i]);
                for (net.minecraft.server.v1_16_R3.Entity entity : list2) {
                    EntityComplexPart[] entityComplexPartArray;
                    if (!entity.getBoundingBox().c(axisAlignedBB)) continue;
                    if (predicate == null || predicate.test((net.minecraft.server.v1_16_R3.Entity)entity)) {
                        list.add(entity);
                    }
                    if (!(entity instanceof EntityEnderDragon)) continue;
                    for (EntityComplexPart entityComplexPart : entityComplexPartArray = ((EntityEnderDragon)entity).eJ()) {
                        if (entityComplexPart == null || !entityComplexPart.getBoundingBox().c(axisAlignedBB) || predicate != null && !predicate.test((net.minecraft.server.v1_16_R3.Entity)entityComplexPart)) continue;
                        list.add((net.minecraft.server.v1_16_R3.Entity)entityComplexPart);
                    }
                }
            }
        }
        catch (ConcurrentModificationException | NoSuchElementException runtimeException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

