/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_17_R1.network;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.nms.v1_17_R1.PacketDataFixer;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelPipeline;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class NetworkUtils {
    private static boolean compressPacket = true;

    protected static void updateConfigs() {
        compressPacket = ConfigProperty.COMPRESS_PACKET.getBoolean();
    }

    public static PacketDataSerializer createByteBuf() {
        return new PacketDataSerializer(Unpooled.buffer());
    }

    public static Integer getPacketId(Packet<?> packet) {
        return EnumProtocol.b.a(EnumProtocolDirection.b, packet);
    }

    @Nullable
    public static PacketDataSerializer createCompressedPacket(Packet<?> packet) {
        Integer n = NetworkUtils.getPacketId(packet);
        if (n == null) {
            return null;
        }
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.writeByte(n.intValue());
        packet.a(packetDataSerializer);
        return packetDataSerializer;
    }

    public static PacketDataSerializer readData(Packet<?> packet) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packet.a(packetDataSerializer);
        return packetDataSerializer;
    }

    public static void send(@Nullable Set<Player> set, Packet<?> ... packetArray) {
        if (set == null) {
            return;
        }
        for (Player player : new HashSet<Player>(set)) {
            NetworkUtils.send(player, packetArray);
        }
    }

    public static void send(Player player, Packet<?> ... packetArray) {
        ChannelPipeline channelPipeline = ModelEngineAPI.getNetworkHandler().getPipeline(player);
        if (channelPipeline == null) {
            return;
        }
        if (compressPacket) {
            for (Packet<?> packet : packetArray) {
                PacketDataSerializer packetDataSerializer;
                if (packet == null || (packetDataSerializer = NetworkUtils.createCompressedPacket(packet)) == null) continue;
                channelPipeline.write((Object)packetDataSerializer);
            }
        } else {
            for (Packet<?> packet : packetArray) {
                if (packet == null) continue;
                channelPipeline.write(packet);
            }
        }
        channelPipeline.flush();
    }

    public static void send(@Nullable Set<Player> set, List<Packet<?>> list) {
        if (set == null) {
            return;
        }
        for (Player player : new HashSet<Player>(set)) {
            NetworkUtils.send(player, list);
        }
    }

    public static void send(Player player, List<Packet<?>> list) {
        ChannelPipeline channelPipeline = ModelEngineAPI.getNetworkHandler().getPipeline(player);
        if (channelPipeline == null) {
            return;
        }
        if (compressPacket) {
            for (Packet<?> packet : list) {
                PacketDataSerializer packetDataSerializer;
                if (packet == null || (packetDataSerializer = NetworkUtils.createCompressedPacket(packet)) == null) continue;
                channelPipeline.write((Object)packetDataSerializer);
            }
        } else {
            for (Packet<?> packet : list) {
                if (packet == null) continue;
                channelPipeline.write(packet);
            }
        }
        channelPipeline.flush();
    }

    public static void sendProtocolDependant(@Nullable Set<Player> set, @Nullable Packet<?> packet, PacketDataFixer ... packetDataFixerArray) {
        if (set == null) {
            return;
        }
        for (Player player : new HashSet<Player>(set)) {
            NetworkUtils.sendProtocolDependant(player, packet, packetDataFixerArray);
        }
    }

    public static void sendProtocolDependant(Player player, @Nullable Packet<?> packet, PacketDataFixer ... packetDataFixerArray) {
        ChannelPipeline channelPipeline = ModelEngineAPI.getNetworkHandler().getPipeline(player);
        if (channelPipeline == null) {
            return;
        }
        int n = ModelEngineAPI.getPlayerProtocolVersion(player.getUniqueId());
        if (compressPacket) {
            if (packet == null) {
                return;
            }
            for (PacketDataFixer packetDataFixer : packetDataFixerArray) {
                packet = packetDataFixer.fix(n, packet);
            }
            channelPipeline.write((Object)NetworkUtils.createCompressedPacket(packet));
        } else {
            if (packet == null) {
                return;
            }
            for (PacketDataFixer packetDataFixer : packetDataFixerArray) {
                packet = packetDataFixer.fix(n, packet);
            }
            channelPipeline.write(packet);
        }
        channelPipeline.flush();
    }

    public static void send(Player player, PacketDataSerializer ... packetDataSerializerArray) {
        ChannelPipeline channelPipeline = ModelEngineAPI.getNetworkHandler().getPipeline(player);
        if (channelPipeline == null) {
            return;
        }
        for (PacketDataSerializer packetDataSerializer : packetDataSerializerArray) {
            if (packetDataSerializer == null) continue;
            channelPipeline.write((Object)packetDataSerializer);
        }
        channelPipeline.flush();
    }
}

