/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_17_R1.network;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.protocol.Packet;

public class PacketInterceptor {
    private final Map<Class<? extends Packet<?>>, PacketModifier<?>> registry = Maps.newConcurrentMap();
    private final Map<Class<? extends Packet<?>>, PacketListener<?>> postRegistry = Maps.newConcurrentMap();

    public <T extends Packet<?>> PacketInterceptor register(Class<T> clazz, Function<T, Packet<?>> function) {
        this.registry.put(clazz, new PacketModifier<T>(clazz, function));
        return this;
    }

    public <T extends Packet<?>> PacketInterceptor registerPost(Class<T> clazz, Consumer<T> consumer) {
        this.postRegistry.put(clazz, new PacketListener<T>(clazz, consumer));
        return this;
    }

    public Packet<?> accept(Packet<?> packet) {
        PacketModifier<?> packetModifier = this.registry.get(packet.getClass());
        return packetModifier == null ? packet : packetModifier.modify(packet);
    }

    public void acceptPost(Packet<?> packet) {
        PacketListener<?> packetListener = this.postRegistry.get(packet.getClass());
        if (packetListener != null) {
            packetListener.listen(packet);
        }
    }

    private record PacketModifier<T extends Packet<?>>(Class<T> clazz, Function<T, Packet<?>> function) {
        public Packet<?> modify(Packet<?> packet) {
            try {
                return this.function.apply((Packet)this.clazz.cast(packet));
            }
            catch (Throwable throwable) {
                TLogger.error("An error had occurred while modifying the packet " + this.clazz.getSimpleName());
                throwable.printStackTrace();
                return packet;
            }
        }
    }

    private record PacketListener<T extends Packet<?>>(Class<T> clazz, Consumer<T> consumer) {
        public void listen(Packet<?> packet) {
            try {
                this.consumer.accept((Packet)this.clazz.cast(packet));
            }
            catch (Throwable throwable) {
                TLogger.error("An error had occurred while intercepting the packet " + this.clazz.getSimpleName());
                throwable.printStackTrace();
            }
        }
    }
}

