/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_18_R2.entity.fake;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.DataAccessors;
import com.ticxo.modelengine.nms.v1_18_R2.network.NetworkUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.world.entity.EntityTypes;
import org.bukkit.util.Vector;

public class FakeSlime {
    private final int entityId;
    private final UUID uuid;
    private final Vector location = new Vector();
    private boolean sendCancelPacket;
    private final DataWatcher.Item<Byte> commonDataItem;
    private final DataWatcher.Item<Integer> airTickDataItem;
    private final DataWatcher.Item<Integer> sizeDataItem;

    public FakeSlime(double d, double d2, double d3) {
        this.entityId = ModelEngineAPI.getEntityHandler().getEntityCounter().incrementAndGet();
        this.uuid = UUID.randomUUID();
        this.location.setX(d).setY(d2).setZ(d3);
        this.commonDataItem = new DataWatcher.Item(DataAccessors.COMMON_DATA, (Object)32);
        this.airTickDataItem = new DataWatcher.Item(DataAccessors.AIR_TICK, (Object)Integer.MAX_VALUE);
        this.sizeDataItem = new DataWatcher.Item(DataAccessors.SIZE_DATA, (Object)0);
    }

    public void setLocation(double d, double d2, double d3) {
        this.location.setX(d).setY(d2).setZ(d3);
    }

    public void setSize(int n) {
        this.sizeDataItem.a((Object)n);
        this.sizeDataItem.a(true);
    }

    public PacketPlayOutSpawnEntity spawn() {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.entityId);
        packetDataSerializer.a(this.uuid);
        packetDataSerializer.d(IRegistry.W.a((Object)EntityTypes.aD));
        packetDataSerializer.writeDouble(this.location.getX());
        packetDataSerializer.writeDouble(this.location.getY());
        packetDataSerializer.writeDouble(this.location.getZ());
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeInt(0);
        packetDataSerializer.writeShort(0);
        packetDataSerializer.writeShort(0);
        packetDataSerializer.writeShort(0);
        return new PacketPlayOutSpawnEntity(packetDataSerializer);
    }

    public PacketPlayOutEntityMetadata meta() {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.entityId);
        DataWatcher.a(List.of(this.commonDataItem, this.airTickDataItem, this.sizeDataItem), (PacketDataSerializer)packetDataSerializer);
        return new PacketPlayOutEntityMetadata(packetDataSerializer);
    }

    public PacketPlayOutAttachEntity leash(int n) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.writeInt(this.entityId);
        packetDataSerializer.writeInt(n);
        return new PacketPlayOutAttachEntity(packetDataSerializer);
    }

    public PacketPlayOutEntityTeleport updatePosition(Vector vector) {
        if (TMath.isSimilar(this.location, vector)) {
            return null;
        }
        this.location.zero().add(vector);
        return this.createTeleportPacket(vector.getX(), vector.getY(), vector.getZ());
    }

    public PacketPlayOutEntityTeleport updatePositionCalibrated(Vector vector) {
        if (TMath.isSimilar(this.location, vector)) {
            if (this.sendCancelPacket) {
                this.sendCancelPacket = false;
                return this.createTeleportPacket(this.location.getX(), this.location.getY(), this.location.getZ());
            }
            return null;
        }
        this.sendCancelPacket = true;
        Vector vector2 = this.location.clone();
        this.location.zero().add(vector);
        vector = TMath.lerp(vector2, vector, 3.0);
        return this.createTeleportPacket(vector.getX(), vector.getY(), vector.getZ());
    }

    public PacketPlayOutMount addPassenger(int n) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.entityId);
        packetDataSerializer.d(1);
        packetDataSerializer.d(n);
        return new PacketPlayOutMount(packetDataSerializer);
    }

    private PacketPlayOutEntityTeleport createTeleportPacket(double d, double d2, double d3) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.entityId);
        packetDataSerializer.writeDouble(d);
        packetDataSerializer.writeDouble(d2);
        packetDataSerializer.writeDouble(d3);
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeBoolean(false);
        return new PacketPlayOutEntityTeleport(packetDataSerializer);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Vector getLocation() {
        return this.location;
    }
}

