/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_0_R1.world;

import com.google.common.collect.Lists;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.nms.world.WorldHandler;
import com.ticxo.modelengine.api.utils.math.OrientedBoundingBox;
import com.ticxo.modelengine.api.utils.math.TMath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R1.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftRayTraceResult;
import org.bukkit.entity.Entity;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Consumer;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class WorldHandlerImpl
implements WorldHandler {
    @Override
    public RayTraceResult asyncRayTrace(Location location, Vector vector, double d, FluidCollisionMode fluidCollisionMode, boolean bl, double d2, Predicate<Entity> predicate) {
        RayTraceResult rayTraceResult = this.asyncRayTraceBlocks(location, vector, d, fluidCollisionMode, bl);
        Vector vector2 = null;
        double d3 = d;
        if (rayTraceResult != null) {
            vector2 = location.toVector();
            d3 = TMath.fastSqrt(vector2.distanceSquared(rayTraceResult.getHitPosition()));
        }
        RayTraceResult rayTraceResult2 = this.asyncRayTraceEntities(location, vector, d3, d2, predicate);
        if (rayTraceResult == null) {
            return rayTraceResult2;
        }
        if (rayTraceResult2 == null) {
            return rayTraceResult;
        }
        double d4 = vector2.distanceSquared(rayTraceResult2.getHitPosition());
        return d4 < d3 * d3 ? rayTraceResult2 : rayTraceResult;
    }

    private RayTraceResult asyncRayTraceBlocks(Location location, Vector vector, double d, FluidCollisionMode fluidCollisionMode, boolean bl) {
        if (d < 0.0 || location.getWorld() == null) {
            return null;
        }
        WorldServer worldServer = ((CraftWorld)location.getWorld()).getHandle();
        Vector vector2 = vector.clone().normalize().multiply(d);
        Vec3D vec3D = new Vec3D(location.getX(), location.getY(), location.getZ());
        Vec3D vec3D2 = new Vec3D(location.getX() + vector2.getX(), location.getY() + vector2.getY(), location.getZ() + vector2.getZ());
        MovingObjectPositionBlock movingObjectPositionBlock = worldServer.a(new RayTrace(vec3D, vec3D2, bl ? RayTrace.BlockCollisionOption.a : RayTrace.BlockCollisionOption.b, CraftFluidCollisionMode.toNMS((FluidCollisionMode)fluidCollisionMode), null));
        return CraftRayTraceResult.fromNMS((World)location.getWorld(), (MovingObjectPosition)movingObjectPositionBlock);
    }

    private RayTraceResult asyncRayTraceEntities(Location location, Vector vector, double d, double d2, Predicate<Entity> predicate) {
        if (d < 0.0 || location.getWorld() == null) {
            return null;
        }
        WorldServer worldServer = ((CraftWorld)location.getWorld()).getHandle();
        Vector vector2 = location.toVector();
        Vector vector3 = vector.clone().normalize().multiply(d);
        BoundingBox boundingBox2 = BoundingBox.of((Vector)vector2, (Vector)vector2).expandDirectional(vector3).expand(d2);
        Collection<Entity> collection = this.asyncGetNearbyEntities(worldServer, boundingBox2, predicate);
        Entity entity = null;
        RayTraceResult rayTraceResult = null;
        double d3 = Double.MAX_VALUE;
        for (Entity entity2 : collection) {
            double d4;
            RayTraceResult rayTraceResult2;
            SubHitbox subHitbox = ModelEngineAPI.getModelTicker().getSubHitboxBone(entity2.getUniqueId());
            if (subHitbox != null && subHitbox.isOBB()) {
                var21_18 = subHitbox.getSubHitboxEntity().getObbInstance();
                if (var21_18 == null) continue;
                rayTraceResult2 = ((OrientedBoundingBox)var21_18).rayTrace(vector2, vector, d, (Consumer<BoundingBox>)((Consumer)boundingBox -> boundingBox.expand(d2)));
            } else {
                var21_18 = entity2.getBoundingBox().expand(d2);
                rayTraceResult2 = var21_18.rayTrace(vector2, vector, d);
            }
            if (rayTraceResult2 == null || !((d4 = vector2.distanceSquared(rayTraceResult2.getHitPosition())) < d3)) continue;
            entity = entity2;
            rayTraceResult = rayTraceResult2;
            d3 = d4;
        }
        return entity == null ? null : new RayTraceResult(rayTraceResult.getHitPosition(), entity, rayTraceResult.getHitBlockFace());
    }

    private Collection<Entity> asyncGetNearbyEntities(WorldServer worldServer, BoundingBox boundingBox, Predicate<Entity> predicate) {
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        List<net.minecraft.world.entity.Entity> list = this.asyncGetEntities(worldServer, axisAlignedBB, entity -> true);
        ArrayList<Entity> arrayList = new ArrayList<Entity>(list.size());
        Iterator<net.minecraft.world.entity.Entity> iterator = list.iterator();
        while (iterator.hasNext()) {
            net.minecraft.world.entity.Entity entity2 = iterator.next();
            CraftEntity craftEntity = entity2.getBukkitEntity();
            if (predicate != null && !predicate.test((Entity)craftEntity)) continue;
            arrayList.add((Entity)craftEntity);
        }
        return arrayList;
    }

    private List<net.minecraft.world.entity.Entity> asyncGetEntities(WorldServer worldServer, AxisAlignedBB axisAlignedBB, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        ArrayList arrayList = Lists.newArrayList();
        try {
            worldServer.P.d().a(axisAlignedBB, entity -> {
                if (entity != null && predicate.test((net.minecraft.world.entity.Entity)entity)) {
                    arrayList.add(entity);
                }
                if (entity instanceof EntityEnderDragon) {
                    EntityComplexPart[] entityComplexPartArray;
                    for (EntityComplexPart entityComplexPart : entityComplexPartArray = ((EntityEnderDragon)entity).t()) {
                        if (!predicate.test((net.minecraft.world.entity.Entity)entityComplexPart)) continue;
                        arrayList.add(entityComplexPart);
                    }
                }
            });
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return arrayList;
    }
}

