/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_1_R1.entity.controller;

import com.ticxo.modelengine.api.command.annotations.CommandAccessible;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.utils.math.TMath;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;

@CommandAccessible(value={BodyRotationController.class})
public class BodyRotationControlWrapper
extends EntityAIBodyControl
implements BodyRotationController {
    private final EntityInsentient mob;
    private boolean isHeadClampUneven;
    private boolean isBodyClampUneven;
    private float maxHeadAngle;
    private float maxBodyAngle;
    private float minHeadAngle;
    private float minBodyAngle;
    private boolean playerMode;
    private float stableAngle = 15.0f;
    private int rotationDelay = 10;
    private int rotationDuration = 10;
    private int headStableTime;
    private float lastStableYHeadRot;

    public BodyRotationControlWrapper(EntityInsentient entityInsentient) {
        super(entityInsentient);
        this.mob = entityInsentient;
        this.maxHeadAngle = entityInsentient.V();
        this.maxBodyAngle = entityInsentient.V();
        this.minHeadAngle = -this.maxHeadAngle;
        this.minBodyAngle = -this.minBodyAngle;
    }

    public void a() {
        if (this.isMoving()) {
            this.mob.aX = this.mob.dq();
            this.rotateHeadIfNecessary();
            this.lastStableYHeadRot = this.mob.aZ;
            this.headStableTime = 0;
        } else if (this.notCarryingMobPassengers()) {
            if (Math.abs(this.mob.aZ - this.lastStableYHeadRot) > this.stableAngle) {
                this.headStableTime = 0;
                this.lastStableYHeadRot = this.mob.aZ;
                this.rotateBodyIfNecessary();
            } else if (!this.playerMode) {
                ++this.headStableTime;
                if (this.headStableTime > this.rotationDelay) {
                    this.rotateHeadTowardsFront();
                }
            }
        }
    }

    @Override
    public void setYHeadRot(float f) {
        this.mob.aZ = f;
    }

    @Override
    public float getYHeadRot() {
        return this.mob.aZ;
    }

    @Override
    public float getXHeadRot() {
        return this.mob.ds();
    }

    @Override
    public void setYBodyRot(float f) {
        this.mob.aX = f;
    }

    @Override
    public float getYBodyRot() {
        return this.mob.aX;
    }

    private void rotateBodyIfNecessary() {
        this.mob.aX = TMath.rotateIfNecessary(this.mob.aX, this.mob.aZ, this.isBodyClampUneven ? this.minBodyAngle : -this.maxBodyAngle, this.maxBodyAngle);
    }

    private void rotateHeadIfNecessary() {
        this.mob.aZ = TMath.rotateIfNecessary(this.mob.aZ, this.mob.aX, this.isHeadClampUneven ? this.minHeadAngle : -this.maxHeadAngle, this.maxHeadAngle);
    }

    private void rotateHeadTowardsFront() {
        float f = (float)(this.headStableTime - this.rotationDelay) / (float)this.rotationDuration;
        float f2 = TMath.clamp(f, 0.0f, 1.0f);
        float f3 = this.maxHeadAngle * (1.0f - f2);
        float f4 = (this.isHeadClampUneven ? this.minHeadAngle : -this.maxHeadAngle) * (1.0f - f2);
        this.mob.aX = TMath.rotateIfNecessary(this.mob.aX, this.mob.aZ, f4, f3);
    }

    private boolean notCarryingMobPassengers() {
        return !(this.mob.cJ() instanceof EntityInsentient);
    }

    private boolean isMoving() {
        double d;
        double d2 = this.mob.df() - this.mob.t;
        return d2 * d2 + (d = this.mob.dl() - this.mob.v) * d > 2.500000277905201E-7;
    }

    @Override
    public boolean isHeadClampUneven() {
        return this.isHeadClampUneven;
    }

    @Override
    public void setHeadClampUneven(boolean bl) {
        this.isHeadClampUneven = bl;
    }

    @Override
    public boolean isBodyClampUneven() {
        return this.isBodyClampUneven;
    }

    @Override
    public void setBodyClampUneven(boolean bl) {
        this.isBodyClampUneven = bl;
    }

    @Override
    public float getMaxHeadAngle() {
        return this.maxHeadAngle;
    }

    @Override
    public void setMaxHeadAngle(float f) {
        this.maxHeadAngle = f;
    }

    @Override
    public float getMaxBodyAngle() {
        return this.maxBodyAngle;
    }

    @Override
    public void setMaxBodyAngle(float f) {
        this.maxBodyAngle = f;
    }

    @Override
    public float getMinHeadAngle() {
        return this.minHeadAngle;
    }

    @Override
    public void setMinHeadAngle(float f) {
        this.minHeadAngle = f;
    }

    @Override
    public float getMinBodyAngle() {
        return this.minBodyAngle;
    }

    @Override
    public void setMinBodyAngle(float f) {
        this.minBodyAngle = f;
    }

    @Override
    public boolean isPlayerMode() {
        return this.playerMode;
    }

    @Override
    public void setPlayerMode(boolean bl) {
        this.playerMode = bl;
    }

    @Override
    public float getStableAngle() {
        return this.stableAngle;
    }

    @Override
    public void setStableAngle(float f) {
        this.stableAngle = f;
    }

    @Override
    public int getRotationDelay() {
        return this.rotationDelay;
    }

    @Override
    public void setRotationDelay(int n) {
        this.rotationDelay = n;
    }

    @Override
    public int getRotationDuration() {
        return this.rotationDuration;
    }

    @Override
    public void setRotationDuration(int n) {
        this.rotationDuration = n;
    }
}

