/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_R2.entity.fake;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.nms.entity.fake.FakeEntity;
import com.ticxo.modelengine.api.utils.ComponentUtil;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.nms.v1_19_R2.NMSUtils;
import com.ticxo.modelengine.nms.v1_19_R2.entity.fake.DataAccessors;
import com.ticxo.modelengine.nms.v1_19_R2.network.NetworkUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.Vector3f;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_19_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R2.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class FakeArmorStand {
    private final int entityId;
    private final UUID uuid;
    private final Vector location = new Vector();
    private byte lastYaw;
    private Vector lastOffset;
    private boolean sendCancelPacket;
    private boolean isInvisible = false;
    private boolean isGlowing = false;
    private final DataWatcher.Item<Byte> commonDataItem;
    private final DataWatcher.Item<Integer> airTickDataItem;
    private final DataWatcher.Item<Optional<IChatBaseComponent>> customNameDataItem;
    private final DataWatcher.Item<Boolean> customNameVisibleDataItem;
    private boolean isCustomNameVisible = false;
    private boolean isSmall = false;
    private final DataWatcher.Item<Byte> standDataItem;
    private Vector3f rotation;
    private DataWatcher.Item<Vector3f> rotationDataItem;
    private FakeEntity.DisplaySlot display = FakeEntity.DisplaySlot.ZERO;

    public FakeArmorStand(double d, double d2, double d3) {
        this.entityId = ModelEngineAPI.getEntityHandler().getEntityCounter().incrementAndGet();
        this.uuid = UUID.randomUUID();
        this.location.setX(d).setY(d2).setZ(d3);
        this.commonDataItem = new DataWatcher.Item(DataAccessors.COMMON_DATA, (Object)0);
        this.airTickDataItem = new DataWatcher.Item(DataAccessors.AIR_TICK, (Object)Integer.MAX_VALUE);
        this.customNameDataItem = new DataWatcher.Item(DataAccessors.CUSTOM_NAME, Optional.empty());
        this.customNameVisibleDataItem = new DataWatcher.Item(DataAccessors.CUSTOM_NAME_VISIBLE, (Object)false);
        this.standDataItem = new DataWatcher.Item(DataAccessors.STAND_DATA, (Object)16);
        this.rotationDataItem = new DataWatcher.Item(DataAccessors.HEAD_POSE, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public void setLocation(double d, double d2, double d3) {
        this.location.setX(d).setY(d2).setZ(d3);
    }

    public PacketPlayOutSpawnEntity spawn() {
        return this.spawn(0.0f);
    }

    public PacketPlayOutSpawnEntity spawn(float f) {
        byte by = TMath.rotToByte(f);
        this.updateOffset(by);
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.entityId);
        packetDataSerializer.a(this.uuid);
        packetDataSerializer.d(BuiltInRegistries.h.a((Object)EntityTypes.d));
        packetDataSerializer.writeDouble(this.location.getX() + this.lastOffset.getX());
        packetDataSerializer.writeDouble(this.location.getY() + this.lastOffset.getY());
        packetDataSerializer.writeDouble(this.location.getZ() + this.lastOffset.getZ());
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeByte((int)by);
        packetDataSerializer.writeInt(0);
        packetDataSerializer.writeShort(0);
        packetDataSerializer.writeShort(0);
        packetDataSerializer.writeShort(0);
        return new PacketPlayOutSpawnEntity(packetDataSerializer);
    }

    public PacketPlayOutEntityMetadata updateMeta(boolean bl) {
        List<DataWatcher.Item<?>> list = this.packData(bl);
        if (list.isEmpty()) {
            return null;
        }
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.entityId);
        NetworkUtils.pack(list, packetDataSerializer);
        return new PacketPlayOutEntityMetadata(packetDataSerializer);
    }

    public Packet<PacketListenerPlayOut> updatePosition(Vector vector) {
        return this.updatePosition(0.0f, vector);
    }

    public Packet<PacketListenerPlayOut> updatePosition(float f, Vector vector) {
        byte by = TMath.rotToByte(f);
        if (TMath.isSimilar(this.location, vector)) {
            if (this.lastYaw == by) {
                return null;
            }
            Vector vector2 = this.lastOffset.clone();
            this.updateOffset(by);
            if (TMath.isSimilar(vector2, this.lastOffset)) {
                return this.createYawPacket(by);
            }
            return this.createTeleportPacket(this.location.getX() + this.lastOffset.getX(), this.location.getY() + this.lastOffset.getY(), this.location.getZ() + this.lastOffset.getZ(), this.lastYaw);
        }
        if (this.lastYaw != by) {
            this.updateOffset(by);
        }
        this.location.zero().add(vector);
        return this.createTeleportPacket(this.location.getX() + this.lastOffset.getX(), this.location.getY() + this.lastOffset.getY(), this.location.getZ() + this.lastOffset.getZ(), by);
    }

    public Packet<PacketListenerPlayOut> updatePositionCalibrated(Vector vector) {
        return this.updatePositionCalibrated(0.0f, vector);
    }

    public Packet<PacketListenerPlayOut> updatePositionCalibrated(float f, Vector vector) {
        byte by = TMath.rotToByte(f);
        if (TMath.isSimilar(this.location, vector)) {
            if (this.lastYaw == by) {
                if (!this.sendCancelPacket) {
                    return null;
                }
                this.sendCancelPacket = false;
                return this.createTeleportPacket(this.location.getX() + this.lastOffset.getX(), this.location.getY() + this.lastOffset.getY(), this.location.getZ() + this.lastOffset.getZ(), this.lastYaw);
            }
            Vector vector2 = this.lastOffset.clone();
            this.updateOffset(by);
            if (TMath.isSimilar(vector2, this.lastOffset)) {
                return this.createYawPacket(by);
            }
            this.sendCancelPacket = true;
            vector2 = TMath.lerp(vector2, this.lastOffset, 3.0);
            return this.createTeleportPacket(this.location.getX() + vector2.getX(), this.location.getY() + vector2.getY(), this.location.getZ() + vector2.getZ(), this.lastYaw);
        }
        Vector vector3 = new Vector(this.location.getX() + this.lastOffset.getX(), this.location.getY() + this.lastOffset.getY(), this.location.getZ() + this.lastOffset.getZ());
        if (this.lastYaw != by) {
            this.updateOffset(by);
        }
        this.location.zero().add(vector);
        Vector vector4 = new Vector(this.location.getX() + this.lastOffset.getX(), this.location.getY() + this.lastOffset.getY(), this.location.getZ() + this.lastOffset.getZ());
        this.sendCancelPacket = true;
        vector4 = TMath.lerp(vector3, vector4, 3.0);
        return this.createTeleportPacket(vector4.getX(), vector4.getY(), vector4.getZ(), by);
    }

    private PacketPlayOutEntityTeleport createTeleportPacket(double d, double d2, double d3, byte by) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.entityId);
        packetDataSerializer.writeDouble(d);
        packetDataSerializer.writeDouble(d2);
        packetDataSerializer.writeDouble(d3);
        packetDataSerializer.writeByte((int)by);
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeBoolean(false);
        return new PacketPlayOutEntityTeleport(packetDataSerializer);
    }

    public PacketPlayOutEntity.PacketPlayOutEntityLook updateYaw(float f, boolean bl) {
        byte by = TMath.rotToByte(f);
        if (!bl && this.lastYaw == by) {
            return null;
        }
        this.lastYaw = by;
        return this.createYawPacket(by);
    }

    private PacketPlayOutEntity.PacketPlayOutEntityLook createYawPacket(byte by) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.entityId);
        packetDataSerializer.writeByte((int)by);
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeBoolean(false);
        return PacketPlayOutEntity.PacketPlayOutEntityLook.b((PacketDataSerializer)packetDataSerializer);
    }

    public PacketPlayOutEntityEquipment updateEquipment(ItemStack itemStack) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.entityId);
        packetDataSerializer.writeByte(switch (this.display) {
            case FakeEntity.DisplaySlot.MAIN_HAND -> 0;
            case FakeEntity.DisplaySlot.OFF_HAND -> 1;
            default -> 5;
        });
        packetDataSerializer.a(CraftItemStack.asNMSCopy((ItemStack)itemStack));
        return new PacketPlayOutEntityEquipment(packetDataSerializer);
    }

    public PacketPlayOutMount addPassengers(Set<Entity> set) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.entityId);
        packetDataSerializer.d(set.size());
        for (Entity entity : set) {
            packetDataSerializer.d(entity.getEntityId());
        }
        return new PacketPlayOutMount(packetDataSerializer);
    }

    public void setInvisible(boolean bl) {
        if (this.isInvisible == bl) {
            return;
        }
        this.isInvisible = bl;
        NMSUtils.setBit(this.commonDataItem, 5, bl);
        this.commonDataItem.a(true);
    }

    public void setGlowing(boolean bl) {
        if (this.isGlowing == bl) {
            return;
        }
        this.isGlowing = bl;
        NMSUtils.setBit(this.commonDataItem, 6, bl);
        this.commonDataItem.a(true);
    }

    public void setCustomName(String string) {
        IChatMutableComponent iChatMutableComponent = IChatBaseComponent.ChatSerializer.a((String)ComponentUtil.getStringAsJson(string));
        this.customNameDataItem.a(Optional.ofNullable(iChatMutableComponent));
        this.customNameDataItem.a(true);
    }

    public void setCustomNameVisible(boolean bl) {
        if (bl == this.isCustomNameVisible) {
            return;
        }
        this.isCustomNameVisible = bl;
        this.customNameVisibleDataItem.a((Object)bl);
        this.customNameVisibleDataItem.a(true);
    }

    public void setSmall(boolean bl) {
        if (this.isSmall == bl) {
            return;
        }
        this.isSmall = bl;
        NMSUtils.setBit(this.standDataItem, 0, bl);
        this.standDataItem.a(true);
    }

    public void setRotation(EulerAngle eulerAngle) {
        Vector3f vector3f = NMSUtils.toNMS(eulerAngle);
        if (vector3f.equals((Object)this.rotation)) {
            return;
        }
        this.rotation = vector3f;
        this.rotationDataItem.a((Object)vector3f);
        this.rotationDataItem.a(true);
    }

    public void setDisplay(FakeEntity.DisplaySlot displaySlot) {
        if (this.display == displaySlot) {
            return;
        }
        this.display = displaySlot;
        this.rotationDataItem = switch (displaySlot) {
            case FakeEntity.DisplaySlot.MAIN_HAND -> new DataWatcher.Item(DataAccessors.MAIN_ARM_POSE, (Object)this.rotation);
            case FakeEntity.DisplaySlot.OFF_HAND -> new DataWatcher.Item(DataAccessors.OFF_ARM_POSE, (Object)this.rotation);
            default -> new DataWatcher.Item(DataAccessors.HEAD_POSE, (Object)this.rotation);
        };
        this.rotationDataItem.a(true);
    }

    public void createRealRenderer(org.bukkit.World world, ItemStack itemStack) {
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        EntityArmorStand entityArmorStand = new EntityArmorStand(EntityTypes.d, (World)worldServer);
        entityArmorStand.f(this.location.getX() + this.lastOffset.getX(), this.location.getY() + this.lastOffset.getY(), this.location.getZ() + this.lastOffset.getZ());
        entityArmorStand.p((float)this.lastYaw);
        entityArmorStand.m((float)this.lastYaw);
        entityArmorStand.l((float)this.lastYaw);
        entityArmorStand.t(true);
        entityArmorStand.a(this.isSmall());
        entityArmorStand.e(true);
        entityArmorStand.j(true);
        entityArmorStand.a(this.rotation);
        entityArmorStand.setItemSlot(EnumItemSlot.f, CraftItemStack.asNMSCopy((ItemStack)itemStack), true);
        worldServer.b((net.minecraft.world.entity.Entity)entityArmorStand);
    }

    private List<DataWatcher.Item<?>> packData(boolean bl) {
        if (bl) {
            return List.of(this.commonDataItem, this.airTickDataItem, this.customNameDataItem, this.customNameVisibleDataItem, this.standDataItem, this.rotationDataItem);
        }
        ArrayList arrayList = new ArrayList();
        this.addDirtyData(arrayList, this.commonDataItem);
        this.addDirtyData(arrayList, this.airTickDataItem);
        this.addDirtyData(arrayList, this.customNameDataItem);
        this.addDirtyData(arrayList, this.customNameVisibleDataItem);
        this.addDirtyData(arrayList, this.standDataItem);
        this.addDirtyData(arrayList, this.rotationDataItem);
        return arrayList;
    }

    private void addDirtyData(List<DataWatcher.Item<?>> list, DataWatcher.Item<?> item) {
        if (item.c()) {
            list.add(item);
            item.a(false);
        }
    }

    private void updateOffset(byte by) {
        if (this.lastYaw == by && this.lastOffset != null) {
            return;
        }
        this.lastYaw = by;
        this.lastOffset = this.display.getPivotOffset(this.isSmall, by);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Vector getLocation() {
        return this.location;
    }

    public boolean isInvisible() {
        return this.isInvisible;
    }

    public boolean isGlowing() {
        return this.isGlowing;
    }

    public boolean isSmall() {
        return this.isSmall;
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public FakeEntity.DisplaySlot getDisplay() {
        return this.display;
    }
}

