/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_R3.entity;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.model.AnimationMode;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.nms.entity.EntityHandler;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.api.nms.entity.fake.DummyRangeEntity;
import com.ticxo.modelengine.api.nms.entity.fake.HandRenderer;
import com.ticxo.modelengine.api.nms.entity.fake.LeashPoint;
import com.ticxo.modelengine.api.nms.entity.fake.MountPoint;
import com.ticxo.modelengine.api.nms.entity.fake.NametagPoint;
import com.ticxo.modelengine.api.nms.entity.fake.SubHitboxEntity;
import com.ticxo.modelengine.api.nms.entity.fake.VFXRenderer;
import com.ticxo.modelengine.api.nms.entity.hitbox.DynamicHitbox;
import com.ticxo.modelengine.api.nms.entity.hitbox.ModelHitbox;
import com.ticxo.modelengine.api.nms.entity.impl.EmptyLookController;
import com.ticxo.modelengine.api.nms.entity.impl.EmptyMoveController;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.nms.entity.wrapper.LookController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.api.nms.world.IDamageSource;
import com.ticxo.modelengine.api.utils.FieldUtils;
import com.ticxo.modelengine.api.utils.RaceConditionUtil;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import com.ticxo.modelengine.nms.v1_19_R3.NMSFields;
import com.ticxo.modelengine.nms.v1_19_R3.NMSUtils;
import com.ticxo.modelengine.nms.v1_19_R3.entity.controller.BodyRotationControlWrapper;
import com.ticxo.modelengine.nms.v1_19_R3.entity.controller.LookControlWrapper;
import com.ticxo.modelengine.nms.v1_19_R3.entity.controller.MoveControlWrapper;
import com.ticxo.modelengine.nms.v1_19_R3.entity.controller.special.VexMoveControlWrapper;
import com.ticxo.modelengine.nms.v1_19_R3.entity.fake.DataAccessors;
import com.ticxo.modelengine.nms.v1_19_R3.entity.fake.bone.BoneRendererImplAC;
import com.ticxo.modelengine.nms.v1_19_R3.entity.fake.bone.BoneRendererImplB;
import com.ticxo.modelengine.nms.v1_19_R3.entity.fake.bone.HandRendererImplAC;
import com.ticxo.modelengine.nms.v1_19_R3.entity.fake.bone.HandRendererImplB;
import com.ticxo.modelengine.nms.v1_19_R3.entity.fake.bone.LeashPointImplAC;
import com.ticxo.modelengine.nms.v1_19_R3.entity.fake.bone.LeashPointImplB;
import com.ticxo.modelengine.nms.v1_19_R3.entity.fake.bone.MountPointImplAC;
import com.ticxo.modelengine.nms.v1_19_R3.entity.fake.bone.MountPointImplB;
import com.ticxo.modelengine.nms.v1_19_R3.entity.fake.bone.NametagPointImplAC;
import com.ticxo.modelengine.nms.v1_19_R3.entity.fake.bone.NametagPointImplB;
import com.ticxo.modelengine.nms.v1_19_R3.entity.fake.bone.SubHitboxEntityImpl;
import com.ticxo.modelengine.nms.v1_19_R3.entity.fake.hitbox.DynamicHitboxImpl;
import com.ticxo.modelengine.nms.v1_19_R3.entity.fake.hitbox.ModelHitboxImpl;
import com.ticxo.modelengine.nms.v1_19_R3.entity.fake.vfx.VFXRendererImpl;
import com.ticxo.modelengine.nms.v1_19_R3.entity.navigation.AmphibiousNavigationWrapper;
import com.ticxo.modelengine.nms.v1_19_R3.entity.navigation.FlyingNavigationWrapper;
import com.ticxo.modelengine.nms.v1_19_R3.entity.navigation.GroundNavigationWrapper;
import com.ticxo.modelengine.nms.v1_19_R3.entity.navigation.WallClimberNavigationWrapper;
import com.ticxo.modelengine.nms.v1_19_R3.entity.navigation.WaterBoundNavigationWrapper;
import com.ticxo.modelengine.nms.v1_19_R3.entity.range.DummyRangeEntityImpl;
import com.ticxo.modelengine.nms.v1_19_R3.entity.range.PlayerRangeManagerImpl;
import com.ticxo.modelengine.nms.v1_19_R3.entity.range.RangeManagerImpl;
import com.ticxo.modelengine.nms.v1_19_R3.network.NetworkUtils;
import com.ticxo.modelengine.nms.v1_19_R3.world.DamageSourceWrapper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.navigation.NavigationSpider;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftMob;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityHandlerImpl
implements EntityHandler {
    private final DynamicHitbox dynamicHitbox;
    private AtomicInteger entityCounter;
    private final DataWatcher.Item<Byte> commonDataItem;
    private final List<DataWatcher.Item<?>> commonDataList;

    public EntityHandlerImpl() {
        try {
            this.entityCounter = (AtomicInteger)FieldUtils.getField(net.minecraft.world.entity.Entity.class, NMSFields.ENTITY_ENTITY_COUNTER).get(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.dynamicHitbox = new DynamicHitboxImpl(this.entityCounter);
        this.commonDataItem = new DataWatcher.Item(DataAccessors.COMMON_DATA, (Object)0);
        this.commonDataList = List.of(this.commonDataItem);
    }

    @Override
    public void setHitbox(Entity entity, @NotNull Hitbox hitbox) {
        net.minecraft.world.entity.Entity entity2 = ((CraftEntity)entity).getHandle();
        try {
            EntitySize entitySize = new EntitySize((float)hitbox.getMaxWidth(), (float)hitbox.getHeight(), true);
            FieldUtils.getField(net.minecraft.world.entity.Entity.class, NMSFields.ENTITY_dimensions).set(entity2, entitySize);
            FieldUtils.getField(net.minecraft.world.entity.Entity.class, NMSFields.ENTITY_eyeHeight).setFloat(entity2, (float)hitbox.getEyeHeight());
            entity2.a(entitySize.a(entity2.de()));
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    @Override
    public void setStepHeight(Entity entity, double d) {
        ((CraftEntity)entity).getHandle().v((float)d);
    }

    @Override
    public MoveController wrapMoveControl(Entity entity) {
        Mob mob;
        Entity entity2;
        block8: {
            block7: {
                entity2 = entity;
                if (!(entity2 instanceof Mob)) break block7;
                mob = (Mob)entity2;
                if (!(entity instanceof Slime)) break block8;
            }
            return new EmptyMoveController();
        }
        entity2 = ((CraftMob)mob).getHandle();
        try {
            MoveControlWrapper moveControlWrapper;
            ControllerMove controllerMove = entity2.D();
            ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(entity.getUniqueId());
            Entity entity3 = entity2;
            if (entity3 instanceof EntityVex) {
                EntityVex entityVex = (EntityVex)entity3;
                moveControlWrapper = new VexMoveControlWrapper(entityVex, controllerMove, modeledEntity);
            } else {
                moveControlWrapper = new MoveControlWrapper((EntityInsentient)entity2, controllerMove, modeledEntity);
            }
            FieldUtils.getField(EntityInsentient.class, NMSFields.MOB_moveControl).set(entity2, moveControlWrapper);
            return moveControlWrapper;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return new EmptyMoveController();
        }
    }

    @Override
    public LookController wrapLookControl(Entity entity) {
        Entity entity2 = entity;
        if (!(entity2 instanceof Mob)) {
            return new EmptyLookController();
        }
        Mob mob = (Mob)entity2;
        entity2 = ((CraftMob)mob).getHandle();
        try {
            ControllerLook controllerLook = entity2.C();
            ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(entity.getUniqueId());
            LookControlWrapper lookControlWrapper = new LookControlWrapper((EntityInsentient)entity2, controllerLook, modeledEntity);
            FieldUtils.getField(EntityInsentient.class, NMSFields.MOB_lookControl).set(entity2, lookControlWrapper);
            return lookControlWrapper;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return new EmptyLookController();
        }
    }

    @Override
    @Nullable
    public BodyRotationController wrapBodyRotationControl(Entity entity) {
        Entity entity2 = entity;
        if (!(entity2 instanceof Mob)) {
            return null;
        }
        Mob mob = (Mob)entity2;
        entity2 = ((CraftMob)mob).getHandle();
        try {
            BodyRotationControlWrapper bodyRotationControlWrapper = new BodyRotationControlWrapper((EntityInsentient)entity2);
            FieldUtils.getField(EntityInsentient.class, NMSFields.MOB_bodyRotationControl).set(entity2, bodyRotationControlWrapper);
            return bodyRotationControlWrapper;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    @Override
    public void wrapNavigation(Entity entity) {
        Entity entity2 = entity;
        if (!(entity2 instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity2;
        entity2 = ((CraftMob)mob).getHandle();
        try {
            NavigationFlying navigationFlying;
            Object object;
            NavigationAbstract navigationAbstract;
            Field field = FieldUtils.getField(EntityInsentient.class, NMSFields.MOB_navigation);
            NavigationAbstract navigationAbstract2 = navigationAbstract = entity2.G();
            if (navigationAbstract2 instanceof NavigationSpider) {
                NavigationSpider navigationSpider = (NavigationSpider)navigationAbstract2;
                object = new WallClimberNavigationWrapper((EntityInsentient)entity2, navigationSpider);
            } else {
                navigationAbstract2 = navigationAbstract;
                if (navigationAbstract2 instanceof Navigation) {
                    Navigation navigation = (Navigation)navigationAbstract2;
                    object = new GroundNavigationWrapper((EntityInsentient)entity2, navigation);
                } else {
                    navigationAbstract2 = navigationAbstract;
                    if (navigationAbstract2 instanceof NavigationFlying) {
                        navigationFlying = (NavigationFlying)navigationAbstract2;
                        object = new FlyingNavigationWrapper((EntityInsentient)entity2, navigationFlying);
                    } else if (navigationAbstract instanceof NavigationGuardian) {
                        object = new WaterBoundNavigationWrapper((EntityInsentient)entity2);
                    } else {
                        navigationAbstract2 = navigationAbstract;
                        if (navigationAbstract2 instanceof AmphibiousPathNavigation) {
                            AmphibiousPathNavigation amphibiousPathNavigation = (AmphibiousPathNavigation)navigationAbstract2;
                            object = new AmphibiousNavigationWrapper((EntityInsentient)entity2, amphibiousPathNavigation);
                        } else {
                            TLogger.warn("Failed to create custom navigation for " + mob.getType() + ": " + mob.getUniqueId());
                            TLogger.warn("Reason: Navigation class type is " + navigationAbstract.getClass().getSimpleName() + ".");
                            return;
                        }
                    }
                }
            }
            field.set(entity2, object);
            navigationFlying = (PathfinderGoalSelector)FieldUtils.getField(EntityInsentient.class, NMSFields.MOB_goalSelector).get(entity2);
            RaceConditionUtil.wrapConmod(() -> this.lambda$wrapNavigation$0((PathfinderGoalSelector)navigationFlying, (NavigationAbstract)object));
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    private void replaceNavigation(PathfinderGoalSelector pathfinderGoalSelector, NavigationAbstract navigationAbstract) {
        try {
            for (PathfinderGoalWrapped pathfinderGoalWrapped : pathfinderGoalSelector.b()) {
                PathfinderGoal pathfinderGoal = pathfinderGoalWrapped.k();
                for (Field field : pathfinderGoal.getClass().getDeclaredFields()) {
                    field = FieldUtils.getField(pathfinderGoal.getClass(), field.getName());
                    Object object = field.get(pathfinderGoal);
                    if (!(object instanceof NavigationAbstract)) continue;
                    field.set(pathfinderGoal, navigationAbstract);
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    @Override
    public RangeManager wrapRangeManager(Entity entity) {
        WorldServer worldServer = ((CraftWorld)entity.getWorld()).getHandle();
        Int2ObjectMap int2ObjectMap = worldServer.k().a.L;
        Entity entity2 = entity;
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            return new PlayerRangeManagerImpl(player, () -> EntityHandlerImpl.lambda$wrapRangeManager$1((Map)int2ObjectMap, entity));
        }
        return new RangeManagerImpl(((CraftEntity)entity).getHandle(), () -> EntityHandlerImpl.lambda$wrapRangeManager$2((Map)int2ObjectMap, entity));
    }

    @Override
    public boolean hurt(Entity entity, IDamageSource iDamageSource, float f) {
        net.minecraft.world.entity.Entity entity2 = ((CraftEntity)entity).getHandle();
        DamageSource damageSource = ((DamageSourceWrapper)iDamageSource).getOriginal();
        return entity2.a(damageSource, f);
    }

    @Override
    public void interact(Entity entity, Player player, EquipmentSlot equipmentSlot) {
        net.minecraft.world.entity.Entity entity2 = ((CraftEntity)entity).getHandle();
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        entity2.a((EntityHuman)entityPlayer, equipmentSlot == EquipmentSlot.HAND ? EnumHand.a : EnumHand.b);
    }

    @Override
    public BoneRenderer createBoneRenderer(ModelBone modelBone) {
        return switch (modelBone.getActiveModel().getAnimationMode()) {
            case AnimationMode.A -> new BoneRendererImplAC(modelBone, false);
            case AnimationMode.B -> new BoneRendererImplB(modelBone);
            case AnimationMode.C -> new BoneRendererImplAC(modelBone, true);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Override
    public MountPoint createMountPoint(ModelBone modelBone) {
        return switch (modelBone.getActiveModel().getAnimationMode()) {
            case AnimationMode.A -> new MountPointImplAC(modelBone, false);
            case AnimationMode.B -> new MountPointImplB(modelBone);
            case AnimationMode.C -> new MountPointImplAC(modelBone, true);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Override
    public NametagPoint createNametagPoint(ModelBone modelBone) {
        return switch (modelBone.getActiveModel().getAnimationMode()) {
            case AnimationMode.A -> new NametagPointImplAC(modelBone, false);
            case AnimationMode.B -> new NametagPointImplB(modelBone);
            case AnimationMode.C -> new NametagPointImplAC(modelBone, true);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Override
    public LeashPoint createLeashPoint(ModelBone modelBone) {
        return switch (modelBone.getActiveModel().getAnimationMode()) {
            case AnimationMode.A -> new LeashPointImplAC(modelBone, false);
            case AnimationMode.B -> new LeashPointImplB(modelBone);
            case AnimationMode.C -> new LeashPointImplAC(modelBone, true);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Override
    public SubHitboxEntity createSubHitboxEntity(ModelBone modelBone) {
        World world = modelBone.getActiveModel().getModeledEntity().getBase().getWorld();
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        SubHitboxEntityImpl subHitboxEntityImpl = new SubHitboxEntityImpl((net.minecraft.world.level.World)worldServer);
        worldServer.n().c(() -> subHitboxEntityImpl.onLevelSync(modelBone));
        return subHitboxEntityImpl;
    }

    @Override
    public HandRenderer createHandRenderer(ModelBone modelBone) {
        return switch (modelBone.getActiveModel().getAnimationMode()) {
            case AnimationMode.A -> new HandRendererImplAC(modelBone, false);
            case AnimationMode.B -> new HandRendererImplB(modelBone);
            case AnimationMode.C -> new HandRendererImplAC(modelBone, true);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Override
    public VFXRenderer createVFXRenderer(VFX vFX) {
        return new VFXRendererImpl(vFX);
    }

    @Override
    public DummyRangeEntity createDummyRangeEntity(BaseEntity<?> baseEntity) {
        return new DummyRangeEntityImpl(baseEntity);
    }

    @Override
    public ModelHitbox createModelHitbox(BaseEntity<?> baseEntity) {
        return new ModelHitboxImpl(baseEntity);
    }

    @Override
    public void broadcastSpawnPacket(BaseEntity<?> baseEntity, boolean bl) {
        Set<Player> set;
        RangeManager rangeManager3;
        RangeManager rangeManager2 = baseEntity.getRangeManager();
        if (bl && (rangeManager3 = rangeManager2) instanceof RangeManager.Disguise) {
            RangeManager.Disguise disguise = (RangeManager.Disguise)((Object)rangeManager3);
            set = disguise.getViewers();
        } else {
            set = rangeManager2.getPlayerInRange();
        }
        for (Player player : set) {
            rangeManager2.forceSpawn(player);
        }
    }

    @Override
    public void broadcastDespawnPacket(BaseEntity<?> baseEntity, boolean bl) {
        RangeManager rangeManager;
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{baseEntity.getEntityId()});
        RangeManager rangeManager2 = baseEntity.getRangeManager();
        if (rangeManager2 == null) {
            return;
        }
        if (bl && (rangeManager = rangeManager2) instanceof RangeManager.Disguise) {
            RangeManager.Disguise disguise = (RangeManager.Disguise)((Object)rangeManager);
            NetworkUtils.send(disguise.getViewers(), new Packet[]{packetPlayOutEntityDestroy});
        } else {
            NetworkUtils.send(rangeManager2.getPlayerInRange(), new Packet[]{packetPlayOutEntityDestroy});
        }
    }

    @Override
    public void hideBoundSubHitboxEntity(ModeledEntity modeledEntity, Entity entity) {
        RangeManager rangeManager = this.wrapRangeManager(entity);
        rangeManager.setRenderDistance(0);
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{entity.getEntityId()});
        RangeManager rangeManager2 = modeledEntity.getRangeManager();
        NetworkUtils.send(rangeManager2.getPlayerInRange(), new Packet[]{packetPlayOutEntityDestroy});
    }

    @Override
    public void setSelfFakeInvisible(Player player, boolean bl) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        byte by = (Byte)entityPlayer.aj().a(DataAccessors.COMMON_DATA);
        byte by2 = bl ? NMSUtils.setBit(by, 5, true) : by;
        this.commonDataItem.a((Object)by2);
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(player.getEntityId());
        NetworkUtils.pack(this.commonDataList, packetDataSerializer);
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = new PacketPlayOutEntityMetadata(packetDataSerializer);
        NetworkUtils.send(player, new Packet[]{packetPlayOutEntityMetadata});
    }

    @Override
    public void setYHeadRot(Entity entity, float f) {
        Entity entity2 = entity;
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity2;
        entity2 = ((CraftLivingEntity)livingEntity).getHandle();
        if (entity2 instanceof EntityArmorStand) {
            entity2.f(f);
            return;
        }
        entity2.aV = f;
    }

    @Override
    public void setYBodyRot(Entity entity, float f) {
        Entity entity2 = entity;
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity2;
        entity2 = ((CraftLivingEntity)livingEntity).getHandle();
        entity2.aT = f;
    }

    @Override
    public float getYHeadRot(Entity entity) {
        Entity entity2 = entity;
        if (!(entity2 instanceof LivingEntity)) {
            return 0.0f;
        }
        LivingEntity livingEntity = (LivingEntity)entity2;
        entity2 = ((CraftLivingEntity)livingEntity).getHandle();
        return entity2.getBukkitYaw();
    }

    @Override
    public float getXHeadRot(Entity entity) {
        Entity entity2 = entity;
        if (!(entity2 instanceof LivingEntity)) {
            return 0.0f;
        }
        LivingEntity livingEntity = (LivingEntity)entity2;
        entity2 = ((CraftLivingEntity)livingEntity).getHandle();
        return entity2.dy();
    }

    @Override
    public float getYBodyRot(Entity entity) {
        Entity entity2 = entity;
        if (!(entity2 instanceof LivingEntity)) {
            return 0.0f;
        }
        LivingEntity livingEntity = (LivingEntity)entity2;
        entity2 = ((CraftLivingEntity)livingEntity).getHandle();
        return entity2.aT;
    }

    @Override
    public boolean isMoving(Entity entity) {
        double d;
        net.minecraft.world.entity.Entity entity2 = ((CraftEntity)entity).getHandle();
        double d2 = entity2.dl() - entity2.ab;
        return d2 * d2 + (d = entity2.dr() - entity2.ad) * d > 2.500000277905201E-7;
    }

    @Override
    public DynamicHitbox getDynamicHitbox() {
        return this.dynamicHitbox;
    }

    @Override
    public AtomicInteger getEntityCounter() {
        return this.entityCounter;
    }

    private static /* synthetic */ PlayerChunkMap.EntityTracker lambda$wrapRangeManager$2(Map map, Entity entity) {
        return (PlayerChunkMap.EntityTracker)map.get(entity.getEntityId());
    }

    private static /* synthetic */ PlayerChunkMap.EntityTracker lambda$wrapRangeManager$1(Map map, Entity entity) {
        return (PlayerChunkMap.EntityTracker)map.get(entity.getEntityId());
    }

    private /* synthetic */ void lambda$wrapNavigation$0(PathfinderGoalSelector pathfinderGoalSelector, NavigationAbstract navigationAbstract) {
        this.replaceNavigation(pathfinderGoalSelector, navigationAbstract);
    }
}

