/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_20_R1.entity.range;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.api.utils.FieldUtils;
import com.ticxo.modelengine.nms.v1_20_R1.NMSFields;
import com.ticxo.modelengine.nms.v1_20_R1.network.NetworkUtils;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.world.entity.Entity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class RangeManagerImpl
implements RangeManager {
    private final Supplier<PlayerChunkMap.EntityTracker> instanceSupplier;
    private final Entity entity;
    private PlayerChunkMap.EntityTracker tracked;
    private EntityTrackerEntry serverEntity;
    private int renderDistance = -1;
    private final Set<Player> playerSet = Sets.newConcurrentHashSet();
    private final Set<Player> trackedSet = Sets.newConcurrentHashSet();

    public RangeManagerImpl(Entity entity, Supplier<PlayerChunkMap.EntityTracker> supplier) {
        this.entity = entity;
        this.instanceSupplier = supplier;
        this.getInstance();
    }

    protected void getInstance() {
        if (this.tracked != null) {
            return;
        }
        this.tracked = this.instanceSupplier.get();
        if (this.tracked == null) {
            return;
        }
        try {
            this.serverEntity = (EntityTrackerEntry)FieldUtils.getField(PlayerChunkMap.EntityTracker.class, NMSFields.TRACKEDENTITY_serverEntity).get(this.tracked);
            this.renderDistance = FieldUtils.getField(PlayerChunkMap.EntityTracker.class, NMSFields.TRACKEDENTITY_range).getInt(this.tracked);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    @Override
    public void forceSpawn(Player player) {
        this.getInstance();
        if (this.tracked == null) {
            return;
        }
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        this.serverEntity.a(entityPlayer, packet -> {
            Integer n = EnumProtocol.b.a(EnumProtocolDirection.b, packet);
            if (n == null) {
                entityPlayer.c.a(packet);
            }
            NetworkUtils.send(player, packet);
        });
    }

    @Override
    public void updatePlayer(Player player) {
        this.getInstance();
        if (this.tracked == null) {
            return;
        }
        this.tracked.b(((CraftPlayer)player).getHandle());
    }

    @Override
    public void removePlayer(Player player) {
        this.getInstance();
        if (this.tracked == null) {
            return;
        }
        this.tracked.a(((CraftPlayer)player).getHandle());
    }

    @Override
    public void setRenderDistance(int n) {
        this.getInstance();
        if (this.tracked == null) {
            return;
        }
        if (n >= 0) {
            this.renderDistance = n;
        }
        try {
            FieldUtils.getField(PlayerChunkMap.EntityTracker.class, NMSFields.TRACKEDENTITY_range).setInt(this.tracked, this.renderDistance);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    @Override
    public Set<Player> getPlayerInRange() {
        this.getInstance();
        if (this.tracked == null) {
            return ImmutableSet.of();
        }
        if (this.entity.bs()) {
            this.trackedSet.clear();
        }
        this.tracked.f.forEach(serverPlayerConnection -> this.trackedSet.add((Player)serverPlayerConnection.f().getBukkitEntity()));
        this.trackedSet.addAll(this.playerSet);
        return this.trackedSet;
    }

    @Override
    public void addTrackedPlayer(Player player) {
        this.playerSet.add(player);
    }

    @Override
    public void removeTrackedPlayer(Player player) {
        this.playerSet.remove(player);
    }

    @Override
    public int getRenderDistance() {
        return this.renderDistance;
    }
}

