/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_20_R2.entity.fake.bone;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.bone.ItemHolder;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.nms.entity.fake.FakeEntity;
import com.ticxo.modelengine.api.nms.entity.fake.HandRenderer;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_20_R2.PacketDataFixer;
import com.ticxo.modelengine.nms.v1_20_R2.entity.fake.FakeAreaEffectCloud;
import com.ticxo.modelengine.nms.v1_20_R2.entity.fake.FakeArmorStand;
import com.ticxo.modelengine.nms.v1_20_R2.network.NetworkUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class HandRendererImplB
implements HandRenderer {
    private ModelBone bone;
    private ItemHolder itemBone;
    private RangeManager rangeManager = RangeManager.EMPTY;
    private final FakeAreaEffectCloud cloud;
    private final FakeArmorStand armorStand;
    private ItemStack item;
    private boolean isItemDirty;
    private boolean isInitialized = false;

    public HandRendererImplB(ModelBone modelBone) {
        this.setBone(modelBone);
        FakeEntity.DisplaySlot displaySlot = this.itemBone.getDisplay();
        this.cloud = new FakeAreaEffectCloud(modelBone.getPosition().getX(), modelBone.getPosition().getY(), modelBone.getPosition().getZ());
        this.cloud.setSmall(false);
        this.cloud.setDisplay(displaySlot);
        this.armorStand = new FakeArmorStand(modelBone.getPosition().getX(), modelBone.getPosition().getY(), modelBone.getPosition().getZ());
        this.armorStand.setRotation(this.getBoneRotation());
        this.armorStand.setInvisible(true);
        this.armorStand.setSmall(false);
        this.armorStand.setDisplay(displaySlot);
    }

    @Override
    public void setBone(ModelBone modelBone) {
        this.bone = modelBone;
        this.itemBone = modelBone instanceof ItemHolder ? (ItemHolder)modelBone : null;
        this.rangeManager = modelBone.getActiveModel().getModeledEntity().getRangeManager();
    }

    @Override
    public void initialize() {
        this.cloud.setLocation(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.armorStand.setLocation(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.isInitialized = true;
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = this.cloud.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.cloud.meta();
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity2 = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata2 = this.armorStand.updateMeta(true);
        PacketPlayOutMount packetPlayOutMount = this.cloud.addPassengers(this.armorStand.getEntityId());
        NetworkUtils.sendProtocolDependant(this.rangeManager.getPlayerInRange(), packetPlayOutSpawnEntity, new PacketDataFixer[]{PacketDataFixer.CLOUD_RIDE_OFFSET_SPAWN});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityMetadata, packetPlayOutSpawnEntity2, packetPlayOutEntityMetadata2, packetPlayOutMount});
        ModelEngineAPI.getModelTicker().queueTask(() -> NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{this.armorStand.updateEquipment(this.item)}));
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = this.cloud.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.cloud.meta();
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity2 = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata2 = this.armorStand.updateMeta(true);
        PacketPlayOutMount packetPlayOutMount = this.cloud.addPassengers(this.armorStand.getEntityId());
        NetworkUtils.sendProtocolDependant(player, packetPlayOutSpawnEntity, new PacketDataFixer[]{PacketDataFixer.CLOUD_RIDE_OFFSET_SPAWN});
        NetworkUtils.send(player, new Packet[]{packetPlayOutEntityMetadata, packetPlayOutSpawnEntity2, packetPlayOutEntityMetadata2, packetPlayOutMount});
        ModelEngineAPI.getModelTicker().queueTask(() -> NetworkUtils.send(player, new Packet[]{this.armorStand.updateEquipment(this.item)}));
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.armorStand.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityDestroy});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.armorStand.getEntityId()});
        NetworkUtils.send(player, new Packet[]{packetPlayOutEntityDestroy});
    }

    @Override
    public void update() {
        if (!this.isInitialized) {
            return;
        }
        this.armorStand.setRotation(this.getBoneRotation());
        this.armorStand.getLocation().zero().add(this.bone.getPosition());
        PacketPlayOutEntityTeleport packetPlayOutEntityTeleport = this.cloud.updatePosition(this.bone.getYaw(), this.bone.getPosition());
        PacketPlayOutEntity.PacketPlayOutEntityLook packetPlayOutEntityLook = this.armorStand.updateYaw(this.bone.getYaw(), false);
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.armorStand.updateMeta(false);
        PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = null;
        if (this.isItemDirty) {
            packetPlayOutEntityEquipment = this.armorStand.updateEquipment(this.item);
            this.isItemDirty = false;
        }
        NetworkUtils.sendProtocolDependant(this.rangeManager.getPlayerInRange(), packetPlayOutEntityTeleport, new PacketDataFixer[]{PacketDataFixer.CLOUD_RIDE_OFFSET_UPDATE});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityLook, packetPlayOutEntityMetadata, packetPlayOutEntityEquipment});
    }

    @Override
    public void updateModel() {
        PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = this.armorStand.updateEquipment(this.item);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityEquipment});
    }

    @Override
    public void setSmall(boolean bl) {
        this.armorStand.setSmall(bl);
        this.cloud.setSmall(bl);
    }

    @Override
    public void setModel(ItemStack itemStack) {
        this.item = itemStack;
        this.isItemDirty = true;
    }

    @Override
    public void setGlowing(boolean bl) {
        this.armorStand.setGlowing(bl);
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.armorStand.updateMeta(false);
        if (packetPlayOutEntityMetadata == null) {
            return;
        }
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityMetadata});
    }

    @Override
    public void setDisplay(FakeEntity.DisplaySlot displaySlot) {
        if (!this.isInitialized) {
            return;
        }
        this.armorStand.setDisplay(displaySlot);
        this.cloud.setDisplay(displaySlot);
    }

    @Override
    public void createRealRenderer() {
        this.armorStand.createRealRenderer(this.bone.getActiveModel().getModeledEntity().getBase().getWorld(), this.item);
    }

    private EulerAngle getBoneRotation() {
        EulerAngle eulerAngle = this.bone.getClientAproxRotation();
        if (eulerAngle != null) {
            return eulerAngle;
        }
        return this.bone.getRotation();
    }

    public FakeAreaEffectCloud getCloud() {
        return this.cloud;
    }

    public FakeArmorStand getArmorStand() {
        return this.armorStand;
    }
}

