/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_20_R3.entity.fake.bone;

import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.nms.entity.fake.LeashPoint;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_20_R3.entity.fake.FakeSlime;
import com.ticxo.modelengine.nms.v1_20_R3.network.NetworkUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import org.bukkit.entity.Player;

public class LeashPointImplAC
implements LeashPoint {
    private ModelBone bone;
    private RangeManager rangeManager = RangeManager.EMPTY;
    private final FakeSlime slime;
    private int holder;
    private boolean isInitialized = false;
    private final boolean isC;

    public LeashPointImplAC(ModelBone modelBone, boolean bl) {
        this.setBone(modelBone);
        this.isC = bl;
        this.slime = new FakeSlime(modelBone.getPosition().getX(), modelBone.getPosition().getY(), modelBone.getPosition().getZ());
    }

    @Override
    public void setBone(ModelBone modelBone) {
        this.bone = modelBone;
        this.rangeManager = modelBone.getActiveModel().getModeledEntity().getRangeManager();
    }

    @Override
    public void initialize() {
        this.slime.setLocation(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.isInitialized = true;
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = this.slime.spawn();
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.slime.meta();
        PacketPlayOutAttachEntity packetPlayOutAttachEntity = this.slime.leash(this.holder);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutSpawnEntity, packetPlayOutEntityMetadata, packetPlayOutAttachEntity});
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = this.slime.spawn();
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.slime.meta();
        PacketPlayOutAttachEntity packetPlayOutAttachEntity = this.slime.leash(this.holder);
        NetworkUtils.send(player, new Packet[]{packetPlayOutSpawnEntity, packetPlayOutEntityMetadata, packetPlayOutAttachEntity});
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.slime.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityDestroy});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.slime.getEntityId()});
        NetworkUtils.send(player, new Packet[]{packetPlayOutEntityDestroy});
    }

    @Override
    public void update() {
        if (!this.isInitialized) {
            return;
        }
        PacketPlayOutEntityTeleport packetPlayOutEntityTeleport = this.isC ? this.slime.updatePositionCalibrated(this.bone.getPosition()) : this.slime.updatePosition(this.bone.getPosition());
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityTeleport});
    }

    @Override
    public int getLeashId() {
        return this.slime.getEntityId();
    }

    @Override
    public void setHolder(int n) {
        if (this.holder == n) {
            return;
        }
        this.holder = n;
        PacketPlayOutAttachEntity packetPlayOutAttachEntity = this.slime.leash(n);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutAttachEntity});
    }

    public FakeSlime getSlime() {
        return this.slime;
    }

    @Override
    public int getHolder() {
        return this.holder;
    }
}

