/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.model;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.entity.data.IEntityData;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.render.ModelRenderer;
import com.ticxo.modelengine.api.nms.network.NetworkHandler;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.data.io.SavedData;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;

public class ModelUpdater {
    private final Map<Integer, UUID> entityIdLookup = Maps.newConcurrentMap();
    private final Map<UUID, ModeledEntity> uuidLookup = Maps.newConcurrentMap();
    private boolean isBatching;

    public ModelUpdater() {
        ModelEngineAPI.getAPI().getConfigManager().registerReferenceUpdate(() -> {
            this.isBatching = ConfigProperty.BUNDLE_EVERYTHING.getBoolean();
        });
    }

    public void updateAllModels() {
        NetworkHandler handler = ModelEngineAPI.getNetworkHandler();
        if (this.isBatching) {
            handler.startBatch();
        }
        for (Map.Entry<UUID, ModeledEntity> entry : this.uuidLookup.entrySet()) {
            ModeledEntity entity = entry.getValue();
            if (!entity.tick()) {
                this.forceRemoveModeledEntity(entity);
                continue;
            }
            this.forRenderers(entity, ModelRenderer::sendToClient);
        }
        if (this.isBatching) {
            handler.endBatch();
        }
    }

    private void forRenderers(ModeledEntity modeledEntity, Consumer<ModelRenderer> rendererConsumer) {
        IEntityData data = modeledEntity.getBase().getData();
        Map<String, ActiveModel> models = modeledEntity.getModels();
        if (models.isEmpty()) {
            return;
        }
        for (ActiveModel model : models.values()) {
            if (model.getModelRenderer().isInitialized()) continue;
            return;
        }
        for (ActiveModel model : models.values()) {
            rendererConsumer.accept(model.getModelRenderer());
        }
        data.cleanup();
    }

    public Optional<ModeledEntity> registerModeledEntity(BaseEntity<?> base, ModeledEntity modeledEntity) {
        this.entityIdLookup.put(base.getEntityId(), base.getUUID());
        return Optional.ofNullable(this.uuidLookup.put(base.getUUID(), modeledEntity));
    }

    public ModeledEntity getModeledEntity(int id) {
        return this.getModeledEntity(this.entityIdLookup.get(id));
    }

    public ModeledEntity getModeledEntity(UUID uuid) {
        return uuid == null ? null : this.uuidLookup.get(uuid);
    }

    public ModeledEntity removeModeledEntity(int id) {
        return this.removeModeledEntity(this.entityIdLookup.get(id));
    }

    public ModeledEntity removeModeledEntity(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        ModeledEntity model = this.uuidLookup.get(uuid);
        if (model != null) {
            model.markRemoved();
        }
        return model;
    }

    public void forceRemoveModeledEntity(ModeledEntity model) {
        this.uuidLookup.remove(model.getBase().getUUID());
        this.entityIdLookup.remove(model.getBase().getEntityId());
        model.getBase().setForcedAlive(false);
        model.destroy();
    }

    public Set<UUID> getAllModeledEntityUUID() {
        return this.uuidLookup.keySet();
    }

    public void saveAllModels() {
        for (ModeledEntity model : this.uuidLookup.values()) {
            Entity entity;
            Object obj = model.getBase().getOriginal();
            if (!(obj instanceof Entity) || (entity = (Entity)obj) instanceof Player) continue;
            model.save().ifPresent(data -> entity.getPersistentDataContainer().set(SavedData.DATA_KEY, PersistentDataType.STRING, (Object)data.toString()));
        }
    }
}

