/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.generator.parser.blockbench.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.BlueprintAnimation;
import com.ticxo.modelengine.api.animation.Timeline;
import com.ticxo.modelengine.api.animation.keyframe.KeyframeType;
import com.ticxo.modelengine.api.animation.keyframe.KeyframeTypes;
import com.ticxo.modelengine.api.animation.keyframe.data.KeyframeReaderRegistry;
import com.ticxo.modelengine.api.animation.keyframe.type.ScriptKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.type.VectorKeyframe;
import com.ticxo.modelengine.api.entity.Hitbox;
import com.ticxo.modelengine.api.error.IError;
import com.ticxo.modelengine.api.error.WarnBadAngle;
import com.ticxo.modelengine.api.error.WarnMultipleAngle;
import com.ticxo.modelengine.api.generator.assets.BlueprintTexture;
import com.ticxo.modelengine.api.generator.assets.JavaItemModel;
import com.ticxo.modelengine.api.generator.assets.ModelAssets;
import com.ticxo.modelengine.api.generator.blueprint.BlueprintBone;
import com.ticxo.modelengine.api.generator.blueprint.ModelBlueprint;
import com.ticxo.modelengine.api.model.bone.BoneBehaviorTypes;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehaviorType;
import com.ticxo.modelengine.api.utils.data.ResourceLocation;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.core.generator.parser.blockbench.json.MCMetaDeserializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BlockbenchModel {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(BlueprintTexture.MCMeta.class, (Object)new MCMetaDeserializer()).create();
    protected final int[] resolution = new int[2];
    protected final Map<UUID, Element> elements = new HashMap<UUID, Element>();
    protected final Map<String, Bone> outliner = new HashMap<String, Bone>();
    protected final Map<Integer, Texture> textures = new HashMap<Integer, Texture>();
    protected final Map<String, Animation> animations = new LinkedHashMap<String, Animation>();
    protected final transient Map<String, Bone> flatOutliner = new HashMap<String, Bone>();
    protected String animationPlaceholder = "";

    protected void finalizeOptions(Bone bone, BlueprintBone blueprintBone) {
        Map<String, Object> subHitboxOptions = bone.getOptions().get(BoneBehaviorTypes.SUB_HITBOX.getId());
        if (subHitboxOptions == null) {
            return;
        }
        for (UUID uuid : bone.element) {
            Element element = this.elements.get(uuid);
            if (!(element instanceof Cube)) continue;
            Cube cube = (Cube)element;
            subHitboxOptions.put("dimension", new Hitbox((double)cube.width() * 0.0625, (double)cube.height() * 0.0625, (double)cube.depth() * 0.0625, 0.0));
            subHitboxOptions.put("origin", new Vector3f((cube.from[0] + cube.to[0]) * 0.03125f, (cube.from[1] + cube.to[1]) * 0.03125f, (cube.from[2] + cube.to[2]) * 0.03125f));
            break;
        }
    }

    protected BlueprintBone readBone(@Nullable BlueprintBone parent, Bone bone) {
        this.flatOutliner.put(bone.name, bone);
        BlueprintBone blueprintBone = new BlueprintBone();
        this.finalizeOptions(bone, blueprintBone);
        blueprintBone.setName(bone.getName());
        blueprintBone.setGlobalPosition(new Vector3f(bone.getOrigin()[0] * 0.0625f, bone.getOrigin()[1] * 0.0625f, bone.getOrigin()[2] * 0.0625f));
        Vector3f rotation = new Vector3f(bone.getRotation()[0] * ((float)Math.PI / 180), bone.getRotation()[1] * ((float)Math.PI / 180), bone.getRotation()[2] * ((float)Math.PI / 180));
        blueprintBone.setLocalRotation(rotation);
        blueprintBone.getLocalQuaternion().rotateZYX(rotation.z, rotation.y, rotation.x);
        if (parent != null) {
            blueprintBone.setLocalPosition(blueprintBone.getGlobalPosition().sub((Vector3fc)parent.getGlobalPosition(), new Vector3f()));
            Quaternionf boneQuaternion = new Quaternionf().rotationZYX(rotation.z, rotation.y, rotation.x);
            Quaternionf parentQuaternion = parent.getGlobalQuaternion();
            parentQuaternion.mul((Quaternionfc)boneQuaternion, boneQuaternion);
            Vector3f global = TMath.getEulerAnglesZYX(boneQuaternion, new Vector3f());
            blueprintBone.setGlobalRotation(new Vector3f(global.x, global.y, global.z));
            blueprintBone.setGlobalQuaternion(boneQuaternion);
            Vector3f rotatedLocal = blueprintBone.getLocalPosition().rotate((Quaternionfc)parentQuaternion, new Vector3f());
            blueprintBone.setRotatedGlobalPosition(rotatedLocal.add((Vector3fc)parent.getRotatedGlobalPosition()));
        } else {
            blueprintBone.setLocalPosition(new Vector3f((Vector3fc)blueprintBone.getGlobalPosition()));
            blueprintBone.setGlobalRotation(rotation);
            blueprintBone.setGlobalQuaternion(new Quaternionf((Quaternionfc)blueprintBone.getLocalQuaternion()));
            blueprintBone.setRotatedGlobalPosition(new Vector3f((Vector3fc)blueprintBone.getGlobalPosition()));
        }
        blueprintBone.setParent(parent);
        blueprintBone.getBehaviors().putAll(bone.options);
        for (Map.Entry<String, Bone> entry : bone.getChildBone().entrySet()) {
            blueprintBone.getChildren().put(entry.getKey(), this.readBone(blueprintBone, entry.getValue()));
        }
        return blueprintBone;
    }

    protected Map<String, Bone> readBone(Map<String, Bone> original, String name, Predicate<Bone> consumer, Runnable missing) {
        HashMap<String, Bone> localOutliner = new HashMap<String, Bone>(original);
        LinkedList<Map<String, Bone>> queue = new LinkedList<Map<String, Bone>>();
        queue.add(localOutliner);
        while (!queue.isEmpty()) {
            Map bones = (Map)queue.pop();
            Bone bone = (Bone)bones.get(name);
            if (bone != null && consumer.test(bone)) {
                bones.remove(name);
                return localOutliner;
            }
            for (Bone childBones : bones.values()) {
                queue.add(childBones.getChildBone());
            }
        }
        missing.run();
        return localOutliner;
    }

    private Hitbox readHitbox(Bone hitbox) {
        for (UUID uuid : hitbox.getElement()) {
            float eyeHeight;
            Element element = this.elements.get(uuid);
            if (!(element instanceof Cube)) continue;
            Cube cube = (Cube)element;
            float f = eyeHeight = hitbox.origin[1] <= 0.0f ? cube.origin[1] : hitbox.origin[1];
            if (eyeHeight <= 0.0f) {
                IError.BAD_EYE_HEIGHT.log();
            }
            return new Hitbox(cube.width() * 0.0625f, cube.height() * 0.0625f, cube.depth() * 0.0625f, eyeHeight * 0.0625f);
        }
        return null;
    }

    private float readShadow(Bone shadow) {
        for (UUID uuid : shadow.getElement()) {
            Element element = this.elements.get(uuid);
            if (!(element instanceof Cube)) continue;
            Cube cube = (Cube)element;
            return Math.max(Math.abs(cube.to[0] - cube.from[0]), Math.abs(cube.to[2] - cube.from[2])) * 0.03125f;
        }
        return -1.0f;
    }

    public void populateBlueprint(ModelBlueprint blueprint) {
        String[] lines;
        Map<String, Bone> localOutliner = this.readBone(this.outliner, "hitbox", bone -> {
            Hitbox mainHitbox = this.readHitbox((Bone)bone);
            if (mainHitbox == null) {
                return false;
            }
            blueprint.setMainHitbox(mainHitbox);
            return true;
        }, IError.NO_HITBOX::log);
        localOutliner = this.readBone(localOutliner, "shadow", bone -> {
            float radius = this.readShadow((Bone)bone);
            if ((double)radius < 1.0E-5) {
                return false;
            }
            blueprint.setShadowRadius(radius);
            return true;
        }, () -> {});
        for (Map.Entry<String, Bone> entry : localOutliner.entrySet()) {
            blueprint.getBones().put(entry.getKey(), this.readBone(null, entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.animations.entrySet()) {
            String name = entry.getKey();
            Animation value = (Animation)entry.getValue();
            BlueprintAnimation blueprintAnimation = new BlueprintAnimation(blueprint, name);
            Map<String, Map<Float, Animation.Animator.Keyframe>> effectChannels = value.effects.getChannels();
            Map<Float, Animation.Animator.Keyframe> script = effectChannels.get("timeline");
            if (script != null) {
                for (Map.Entry<Comparable<Float>, Object> entry2 : script.entrySet()) {
                    Animation.Animator.Keyframe bbFrame = (Animation.Animator.Keyframe)entry2.getValue();
                    ScriptKeyframe frame = blueprintAnimation.getGlobalTimeline().getKeyframe(((Float)entry2.getKey()).floatValue(), KeyframeTypes.SCRIPT);
                    for (Map<String, String> data : bbFrame.getData()) {
                        String instructions = data.getOrDefault("script", "");
                        for (String instruction : instructions.split("\n")) {
                            frame.getScript().add(ScriptKeyframe.Script.from(instruction));
                        }
                    }
                }
            }
            for (Map.Entry<Comparable<Float>, Object> entry3 : value.animators.entrySet()) {
                Animation.Animator animator = (Animation.Animator)entry3.getValue();
                Timeline timeline = new Timeline(blueprintAnimation, animator.globalRotation);
                BlockbenchModel.putVectorKeyframes(animator, "position", timeline, KeyframeTypes.POSITION, -0.0625f, 0.0625f, 0.0625f);
                BlockbenchModel.putVectorKeyframes(animator, "rotation", timeline, KeyframeTypes.ROTATION, (float)(-Math.PI) / 180, (float)(-Math.PI) / 180, (float)Math.PI / 180);
                BlockbenchModel.putVectorKeyframes(animator, "scale", timeline, KeyframeTypes.SCALE, 1.0f, 1.0f, 1.0f);
                blueprintAnimation.getTimelines().put(animator.name, timeline);
            }
            blueprintAnimation.setLength(value.getLength());
            blueprintAnimation.setLoopMode(value.getLoop());
            blueprintAnimation.setOverride(value.isOverride());
            blueprint.getAnimations().put(name, blueprintAnimation);
        }
        for (String line : lines = this.animationPlaceholder.split("\n")) {
            String[] pair = line.split("=", 2);
            if (pair.length < 2) continue;
            blueprint.getAnimationsPlaceholders().put(pair[0], pair[1]);
        }
    }

    public void populateAssets(ModelBlueprint blueprint, ModelAssets assets) {
        for (Map.Entry<Integer, Texture> entry : this.textures.entrySet()) {
            BlueprintTexture.MCMeta meta;
            Integer id = entry.getKey();
            Texture bbTexture = entry.getValue();
            if (bbTexture.raw_mcmeta == null) {
                meta = new BlueprintTexture.MCMeta();
                meta.setFrametime(bbTexture.frame_time);
                meta.setInterpolate(bbTexture.frame_interpolate ? Boolean.valueOf(true) : null);
                if (bbTexture.frame_order != null) {
                    for (int frame : bbTexture.frame_order) {
                        meta.addFrame(frame);
                    }
                }
            } else {
                meta = (BlueprintTexture.MCMeta)gson.fromJson(bbTexture.raw_mcmeta, BlueprintTexture.MCMeta.class);
                meta.setMustGenerate(true);
            }
            BlueprintTexture texture = new BlueprintTexture();
            texture.setId(id);
            texture.setFrameWidth(bbTexture.uvWidth);
            texture.setFrameHeight(bbTexture.uvHeight);
            texture.setPath(new ResourceLocation(bbTexture.namespace, bbTexture.folder + "/" + bbTexture.name));
            texture.setMcMeta(meta);
            texture.setSource(bbTexture.source);
            assets.getTextures().add(texture);
        }
        block2: for (Map.Entry<Object, Object> entry : blueprint.getFlatMap().entrySet()) {
            String name = (String)entry.getKey();
            BlueprintBone bone = (BlueprintBone)entry.getValue();
            Bone bbBone = this.flatOutliner.get(name);
            if (bbBone == null || !bbBone.export || !this.shouldGenerate(bbBone)) continue;
            for (BoneBehaviorType<?> behaviorType : bone.getCachedBehaviorProvider().keySet()) {
                if (!behaviorType.isIgnoreCubes()) continue;
                continue block2;
            }
            boolean hasElement = false;
            JavaItemModel javaItemModel = new JavaItemModel();
            javaItemModel.setName(name);
            for (UUID elementId : bbBone.element) {
                Element bbElement = this.elements.get(elementId);
                if (!(bbElement instanceof Cube)) continue;
                Cube cube = (Cube)bbElement;
                JavaItemModel.JavaElement element = new JavaItemModel.JavaElement();
                element.from(bbBone.origin, cube.from, cube.inflate);
                element.to(bbBone.origin, cube.to, cube.inflate);
                element.setRotation(cube.rotation(bbBone));
                for (Map.Entry<String, Cube.Face> faceEntry : cube.faces.entrySet()) {
                    String dir = faceEntry.getKey();
                    Cube.Face bbFace = faceEntry.getValue();
                    if (bbFace.isEmpty()) continue;
                    JavaItemModel.JavaElement.Face face = new JavaItemModel.JavaElement.Face();
                    face.setRotation(bbFace.rotation);
                    if (assets.getTextures().size() > bbFace.texture) {
                        BlueprintTexture texture = assets.getTextures().get(bbFace.texture);
                        if (texture != null) {
                            face.uv(texture.getFrameWidth(), texture.getFrameHeight(), bbFace.uv);
                            face.setTexture("#" + texture.getId());
                            javaItemModel.getTextures().put(String.valueOf(texture.getId()), texture.getPath().toString());
                        }
                    } else {
                        face.uv(16, 16, bbFace.uv);
                    }
                    element.getFaces().put(dir, face);
                }
                if (element.getFaces().isEmpty()) continue;
                hasElement = true;
                javaItemModel.addElement(element);
            }
            if (!hasElement) continue;
            bone.setRenderer(true);
            bone.setScale(javaItemModel.scaleToFit());
            assets.getModels().put(name, javaItemModel);
        }
    }

    protected boolean shouldGenerate(Bone bbBone) {
        return true;
    }

    private static void putVectorKeyframes(Animation.Animator animator, String channel, Timeline timeline, KeyframeType<VectorKeyframe, Vector3f> keyframeType, float scaleX, float scaleY, float scaleZ) {
        Map<Float, Animation.Animator.Keyframe> frames = animator.channels.get(channel);
        if (frames == null) {
            return;
        }
        for (Map.Entry<Float, Animation.Animator.Keyframe> entry : frames.entrySet()) {
            Float time = entry.getKey();
            Animation.Animator.Keyframe keyframe = entry.getValue();
            VectorKeyframe vectorKeyframe = timeline.getKeyframe(time.floatValue(), keyframeType);
            if (keyframe.getData().size() >= 1) {
                KeyframeReaderRegistry reader = ModelEngineAPI.getAPI().getKeyframeReaderRegistry();
                Map<String, String> pre = keyframe.data.get(0);
                vectorKeyframe.setX(reader.tryParse(pre.getOrDefault("x", "0"))).setY(reader.tryParse(pre.getOrDefault("y", "0"))).setZ(reader.tryParse(pre.getOrDefault("z", "0"))).setXFactor(scaleX).setYFactor(scaleY).setZFactor(scaleZ);
                if (keyframe.getData().size() >= 2) {
                    Map<String, String> post = keyframe.data.get(1);
                    vectorKeyframe.setPostX(reader.tryParse(post.getOrDefault("x", "0"))).setPostY(reader.tryParse(post.getOrDefault("y", "0"))).setPostZ(reader.tryParse(post.getOrDefault("z", "0"))).setXFactor(scaleX).setYFactor(scaleY).setZFactor(scaleZ);
                }
            }
            vectorKeyframe.setInterpolation(keyframe.getInterpolation());
            if (!vectorKeyframe.isBezier()) continue;
            vectorKeyframe.setBezierLeftTime(Float.valueOf(keyframe.bezierLeftTime[0]), Float.valueOf(keyframe.bezierLeftTime[1]), Float.valueOf(keyframe.bezierLeftTime[2]));
            vectorKeyframe.setBezierLeftValue(Float.valueOf(keyframe.bezierLeftValue[0]), Float.valueOf(keyframe.bezierLeftValue[1]), Float.valueOf(keyframe.bezierLeftValue[2]));
            vectorKeyframe.setBezierRightTime(Float.valueOf(keyframe.bezierRightTime[0]), Float.valueOf(keyframe.bezierRightTime[1]), Float.valueOf(keyframe.bezierRightTime[2]));
            vectorKeyframe.setBezierRightValue(Float.valueOf(keyframe.bezierRightValue[0]), Float.valueOf(keyframe.bezierRightValue[1]), Float.valueOf(keyframe.bezierRightValue[2]));
        }
    }

    public int[] getResolution() {
        return this.resolution;
    }

    public Map<UUID, Element> getElements() {
        return this.elements;
    }

    public Map<String, Bone> getOutliner() {
        return this.outliner;
    }

    public Map<Integer, Texture> getTextures() {
        return this.textures;
    }

    public Map<String, Animation> getAnimations() {
        return this.animations;
    }

    public Map<String, Bone> getFlatOutliner() {
        return this.flatOutliner;
    }

    public String getAnimationPlaceholder() {
        return this.animationPlaceholder;
    }

    public static class Bone {
        protected final float[] origin = new float[3];
        protected final float[] rotation = new float[3];
        protected final Set<UUID> element = new HashSet<UUID>();
        protected final Map<String, Bone> childBone = new HashMap<String, Bone>();
        protected final Map<String, Map<String, Object>> options = new HashMap<String, Map<String, Object>>();
        protected String name;
        protected UUID uuid;
        protected boolean export = true;

        public float[] getOrigin() {
            return this.origin;
        }

        public float[] getRotation() {
            return this.rotation;
        }

        public Set<UUID> getElement() {
            return this.element;
        }

        public Map<String, Bone> getChildBone() {
            return this.childBone;
        }

        public Map<String, Map<String, Object>> getOptions() {
            return this.options;
        }

        public String getName() {
            return this.name;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public boolean isExport() {
            return this.export;
        }
    }

    public static class Element {
        protected String name;
        protected UUID uuid;
        protected boolean export = true;

        public String getName() {
            return this.name;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public boolean isExport() {
            return this.export;
        }
    }

    public static class Cube
    extends Element {
        private static final float ANGLE_FACTOR = 0.044444446f;
        protected final float[] from = new float[3];
        protected final float[] to = new float[3];
        protected final float[] rotation = new float[3];
        protected final float[] origin = new float[3];
        protected final Map<String, Face> faces = new HashMap<String, Face>();
        protected float inflate;

        public float width() {
            return Math.abs(this.to[0] - this.from[0]);
        }

        public float height() {
            return Math.abs(this.to[1] - this.from[1]);
        }

        public float depth() {
            return Math.abs(this.to[2] - this.from[2]);
        }

        @Nullable
        public JavaItemModel.JavaElement.Rotation rotation(Bone bone) {
            int zeros = 0;
            for (float angle : this.rotation) {
                zeros += angle == 0.0f ? 1 : 0;
            }
            if (zeros == 3) {
                return null;
            }
            if (zeros <= 1) {
                new WarnMultipleAngle(bone.name, this.name).log();
            }
            JavaItemModel.JavaElement.Rotation javaRotation = new JavaItemModel.JavaElement.Rotation();
            int i = TMath.absMax(this.rotation[0], this.rotation[1], this.rotation[2]);
            javaRotation.setAxis(switch (i) {
                default -> "x";
                case 1 -> "y";
                case 2 -> "z";
            });
            float angle = this.rotation[i];
            if (angle > 45.0f || angle < -45.0f) {
                new WarnBadAngle(bone.name, this.name, angle).log();
            }
            if ((angle = TMath.clamp(angle, -45.0f, 45.0f)) % 22.5f != 0.0f) {
                new WarnBadAngle(bone.name, this.name, angle).log();
            }
            angle = (float)Math.round(angle * 0.044444446f) * 22.5f;
            javaRotation.setAngle(angle);
            javaRotation.origin(bone.origin, this.origin);
            return javaRotation;
        }

        public float[] getFrom() {
            return this.from;
        }

        public float[] getTo() {
            return this.to;
        }

        public float[] getRotation() {
            return this.rotation;
        }

        public float[] getOrigin() {
            return this.origin;
        }

        public Map<String, Face> getFaces() {
            return this.faces;
        }

        public float getInflate() {
            return this.inflate;
        }

        public static class Face {
            protected final float[] uv = new float[4];
            protected int rotation;
            protected int texture;

            public boolean isEmpty() {
                return this.texture == -1 || TMath.isSimilar(this.uv[0], this.uv[2]) || TMath.isSimilar(this.uv[1], this.uv[3]);
            }

            public float[] getUv() {
                return this.uv;
            }

            public int getRotation() {
                return this.rotation;
            }

            public int getTexture() {
                return this.texture;
            }
        }
    }

    public static class Animation {
        protected String name;
        protected BlueprintAnimation.LoopMode loop;
        protected boolean override;
        protected float length;
        protected Animator effects;
        protected Map<UUID, Animator> animators = new HashMap<UUID, Animator>();

        public String getName() {
            return this.name;
        }

        public BlueprintAnimation.LoopMode getLoop() {
            return this.loop;
        }

        public boolean isOverride() {
            return this.override;
        }

        public float getLength() {
            return this.length;
        }

        public Animator getEffects() {
            return this.effects;
        }

        public Map<UUID, Animator> getAnimators() {
            return this.animators;
        }

        public static class Animator {
            protected String name;
            protected UUID uuid;
            protected boolean globalRotation;
            protected Map<String, Map<Float, Keyframe>> channels = new HashMap<String, Map<Float, Keyframe>>();

            public String getName() {
                return this.name;
            }

            public UUID getUuid() {
                return this.uuid;
            }

            public boolean isGlobalRotation() {
                return this.globalRotation;
            }

            public Map<String, Map<Float, Keyframe>> getChannels() {
                return this.channels;
            }

            public static class Keyframe {
                protected final List<Map<String, String>> data = new ArrayList<Map<String, String>>();
                protected final float[] bezierLeftTime = new float[3];
                protected final float[] bezierLeftValue = new float[3];
                protected final float[] bezierRightTime = new float[3];
                protected final float[] bezierRightValue = new float[3];
                protected String channel;
                protected float time;
                protected String interpolation;

                public List<Map<String, String>> getData() {
                    return this.data;
                }

                public float[] getBezierLeftTime() {
                    return this.bezierLeftTime;
                }

                public float[] getBezierLeftValue() {
                    return this.bezierLeftValue;
                }

                public float[] getBezierRightTime() {
                    return this.bezierRightTime;
                }

                public float[] getBezierRightValue() {
                    return this.bezierRightValue;
                }

                public String getChannel() {
                    return this.channel;
                }

                public float getTime() {
                    return this.time;
                }

                public String getInterpolation() {
                    return this.interpolation;
                }
            }
        }
    }

    public static class Texture {
        protected String name;
        protected String folder;
        protected String namespace;
        protected String id;
        protected int frame_time;
        protected int[] frame_order;
        protected boolean frame_interpolate;
        protected UUID uuid;
        protected String raw_mcmeta;
        protected String source;
        protected int uvWidth;
        protected int uvHeight;

        public String getName() {
            return this.name;
        }

        public String getFolder() {
            return this.folder;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getId() {
            return this.id;
        }

        public int getFrame_time() {
            return this.frame_time;
        }

        public int[] getFrame_order() {
            return this.frame_order;
        }

        public boolean isFrame_interpolate() {
            return this.frame_interpolate;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public String getRaw_mcmeta() {
            return this.raw_mcmeta;
        }

        public String getSource() {
            return this.source;
        }

        public int getUvWidth() {
            return this.uvWidth;
        }

        public int getUvHeight() {
            return this.uvHeight;
        }
    }

    public static class NullObject
    extends Element {
        protected final float[] position = new float[3];

        public float[] getPosition() {
            return this.position;
        }
    }
}

