/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.model.bone.render;

import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.BoneBehaviorTypes;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehavior;
import com.ticxo.modelengine.api.model.bone.render.BehaviorRendererParser;
import com.ticxo.modelengine.api.model.bone.render.renderer.MountRenderer;
import com.ticxo.modelengine.api.model.bone.type.Mount;
import com.ticxo.modelengine.api.utils.data.tracker.CollectionDataTracker;
import com.ticxo.modelengine.api.utils.data.tracker.DataTracker;
import com.ticxo.modelengine.api.utils.data.tracker.UpdateDataTracker;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.core.model.bone.render.AbstractBehaviorRenderer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MountRendererImpl
extends AbstractBehaviorRenderer
implements MountRenderer {
    private final BehaviorRendererParser<MountRenderer> parser;
    private final Map<String, MountRenderer.Mount> spawnQueue = new HashMap<String, MountRenderer.Mount>();
    private final Map<String, MountRenderer.Mount> rendered = new HashMap<String, MountRenderer.Mount>();
    private final Map<String, MountRenderer.Mount> destroyQueue = new HashMap<String, MountRenderer.Mount>();
    private boolean initialized;
    private int lerpTick;
    private Vector lerpLocation;
    private Vector targetLocation;

    public MountRendererImpl(ActiveModel activeModel) {
        super(activeModel);
        this.parser = this.nmsHandler.getBehaviorRendererParser(this);
    }

    @Override
    public void initialize() {
        ModeledEntity modeledEntity = this.activeModel.getModeledEntity();
        this.targetLocation = modeledEntity.getBase().getLocation().toVector();
        this.lerpLocation = this.targetLocation.clone();
        for (Map.Entry<String, ModelBone> boneEntry : this.activeModel.getBones().entrySet()) {
            String boneId = boneEntry.getKey();
            ModelBone modelBone = boneEntry.getValue();
            this.create(boneId, modelBone);
        }
        this.initialized = true;
    }

    private void create(String boneId, ModelBone modelBone) {
        Optional<? extends Mount> maybeData = modelBone.getBoneBehavior(BoneBehaviorTypes.MOUNT);
        if (maybeData.isEmpty()) {
            return;
        }
        BoneBehavior mountData = (BoneBehavior)((Object)maybeData.get());
        MountImpl mount = new MountImpl(this.nmsHandler.getEntityHandler().getNextEntityId(), UUID.randomUUID(), this.nmsHandler.getEntityHandler().getNextEntityId(), UUID.randomUUID());
        mount.position.set(this.lerpLocation.toVector3f().add((Vector3fc)((Mount)((Object)mountData)).getLocation()));
        mount.yaw.set(TMath.rotToByte(modelBone.getYaw()));
        for (Entity entity : ((Mount)((Object)mountData)).getPassengers()) {
            ((Collection)mount.passengers.get()).add(entity.getEntityId());
        }
        this.spawnQueue.put(boneId, mount);
        this.destroyQueue.remove(boneId);
    }

    @Override
    public void readBoneData() {
        if (!this.initialized) {
            return;
        }
        ModeledEntity modeledEntity = this.activeModel.getModeledEntity();
        this.lerpLocation = modeledEntity.getBase().getLocation().toVector();
        this.destroyQueue.putAll(this.rendered);
        for (Map.Entry<String, ModelBone> boneEntry : this.activeModel.getBones().entrySet()) {
            String boneId = boneEntry.getKey();
            ModelBone modelBone = boneEntry.getValue();
            MountRenderer.Mount renderer = this.rendered.get(boneId);
            if (renderer != null) {
                this.read(boneId, renderer, modelBone);
                continue;
            }
            this.create(boneId, modelBone);
        }
    }

    private void read(String boneId, MountRenderer.Mount mount, ModelBone modelBone) {
        mount.getYaw().set(TMath.rotToByte(modelBone.getYaw()));
        Optional<? extends Mount> maybeData = modelBone.getBoneBehavior(BoneBehaviorTypes.MOUNT);
        maybeData.ifPresent(mountData -> {
            mount.getPosition().set(this.lerpLocation.toVector3f().add((Vector3fc)((Mount)((Object)mountData)).getLocation()));
            HashSet<Integer> newIds = new HashSet<Integer>();
            for (Entity entity : ((Mount)((Object)mountData)).getPassengers()) {
                newIds.add(entity.getEntityId());
            }
            mount.getPassengers().retainAll(newIds);
            mount.getPassengers().addAll((Collection<Integer>)newIds);
            this.destroyQueue.remove(boneId);
        });
    }

    @Override
    public void sendToClient() {
        if (!this.initialized) {
            return;
        }
        this.destroyQueue.keySet().forEach(this.rendered::remove);
        this.parser.sendToClients(this);
        this.rendered.putAll(this.spawnQueue);
        this.spawnQueue.clear();
        this.destroyQueue.clear();
    }

    @Override
    public void destroy() {
        if (!this.initialized) {
            return;
        }
        this.parser.destroy(this);
    }

    @Override
    public Map<String, MountRenderer.Mount> getSpawnQueue() {
        return this.spawnQueue;
    }

    @Override
    public Map<String, MountRenderer.Mount> getRendered() {
        return this.rendered;
    }

    @Override
    public Map<String, MountRenderer.Mount> getDestroyQueue() {
        return this.destroyQueue;
    }

    public static class MountImpl
    implements MountRenderer.Mount {
        private final int pivotId;
        private final UUID pivotUuid;
        private final int mountId;
        private final UUID mountUuid;
        private final DataTracker<Vector3f> position = new UpdateDataTracker<Vector3f>(new Vector3f(), Vector3f::set);
        private final DataTracker<Byte> yaw = new DataTracker<Byte>((byte)0);
        private final CollectionDataTracker<Integer> passengers = new CollectionDataTracker(new HashSet());

        public MountImpl(int pivotId, UUID pivotUuid, int mountId, UUID mountUuid) {
            this.pivotId = pivotId;
            this.pivotUuid = pivotUuid;
            this.mountId = mountId;
            this.mountUuid = mountUuid;
        }

        @Override
        public int getPivotId() {
            return this.pivotId;
        }

        @Override
        public UUID getPivotUuid() {
            return this.pivotUuid;
        }

        @Override
        public int getMountId() {
            return this.mountId;
        }

        @Override
        public UUID getMountUuid() {
            return this.mountUuid;
        }

        @Override
        public DataTracker<Vector3f> getPosition() {
            return this.position;
        }

        @Override
        public DataTracker<Byte> getYaw() {
            return this.yaw;
        }

        @Override
        public CollectionDataTracker<Integer> getPassengers() {
            return this.passengers;
        }
    }
}

