/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.mythic.compatibility;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.CullType;
import com.ticxo.modelengine.api.entity.data.AbstractEntityData;
import com.ticxo.modelengine.core.mythic.compatibility.ProjectileEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.bukkit.BukkitAdapter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ProjectileData
extends AbstractEntityData {
    private final ProjectileEntity projectileEntity;
    private final AtomicBoolean isAlive = new AtomicBoolean(true);
    private final AtomicReference<Location> location = new AtomicReference();
    private final Set<Player> syncTracking = new HashSet<Player>();
    private final Map<Player, CullType> asyncTracking = new HashMap<Player, CullType>();
    private final Queue<Player> startTrackingQueue = new ConcurrentLinkedQueue<Player>();
    private final Set<Player> startTracking = new HashSet<Player>();
    private final Queue<Player> stopTrackingQueue = new ConcurrentLinkedQueue<Player>();
    private final Set<Player> stopTracking = new HashSet<Player>();

    public ProjectileData(ProjectileEntity projectileEntity) {
        this.projectileEntity = projectileEntity;
        this.syncUpdate();
        this.asyncUpdate();
        ModelEngineAPI.getAPI().getDataTracker().putEntityData(projectileEntity.getUUID(), this);
    }

    @Override
    public void asyncUpdate() {
        Player player;
        while (!this.startTrackingQueue.isEmpty()) {
            player = this.startTrackingQueue.poll();
            this.startTracking.add(player);
            this.asyncTracking.put(player, CullType.NO_CULL);
        }
        while (!this.stopTrackingQueue.isEmpty()) {
            player = this.stopTrackingQueue.poll();
            this.stopTracking.add(player);
            if (this.asyncTracking.get(player) == CullType.CULLED) continue;
            this.asyncTracking.remove(player);
        }
    }

    @Override
    public void syncUpdate() {
        Location location = BukkitAdapter.adapt((AbstractLocation)this.projectileEntity.getOriginal().getCurrentLocation());
        this.location.set(location);
        this.isAlive.set(!this.projectileEntity.getOriginal().getCancelled());
        if (!this.isDataValid()) {
            this.projectileEntity.removeSelf();
        }
        HashSet<Player> updatedTracking = new HashSet<Player>();
        int radiusSqr = this.projectileEntity.getRenderRadius() * this.projectileEntity.getRenderRadius();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Location playerLocation = player.getLocation();
            if (!this.getLocation().getWorld().equals(playerLocation.getWorld()) || !(playerLocation.distanceSquared(location) <= (double)radiusSqr)) continue;
            updatedTracking.add(player);
        }
        HashSet<Player> all = new HashSet<Player>(this.syncTracking);
        all.addAll(updatedTracking);
        for (Player player : all) {
            if (!this.syncTracking.contains(player)) {
                this.startTrackingQueue.add(player);
                continue;
            }
            if (updatedTracking.contains(player)) continue;
            this.stopTrackingQueue.add(player);
        }
        this.syncTracking.clear();
        this.syncTracking.addAll(updatedTracking);
    }

    @Override
    public void cleanup() {
        this.startTracking.clear();
        this.stopTracking.clear();
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean isDataValid() {
        return this.isAlive.get();
    }

    @Override
    public Location getLocation() {
        return this.location.get();
    }

    @Override
    public List<Entity> getPassengers() {
        return List.of();
    }

    @Override
    public Set<Player> getStartTracking() {
        return ImmutableSet.copyOf(this.startTracking);
    }

    @Override
    public Map<Player, CullType> getTracking() {
        return ImmutableMap.copyOf(this.asyncTracking);
    }

    @Override
    public Set<Player> getStopTracking() {
        return ImmutableSet.copyOf(this.stopTracking);
    }
}

