/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.mythic.mechanics.item;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.BoneBehaviorTypes;
import com.ticxo.modelengine.api.model.bone.type.HeldItem;
import com.ticxo.modelengine.core.mythic.MythicUtils;
import com.ticxo.modelengine.core.mythic.utils.MythicMechanic;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EquipmentSlot;

@MythicMechanic(name="linkitembone", aliases={})
public class LinkItemBoneMechanic
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final PlaceholderString slot;

    public LinkItemBoneMechanic(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mlc.getPlaceholderString(new String[]{"b", "bone", "p", "pid", "part", "partid"}, null, new String[0]);
        this.slot = mlc.getPlaceholderString(new String[]{"s", "slot"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String modelId = MythicUtils.getOrNullLowercase(this.modelId, (PlaceholderMeta)meta, target);
        model.getModel(modelId).ifPresent(activeModel -> {
            String partId = MythicUtils.getOrNullLowercase(this.partId, (PlaceholderMeta)meta, target);
            activeModel.getBone(partId).ifPresent(modelBone -> modelBone.getBoneBehavior(BoneBehaviorTypes.ITEM).ifPresent(heldItem -> {
                EquipmentSlot bukkitSlot;
                String slotString = MythicUtils.getOrNull(this.slot, (PlaceholderMeta)meta, target);
                if (slotString == null) {
                    ((HeldItem)((Object)heldItem)).clearItemProvider();
                    return;
                }
                switch (EquipSlot.of((String)slotString)) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case HEAD: {
                        EquipmentSlot equipmentSlot = EquipmentSlot.HEAD;
                        break;
                    }
                    case CHEST: {
                        EquipmentSlot equipmentSlot = EquipmentSlot.CHEST;
                        break;
                    }
                    case LEGS: {
                        EquipmentSlot equipmentSlot = EquipmentSlot.LEGS;
                        break;
                    }
                    case FEET: {
                        EquipmentSlot equipmentSlot = EquipmentSlot.FEET;
                        break;
                    }
                    case HAND: {
                        EquipmentSlot equipmentSlot = EquipmentSlot.HAND;
                        break;
                    }
                    case OFFHAND: {
                        EquipmentSlot equipmentSlot = EquipmentSlot.OFF_HAND;
                        break;
                    }
                    case NONE: {
                        EquipmentSlot equipmentSlot = bukkitSlot = null;
                    }
                }
                if (bukkitSlot == null) {
                    ((HeldItem)((Object)heldItem)).clearItemProvider();
                    return;
                }
                Entity patt2596$temp = target.getBukkitEntity();
                if (patt2596$temp instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)patt2596$temp;
                    if (livingEntity.getEquipment() == null) {
                        return;
                    }
                    ((HeldItem)((Object)heldItem)).setItemProvider(new HeldItem.EquipmentSupplier(livingEntity, bukkitSlot));
                }
            }));
        });
        return SkillResult.SUCCESS;
    }
}

