/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.nms.impl;

import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.nms.entity.wrapper.TrackedEntity;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DummyTrackedEntity
implements TrackedEntity {
    private final Set<Player> tracked = Sets.newConcurrentHashSet();
    private final Set<Player> forcedPairing = Sets.newConcurrentHashSet();
    private final Set<Player> forcedRemove = Sets.newConcurrentHashSet();
    private int baseRange = 64;
    private Predicate<Player> playerPredicate = DEFAULT_PREDICATE;

    public void detectPlayers(Location location) {
        int r2 = this.baseRange * this.baseRange;
        this.tracked.clear();
        for (Player player : Bukkit.getOnlinePlayers()) {
            try {
                if (!(player.getLocation().distanceSquared(location) <= (double)r2)) continue;
                this.tracked.add(player);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Override
    public int getEffectiveRange() {
        return this.baseRange;
    }

    @Override
    public Set<Player> getTrackedPlayer() {
        HashSet<Player> set = new HashSet<Player>(this.forcedPairing);
        for (Player player : this.tracked) {
            if (!this.playerPredicate.test(player) || this.forcedRemove.contains(player)) continue;
            set.add(player);
        }
        return set;
    }

    @Override
    public Set<Player> getTrackedPlayer(Predicate<Player> predicate) {
        HashSet<Player> set = new HashSet<Player>(this.forcedPairing);
        for (Player player : this.tracked) {
            if (!predicate.test(player) || !this.playerPredicate.test(player) || this.forcedRemove.contains(player)) continue;
            set.add(player);
        }
        return set;
    }

    @Override
    public void addForcedPairing(Player player) {
        this.forcedPairing.add(player);
        this.removeForcedHidden(player);
    }

    @Override
    public void removeForcedPairing(Player player) {
        this.forcedPairing.remove(player);
    }

    @Override
    public void addForcedHidden(Player player) {
        this.forcedRemove.add(player);
        this.removeForcedPairing(player);
    }

    @Override
    public void removeForcedHidden(Player player) {
        this.forcedRemove.remove(player);
    }

    @Override
    public Entity getEntity() {
        return null;
    }

    @Override
    public void sendPairingData(Player player) {
    }

    @Override
    public void broadcastSpawn() {
    }

    @Override
    public void broadcastRemove() {
    }

    @Override
    public int getBaseRange() {
        return this.baseRange;
    }

    @Override
    public void setBaseRange(int baseRange) {
        this.baseRange = baseRange;
    }

    @Override
    public Predicate<Player> getPlayerPredicate() {
        return this.playerPredicate;
    }

    @Override
    public void setPlayerPredicate(Predicate<Player> playerPredicate) {
        this.playerPredicate = playerPredicate;
    }
}

