/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.promise;

import com.ticxo.modelengine.api.utils.promise.Promise;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPromise<T>
implements Promise<T> {
    @NotNull
    private final CompletableFuture<T> future;

    protected AbstractPromise() {
        this.future = new CompletableFuture();
    }

    protected AbstractPromise(T val) {
        this.future = CompletableFuture.completedFuture(val);
    }

    @Override
    public Promise<T> runSync(Runnable runnable) {
        this.executeSync(runnable);
        return this;
    }

    @Override
    public Promise<T> runSyncDelay(Runnable runnable, int delay) {
        this.executeSync(runnable, delay);
        return this;
    }

    @Override
    public Promise<T> runAsync(Runnable runnable) {
        this.executeAsync(runnable);
        return this;
    }

    @Override
    public Promise<T> runAsyncDelay(Runnable runnable, int delay) {
        this.executeAsync(runnable, delay);
        return this;
    }

    @Override
    public Promise<T> supplySync(Supplier<T> supplier) {
        this.executeSync(() -> this.future.complete(supplier.get()));
        return this;
    }

    @Override
    public Promise<T> supplySyncDelay(Supplier<T> supplier, int delay) {
        this.executeSync(() -> this.future.complete(supplier.get()), delay);
        return this;
    }

    @Override
    public Promise<T> supplyAsync(Supplier<T> supplier) {
        this.executeAsync(() -> this.future.complete(supplier.get()));
        return this;
    }

    @Override
    public Promise<T> supplyAsyncDelay(Supplier<T> supplier, int delay) {
        this.executeAsync(() -> this.future.complete(supplier.get()), delay);
        return this;
    }

    @Override
    public <U> Promise<U> thenApplySync(Function<? super T, ? extends U> function) {
        AbstractPromise promise = this.createEmpty();
        this.future.whenComplete((t, throwable) -> promise.executeSync(() -> promise.future.complete(function.apply(t))));
        return promise;
    }

    @Override
    public <U> Promise<U> thenApplySyncDelay(Function<? super T, ? extends U> function, int delay) {
        AbstractPromise promise = this.createEmpty();
        this.future.whenComplete((t, throwable) -> promise.executeSync(() -> promise.future.complete(function.apply(t)), delay));
        return promise;
    }

    @Override
    public <U> Promise<U> thenApplyAsync(Function<? super T, ? extends U> function) {
        AbstractPromise promise = this.createEmpty();
        this.future.whenComplete((t, throwable) -> promise.executeAsync(() -> promise.future.complete(function.apply(t))));
        return promise;
    }

    @Override
    public <U> Promise<U> thenApplyAsyncDelay(Function<? super T, ? extends U> function, int delay) {
        AbstractPromise promise = this.createEmpty();
        this.future.whenComplete((t, throwable) -> promise.executeAsync(() -> promise.future.complete(function.apply(t)), delay));
        return promise;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    protected abstract <U> AbstractPromise<U> createEmpty();

    protected abstract void executeSync(Runnable var1);

    protected abstract void executeSync(Runnable var1, int var2);

    protected abstract void executeAsync(Runnable var1);

    protected abstract void executeAsync(Runnable var1, int var2);
}

