/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.handler.AnimationHandler;
import com.ticxo.modelengine.api.entity.Hitbox;
import com.ticxo.modelengine.api.generator.blueprint.BlueprintBone;
import com.ticxo.modelengine.api.generator.blueprint.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehavior;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehaviorType;
import com.ticxo.modelengine.api.model.bone.manager.BehaviorManager;
import com.ticxo.modelengine.api.model.bone.render.BehaviorRenderer;
import com.ticxo.modelengine.api.model.render.ModelRenderer;
import com.ticxo.modelengine.api.nms.entity.EntityHandler;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.data.io.SavedData;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import com.ticxo.modelengine.core.animation.handler.PriorityHandler;
import com.ticxo.modelengine.core.animation.handler.StateMachineHandler;
import com.ticxo.modelengine.core.model.bone.ModelBoneImpl;
import com.ticxo.modelengine.core.model.render.DisplayRendererImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ActiveModelImpl
implements ActiveModel {
    private final ModelBlueprint blueprint;
    private final ModelRenderer modelRenderer;
    private final AnimationHandler animationHandler;
    private final Map<String, ModelBone> bones = Maps.newConcurrentMap();
    private final Map<String, ModelBone> roots = Maps.newConcurrentMap();
    private final Map<BoneBehaviorType<?>, BehaviorManager<?>> behaviorManagers = new LinkedHashMap();
    private final Map<BoneBehaviorType<?>, BehaviorRenderer> behaviorRenderers = new LinkedHashMap();
    private final Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    private final Vector3f hitboxScale = new Vector3f(1.0f, 1.0f, 1.0f);
    private ModeledEntity modeledEntity;
    private boolean mainHitbox;
    private boolean generated;
    private boolean destroyed;
    private boolean removed;
    private boolean autoRendererInitialization = true;
    private boolean hitboxVisible = true;
    private boolean shadowVisible = true;
    private boolean canHurt = true;
    private Color defaultTint = Color.fromRGB((int)0xFFFFFF);
    private Color damageTint = Color.fromRGB((int)0xFF6666);
    private boolean wasMarkedHurt;
    private boolean lockPitch;
    private boolean lockYaw;

    public ActiveModelImpl(@NotNull ModelBlueprint blueprint, @Nullable Function<ActiveModel, ModelRenderer> rendererSupplier, @Nullable Function<ActiveModel, AnimationHandler> handlerSupplier) {
        this.blueprint = blueprint;
        ModelRenderer renderer = rendererSupplier == null ? new DisplayRendererImpl(this) : rendererSupplier.apply(this);
        this.modelRenderer = renderer == null ? new DisplayRendererImpl(this) : renderer;
        AnimationHandler handler = handlerSupplier == null ? ActiveModelImpl.createDefaultHandler(this) : handlerSupplier.apply(this);
        this.animationHandler = handler == null ? ActiveModelImpl.createDefaultHandler(this) : handler;
    }

    private static AnimationHandler createDefaultHandler(ActiveModel activeModel) {
        return ConfigProperty.USE_STATE_MACHINE.getBoolean() ? new StateMachineHandler(activeModel) : new PriorityHandler(activeModel);
    }

    public static ActiveModel fromData(SavedData data) {
        try {
            Optional<SavedData> optionalHandler = data.getData("animation_handler");
            return ModelEngineAPI.createActiveModel(data.getString("blueprint"), null, activeModel -> optionalHandler.map(handlerData -> ModelEngineAPI.getAnimationHandlerRegistry().createHandler((ActiveModel)activeModel, (SavedData)handlerData)).orElse(null));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<String, ModelBone> getBones() {
        return ImmutableMap.copyOf(this.bones);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<BoneBehaviorType<?>, BehaviorManager<?>> getBehaviorManagers() {
        Map<BoneBehaviorType<?>, BehaviorManager<?>> map = this.behaviorManagers;
        synchronized (map) {
            return ImmutableMap.copyOf(this.behaviorManagers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<BoneBehaviorType<?>, BehaviorRenderer> getBehaviorRenderers() {
        Map<BoneBehaviorType<?>, BehaviorRenderer> map = this.behaviorRenderers;
        synchronized (map) {
            return ImmutableMap.copyOf(this.behaviorRenderers);
        }
    }

    @Override
    public void setScale(double scale) {
        this.getScale().set(scale);
        if (!this.mainHitbox || this.modeledEntity == null) {
            return;
        }
        Vector3f scaleVec = this.getScale();
        Hitbox mainHitbox = this.blueprint.getMainHitbox();
        Hitbox scaledRenderHitbox = new Hitbox(mainHitbox.getWidth() * (double)scaleVec.x, mainHitbox.getHeight() * (double)scaleVec.y, mainHitbox.getDepth() * (double)scaleVec.z, mainHitbox.getEyeHeight() * (double)scaleVec.y);
        this.modeledEntity.getBase().getData().setCullHitbox(scaledRenderHitbox);
    }

    @Override
    public void setHitboxScale(double scale) {
        this.getHitboxScale().set(scale);
        if (!this.mainHitbox || this.modeledEntity == null) {
            return;
        }
        Object obj = this.modeledEntity.getBase().getOriginal();
        if (obj instanceof Entity) {
            Entity entity = (Entity)obj;
            EntityHandler entityHandler = ModelEngineAPI.getEntityHandler();
            Vector3f hitboxScale = this.getHitboxScale();
            Hitbox mainHitbox = this.blueprint.getMainHitbox();
            Hitbox scaledHitbox = new Hitbox(mainHitbox.getWidth() * (double)hitboxScale.x, mainHitbox.getHeight() * (double)hitboxScale.y, mainHitbox.getDepth() * (double)hitboxScale.z, mainHitbox.getEyeHeight() * (double)hitboxScale.y);
            entityHandler.setHitbox(entity, scaledHitbox);
        }
    }

    @Override
    public void tick() {
        if (this.isDestroyed()) {
            return;
        }
        this.animationHandler.prepare();
        this.forManagers(BehaviorManager::preBoneTick);
        this.forBones(ModelBone::tick);
        this.forManagers(BehaviorManager::postBoneTick);
        this.forManagers(BehaviorManager::preScriptTick);
        this.animationHandler.tickGlobal();
        this.forManagers(BehaviorManager::postScriptTick);
        this.modelRenderer.readModelData();
        this.wasMarkedHurt = this.isMarkedHurt();
    }

    @Override
    public void destroy() {
        this.forBones(ModelBone::destroy);
        this.forManagers(BehaviorManager::onDestroy);
        this.bones.clear();
        this.modelRenderer.destroy();
        this.destroyed = true;
    }

    @Override
    public void initializeRenderer() {
        if (!this.modelRenderer.isInitialized()) {
            this.modelRenderer.initialize();
        }
    }

    @Override
    public void generateModel() {
        if (this.generated) {
            return;
        }
        this.generated = true;
        for (Map.Entry<String, BlueprintBone> entry : this.blueprint.getFlatMap().entrySet()) {
            BlueprintBone blueprint = entry.getValue();
            ModelBone parent = blueprint.getParent() == null ? null : this.bones.get(blueprint.getParent().getName());
            ModelBoneImpl bone = new ModelBoneImpl(this, blueprint);
            if (parent != null) {
                bone.setParent(parent);
            } else {
                this.roots.put(bone.getUniqueBoneId(), bone);
            }
            for (Map.Entry<BoneBehaviorType<?>, BoneBehaviorType.CachedProvider<?>> behaviorEntry : blueprint.getCachedBehaviorProvider().entrySet()) {
                BoneBehaviorType<?> type = behaviorEntry.getKey();
                BoneBehaviorType.CachedProvider<?> provider = behaviorEntry.getValue();
                this.getBehaviorManager(type);
                this.getBehaviorRenderer(type);
                bone.addBoneBehavior((BoneBehavior)provider.create(bone));
            }
            this.bones.put(bone.getUniqueBoneId(), bone);
        }
        if (this.autoRendererInitialization) {
            this.modelRenderer.initialize();
        }
    }

    @Override
    public void forceGenerateBone(String parentId, String prefix, final BlueprintBone blueprintBone) {
        ModelBone parentBone = parentId == null ? null : (ModelBone)this.getBone(parentId).orElse(null);
        HashMap<String, ModelBoneImpl> map = new HashMap<String, ModelBoneImpl>();
        LinkedList<BlueprintBone> queue = new LinkedList<BlueprintBone>(){
            {
                this.add(blueprintBone);
            }
        };
        while (!queue.isEmpty()) {
            BlueprintBone blueprint = (BlueprintBone)queue.pop();
            queue.addAll(blueprint.getChildren().values());
            String name = blueprint.getName();
            String customId = prefix + name;
            if (this.bones.containsKey(customId)) {
                TLogger.error("Unable to force generate custom bone: ID " + customId + " already exists.");
                continue;
            }
            ModelBone parent = blueprint.getParent() == null ? null : (ModelBone)map.get(blueprint.getParent().getName());
            ModelBoneImpl bone = new ModelBoneImpl(this, blueprint);
            bone.setCustomId(customId);
            if (parent != null) {
                bone.setParent(parent);
            } else if (parentBone != null) {
                bone.setParent(parentBone);
            } else {
                this.roots.put(bone.getUniqueBoneId(), bone);
            }
            for (Map.Entry<BoneBehaviorType<?>, BoneBehaviorType.CachedProvider<?>> behaviorEntry : blueprint.getCachedBehaviorProvider().entrySet()) {
                BoneBehaviorType<?> type = behaviorEntry.getKey();
                BoneBehaviorType.CachedProvider<?> provider = behaviorEntry.getValue();
                this.getBehaviorManager(type);
                this.getBehaviorRenderer(type);
                bone.addBoneBehavior((BoneBehavior)provider.create(bone));
            }
            map.put(name, bone);
            this.bones.put(bone.getUniqueBoneId(), bone);
        }
    }

    @Override
    public void removeBone(String bone) {
        ModelBone removed = this.bones.remove(bone);
        if (removed == null) {
            return;
        }
        this.roots.remove(bone);
    }

    @Override
    public boolean canHurt() {
        return this.canHurt;
    }

    @Override
    public boolean wasMarkedHurt() {
        return this.wasMarkedHurt;
    }

    @Override
    public boolean isMarkedHurt() {
        return this.canHurt && this.modeledEntity != null && this.modeledEntity.getHurtTick() > 0;
    }

    @Override
    public float getXHeadRot() {
        return this.lockPitch ? 0.0f : this.modeledEntity.getXHeadRot();
    }

    @Override
    public float getYHeadRot() {
        return this.lockYaw ? this.modeledEntity.getYBodyRot() : this.modeledEntity.getYHeadRot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends BoneBehavior> Optional<BehaviorManager<T>> getBehaviorManager(BoneBehaviorType<T> type) {
        BoneBehaviorType.BehaviorManagerProvider provider = type.getBehaviorManagerProvider();
        if (provider == null) {
            return Optional.empty();
        }
        Map<BoneBehaviorType<?>, BehaviorManager<?>> map = this.behaviorManagers;
        synchronized (map) {
            return Optional.ofNullable(this.behaviorManagers.computeIfAbsent(type, boneBehaviorType -> {
                BehaviorManager manager = provider.create(this, type);
                if (manager == null) {
                    return null;
                }
                manager.onCreate();
                return manager;
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<BehaviorRenderer> getBehaviorRenderer(BoneBehaviorType<?> type) {
        Map<BoneBehaviorType<?>, BehaviorRenderer> map = this.behaviorRenderers;
        synchronized (map) {
            BehaviorRenderer renderer = this.behaviorRenderers.get(type);
            if (renderer != null) {
                return Optional.of(renderer);
            }
            renderer = type.getRenderType().createBehaviorRenderer(this);
            if (renderer != null) {
                this.behaviorRenderers.put(type, renderer);
            }
            return Optional.ofNullable(renderer);
        }
    }

    private void forBones(Consumer<ModelBone> consumer) {
        for (ModelBone bone : this.bones.values()) {
            if (bone.getParent() != null) continue;
            consumer.accept(bone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forManagers(Consumer<BehaviorManager<?>> consumer) {
        Map<BoneBehaviorType<?>, BehaviorManager<?>> map = this.behaviorManagers;
        synchronized (map) {
            for (BehaviorManager<?> manager : this.behaviorManagers.values()) {
                consumer.accept(manager);
            }
        }
    }

    @Override
    public void save(SavedData data) {
        data.putString("blueprint", this.blueprint.getName());
        data.putFloat("render_scale", Float.valueOf(this.getScale().x));
        data.putFloat("hitbox_scale", Float.valueOf(this.getHitboxScale().x));
        data.putBoolean("can_hurt", this.canHurt());
        data.putInt("default_tint", this.defaultTint.asRGB());
        data.putInt("damage_tint", this.damageTint.asRGB());
        data.putBoolean("lock_pitch", this.lockPitch);
        data.putBoolean("lock_yaw", this.lockYaw);
        data.putBoolean("hitbox_visible", this.hitboxVisible);
        data.putBoolean("shadow_visible", this.shadowVisible);
        data.putBoolean("main_hitbox", this.mainHitbox);
        HashSet<String> removed = new HashSet<String>();
        SavedData boneDataMap = new SavedData();
        for (String boneId : this.blueprint.getFlatMap().keySet()) {
            ModelBone bone = this.bones.get(boneId);
            if (bone == null) {
                removed.add(boneId);
                continue;
            }
            bone.save().ifPresent(boneData -> boneDataMap.putData(boneId, (SavedData)boneData));
        }
        data.putList("removed", removed);
        data.putData("default_bones", boneDataMap);
        this.animationHandler.save().ifPresent(animationData -> data.putData("animation_handler", (SavedData)animationData));
    }

    @Override
    public void load(SavedData data) {
        this.setScale(data.getFloat("render_scale").floatValue());
        this.setHitboxScale(data.getFloat("hitbox_scale").floatValue());
        this.setCanHurt(data.getBoolean("can_hurt"));
        this.setDefaultTint(Color.fromRGB((int)data.getInt("default_tint")));
        this.setDamageTint(Color.fromRGB((int)data.getInt("damage_tint")));
        this.setLockPitch(data.getBoolean("lock_pitch"));
        this.setLockYaw(data.getBoolean("lock_yaw"));
        this.setHitboxVisible(data.getBoolean("hitbox_visible"));
        this.setShadowVisible(data.getBoolean("shadow_visible"));
        this.setMainHitbox(data.getBoolean("main_hitbox"));
        for (String remove : data.getList("removed")) {
            this.removeBone(remove);
        }
        data.getData("default_bones").ifPresent(boneDataMap -> {
            for (String key : boneDataMap.keySet()) {
                this.getBone(key).ifPresent(modelBone -> boneDataMap.getData(key).ifPresent(modelBone::load));
            }
        });
    }

    @Override
    public ModelBlueprint getBlueprint() {
        return this.blueprint;
    }

    @Override
    public ModelRenderer getModelRenderer() {
        return this.modelRenderer;
    }

    @Override
    public AnimationHandler getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public Vector3f getScale() {
        return this.scale;
    }

    @Override
    public Vector3f getHitboxScale() {
        return this.hitboxScale;
    }

    @Override
    public ModeledEntity getModeledEntity() {
        return this.modeledEntity;
    }

    @Override
    public boolean isMainHitbox() {
        return this.mainHitbox;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    public boolean isAutoRendererInitialization() {
        return this.autoRendererInitialization;
    }

    @Override
    public boolean isHitboxVisible() {
        return this.hitboxVisible;
    }

    @Override
    public boolean isShadowVisible() {
        return this.shadowVisible;
    }

    public boolean isCanHurt() {
        return this.canHurt;
    }

    @Override
    public Color getDefaultTint() {
        return this.defaultTint;
    }

    @Override
    public Color getDamageTint() {
        return this.damageTint;
    }

    public boolean isWasMarkedHurt() {
        return this.wasMarkedHurt;
    }

    @Override
    public boolean isLockPitch() {
        return this.lockPitch;
    }

    @Override
    public boolean isLockYaw() {
        return this.lockYaw;
    }

    @Override
    public void setModeledEntity(ModeledEntity modeledEntity) {
        this.modeledEntity = modeledEntity;
    }

    @Override
    public void setMainHitbox(boolean mainHitbox) {
        this.mainHitbox = mainHitbox;
    }

    @Override
    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    @Override
    public void setAutoRendererInitialization(boolean autoRendererInitialization) {
        this.autoRendererInitialization = autoRendererInitialization;
    }

    @Override
    public void setHitboxVisible(boolean hitboxVisible) {
        this.hitboxVisible = hitboxVisible;
    }

    @Override
    public void setShadowVisible(boolean shadowVisible) {
        this.shadowVisible = shadowVisible;
    }

    @Override
    public void setCanHurt(boolean canHurt) {
        this.canHurt = canHurt;
    }

    @Override
    public void setDefaultTint(Color defaultTint) {
        this.defaultTint = defaultTint;
    }

    @Override
    public void setDamageTint(Color damageTint) {
        this.damageTint = damageTint;
    }

    @Override
    public void setLockPitch(boolean lockPitch) {
        this.lockPitch = lockPitch;
    }

    @Override
    public void setLockYaw(boolean lockYaw) {
        this.lockYaw = lockYaw;
    }
}

