/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.model.bone;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.generator.BaseItemEnum;
import com.ticxo.modelengine.api.generator.blueprint.BlueprintBone;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehavior;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehaviorType;
import com.ticxo.modelengine.api.model.bone.behavior.ProceduralType;
import com.ticxo.modelengine.api.utils.OffsetMode;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.data.io.SavedData;
import com.ticxo.modelengine.api.utils.data.tracker.DataTracker;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModelBoneImpl
implements ModelBone {
    @NotNull
    private final ActiveModel activeModel;
    @NotNull
    private final BlueprintBone blueprintBone;
    private final Map<String, ModelBone> children = Maps.newConcurrentMap();
    private final Map<BoneBehaviorType<?>, BoneBehavior> boneBehaviors = new LinkedHashMap();
    private final DataTracker<ItemStack> modelTracker = new DataTracker<ItemStack>(new ItemStack(Material.AIR));
    private final Vector3f modelScale = new Vector3f();
    private final Set<ProceduralType> proceduralTypes = new HashSet<ProceduralType>();
    private final AtomicReference<Vector3f> trueGlobalPosition = new AtomicReference<Vector3f>(new Vector3f());
    private final AtomicReference<Quaternionf> trueGlobalLeftRotation = new AtomicReference<Quaternionf>(new Quaternionf());
    private final AtomicReference<Vector3f> trueGlobalScale = new AtomicReference<Vector3f>(new Vector3f());
    private final AtomicReference<Quaternionf> trueGlobalRightRotation = new AtomicReference<Quaternionf>(new Quaternionf());
    private Vector3f cachedPosition = new Vector3f();
    private Vector3f cachedLeftRotation = new Vector3f();
    private Vector3f cachedScale = new Vector3f();
    private Vector3f cachedRightRotation = new Vector3f();
    private Vector3f globalPosition = new Vector3f();
    private Quaternionf globalLeftRotation = new Quaternionf();
    private Vector3f globalScale = new Vector3f();
    private Quaternionf globalRightRotation = new Quaternionf();
    private String customId = null;
    @Nullable
    private ModelBone parent;
    private boolean isRenderer;
    private float yaw;
    private boolean hasGlobalRotation;
    private Color lastColor;
    private Color defaultTint;
    private Color damageTint;
    private boolean enchanted;
    private boolean visible = true;
    private boolean markedDestroy;

    public ModelBoneImpl(@NotNull ActiveModel activeModel, @NotNull BlueprintBone blueprintBone) {
        this.activeModel = activeModel;
        this.blueprintBone = blueprintBone;
        this.globalPosition.set((Vector3fc)blueprintBone.getRotatedGlobalPosition());
        this.globalLeftRotation.set((Quaternionfc)blueprintBone.getGlobalQuaternion());
        this.modelScale.set((Vector3fc)blueprintBone.getModelScale()).mul((float)blueprintBone.getScale());
        this.globalScale.set((Vector3fc)this.modelScale);
        this.isRenderer = blueprintBone.isRenderer();
        if (this.isRenderer) {
            this.setModel(blueprintBone.getDataId());
        } else {
            BlueprintBone dupeTarget = blueprintBone.getDupeTarget();
            if (dupeTarget != null && dupeTarget.isRenderer()) {
                this.setModel(dupeTarget.getDataId());
                this.isRenderer = true;
            }
        }
        this.setVisible(blueprintBone.isRenderByDefault());
    }

    @Override
    public String getUniqueBoneId() {
        return this.getCustomId() == null ? this.getBoneId() : this.getCustomId();
    }

    @Override
    public String getBoneId() {
        return this.blueprintBone.getName();
    }

    @Override
    public void setParent(@Nullable ModelBone bone) {
        if (this.parent != null) {
            this.parent.getChildren().remove(this.getUniqueBoneId());
        }
        this.parent = bone;
        if (this.parent != null) {
            this.parent.getChildren().put(this.getUniqueBoneId(), this);
        }
        this.forBehaviors(boneBehavior -> boneBehavior.onParentSwap(this.parent));
    }

    @Override
    public void tick() {
        this.tryTintModel();
        this.cachedPosition.set(0.0f, 0.0f, 0.0f);
        this.cachedLeftRotation.set(0.0f, 0.0f, 0.0f);
        this.cachedScale.set(1.0f, 1.0f, 1.0f);
        this.cachedRightRotation.set(0.0f, 0.0f, 0.0f);
        this.forBehaviors(BoneBehavior::preAnimation);
        if (this.proceduralTypes.contains((Object)ProceduralType.ANIMATION)) {
            this.forBehaviors(BoneBehavior::onAnimation);
        } else {
            this.activeModel.getAnimationHandler().updateBone(this);
        }
        this.forBehaviors(BoneBehavior::postAnimation);
        this.forBehaviors(BoneBehavior::preGlobalCalculation);
        if (this.proceduralTypes.contains((Object)ProceduralType.TRANSFORM)) {
            this.forBehaviors(BoneBehavior::onGlobalCalculation);
        } else {
            this.calculateGlobalTransform();
        }
        this.forBehaviors(BoneBehavior::postGlobalCalculation);
        this.yaw = this.activeModel.getModeledEntity().getYBodyRot();
        if (!this.children.isEmpty()) {
            this.forBehaviors(BoneBehavior::preChildCalculation);
            this.children.values().forEach(ModelBone::tick);
            this.forBehaviors(BoneBehavior::postChildCalculation);
        }
        this.globalScale.mul((Vector3fc)this.modelScale).mul((Vector3fc)this.activeModel.getScale());
        this.globalPosition.mul((Vector3fc)this.activeModel.getScale());
        this.forBehaviors(BoneBehavior::onFinalize);
        this.trueGlobalPosition.set(this.globalPosition);
        this.trueGlobalLeftRotation.set(this.globalLeftRotation);
        this.trueGlobalScale.set(this.globalScale);
        this.trueGlobalRightRotation.set(this.globalRightRotation);
    }

    @Override
    public void destroy() {
        this.markedDestroy = true;
        this.boneBehaviors.values().forEach(BoneBehavior::onRemove);
        this.children.values().forEach(ModelBone::destroy);
        this.children.clear();
        if (this.parent != null && !this.parent.isMarkedDestroy()) {
            this.parent.getChildren().remove(this.getUniqueBoneId());
        }
        this.activeModel.removeBone(this.getUniqueBoneId());
    }

    @Override
    public void setModelScale(int scale) {
        this.modelScale.set((float)scale);
    }

    @Override
    public void calculateGlobalTransform() {
        this.cachedPosition.add((Vector3fc)this.blueprintBone.getLocalPosition());
        this.cachedLeftRotation.add((Vector3fc)this.blueprintBone.getLocalRotation());
        Quaternionf localQuaternion = new Quaternionf().rotationZYX(this.cachedLeftRotation.z, this.cachedLeftRotation.y, this.cachedLeftRotation.x);
        if (this.parent != null) {
            Vector3f parentPosition = this.parent.getGlobalPosition();
            Quaternionf parentRotation = this.parent.getGlobalLeftRotation();
            Vector3f parentScale = this.parent.getGlobalScale();
            parentPosition.add((Vector3fc)this.cachedPosition.mul((Vector3fc)parentScale).rotate((Quaternionfc)parentRotation), this.globalPosition);
            if (!this.hasGlobalRotation()) {
                parentRotation.mul((Quaternionfc)localQuaternion, this.globalLeftRotation);
            } else {
                this.globalLeftRotation.set((Quaternionfc)localQuaternion);
            }
            parentScale.mul((Vector3fc)this.cachedScale, this.globalScale);
        } else {
            this.globalPosition.set((Vector3fc)this.cachedPosition);
            this.globalLeftRotation.set((Quaternionfc)localQuaternion);
            this.globalScale.set((Vector3fc)this.cachedScale);
        }
    }

    @Override
    public Vector3f getTrueGlobalPosition() {
        return this.trueGlobalPosition.get();
    }

    @Override
    public Quaternionf getTrueGlobalLeftRotation() {
        return this.trueGlobalLeftRotation.get();
    }

    @Override
    public Vector3f getTrueGlobalScale() {
        return this.trueGlobalScale.get();
    }

    @Override
    public Quaternionf getTrueGlobalRightRotation() {
        return this.trueGlobalRightRotation.get();
    }

    @Override
    public boolean hasGlobalRotation() {
        return this.hasGlobalRotation;
    }

    @Override
    public ItemStack getModel() {
        return this.modelTracker.get();
    }

    @Override
    public void setModel(int data) {
        BaseItemEnum base = ConfigProperty.ITEM_MODEL.getBaseItem();
        ItemStack model = this.modelTracker.get();
        model.setType(base.getMaterial());
        ItemMeta meta = model.getItemMeta();
        base.color(meta, this.getColor());
        meta.setCustomModelData(Integer.valueOf(data));
        model.setItemMeta(meta);
        this.modelTracker.set(model);
        this.modelTracker.markDirty();
    }

    @Override
    public void setModel(ItemStack stack) {
        this.modelTracker.set(stack);
    }

    @Override
    public Color getDefaultTint() {
        return this.defaultTint == null ? this.activeModel.getDefaultTint() : this.defaultTint;
    }

    @Override
    public Color getDamageTint() {
        return this.damageTint == null ? this.activeModel.getDamageTint() : this.damageTint;
    }

    @Override
    public void setEnchanted(boolean flag) {
        if (this.isEnchanted() == flag) {
            return;
        }
        this.enchanted = flag;
        ItemStack model = this.modelTracker.get();
        if (flag) {
            model.addUnsafeEnchantment(Enchantment.VANISHING_CURSE, 1);
        } else {
            model.removeEnchantment(Enchantment.VANISHING_CURSE);
        }
        this.modelTracker.markDirty();
    }

    @Override
    public Location getLocation() {
        return this.getLocation(OffsetMode.LOCAL, new Vector3f(), true);
    }

    @Override
    public Location getLocation(OffsetMode mode, Vector3f offset, boolean scale) {
        ModeledEntity modeledEntity = this.getActiveModel().getModeledEntity();
        float angle = (180.0f - modeledEntity.getYBodyRot()) * ((float)Math.PI / 180);
        Vector3f bonePosition = this.getTrueGlobalPosition();
        Quaternionf boneRotation = this.getTrueGlobalLeftRotation();
        if (scale) {
            offset.mul((Vector3fc)this.modelScale);
        }
        bonePosition = switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case OffsetMode.LOCAL -> bonePosition.add((Vector3fc)offset.rotate((Quaternionfc)boneRotation), new Vector3f()).rotateY(angle);
            case OffsetMode.MODEL -> bonePosition.add((Vector3fc)offset, new Vector3f()).rotateY(angle);
            case OffsetMode.GLOBAL -> bonePosition.rotateY(angle, new Vector3f()).add((Vector3fc)offset);
        };
        return modeledEntity.getBase().getLocation().clone().add((double)bonePosition.x, (double)bonePosition.y, (double)bonePosition.z);
    }

    @Override
    public void addBoneBehavior(BoneBehavior boneBehavior) {
        this.boneBehaviors.put(boneBehavior.getType(), boneBehavior);
        boneBehavior.onApply();
        this.proceduralTypes.addAll(boneBehavior.getType().getProceduralTypes());
    }

    @Override
    public boolean hasBoneBehavior(BoneBehaviorType<?> type) {
        return this.boneBehaviors.containsKey(type);
    }

    @Override
    public <T extends BoneBehavior> Optional<T> getBoneBehavior(BoneBehaviorType<T> type) {
        BoneBehavior behavior = this.boneBehaviors.get(type);
        return Optional.ofNullable(behavior);
    }

    @Override
    public <T extends BoneBehavior> Optional<T> removeBoneBehavior(BoneBehaviorType<T> type) {
        BoneBehavior behavior = this.boneBehaviors.remove(type);
        if (behavior != null) {
            behavior.onRemove();
        }
        return Optional.ofNullable(behavior);
    }

    @Override
    public Map<BoneBehaviorType<?>, BoneBehavior> getImmutableBoneBehaviors() {
        return ImmutableMap.copyOf(this.boneBehaviors);
    }

    private void forBehaviors(Consumer<BoneBehavior> consumer) {
        this.boneBehaviors.values().forEach(consumer);
    }

    private void tryTintModel() {
        ItemStack model = this.modelTracker.get();
        BaseItemEnum base = BaseItemEnum.fromMaterial(model.getType());
        if (base == null) {
            return;
        }
        Color color = this.getColor();
        if (color == this.lastColor) {
            return;
        }
        this.lastColor = color;
        ItemMeta meta = model.getItemMeta();
        base.color(meta, color);
        model.setItemMeta(meta);
        this.modelTracker.markDirty();
    }

    private Color getColor() {
        return this.activeModel.isMarkedHurt() ? this.getDamageTint() : this.getDefaultTint();
    }

    @Override
    public void save(SavedData data) {
        if (this.defaultTint != null) {
            data.putInt("default_tint", this.defaultTint.asRGB());
        }
        if (this.damageTint != null) {
            data.putInt("damage_tint", this.damageTint.asRGB());
        }
        if (this.blueprintBone.isRenderByDefault() != this.isVisible()) {
            data.putBoolean("visible", this.isVisible());
        }
        if (this.isEnchanted()) {
            data.putBoolean("enchant", true);
        }
        this.forBehaviors(behavior -> behavior.save().ifPresent(data1 -> data.putData(behavior.getType().getId(), (SavedData)data1)));
    }

    @Override
    public void load(SavedData data) {
        Boolean visible;
        Integer damageTint;
        Integer defaultTint = data.getInt("default_tint");
        if (defaultTint != null) {
            this.setDefaultTint(Color.fromRGB((int)defaultTint));
        }
        if ((damageTint = data.getInt("damage_tint")) != null) {
            this.setDamageTint(Color.fromRGB((int)damageTint));
        }
        if ((visible = data.getBoolean("visible")) != null) {
            this.setVisible(visible);
        }
        if (data.getBoolean("enchant", false).booleanValue()) {
            this.setEnchanted(true);
        }
        this.forBehaviors(behavior -> data.getData(behavior.getType().getId()).ifPresent(behavior::load));
    }

    @Override
    @NotNull
    public ActiveModel getActiveModel() {
        return this.activeModel;
    }

    @Override
    @NotNull
    public BlueprintBone getBlueprintBone() {
        return this.blueprintBone;
    }

    @Override
    public Map<String, ModelBone> getChildren() {
        return this.children;
    }

    @Override
    public DataTracker<ItemStack> getModelTracker() {
        return this.modelTracker;
    }

    public Vector3f getModelScale() {
        return this.modelScale;
    }

    public Set<ProceduralType> getProceduralTypes() {
        return this.proceduralTypes;
    }

    @Override
    public Vector3f getCachedPosition() {
        return this.cachedPosition;
    }

    @Override
    public Vector3f getCachedLeftRotation() {
        return this.cachedLeftRotation;
    }

    @Override
    public Vector3f getCachedScale() {
        return this.cachedScale;
    }

    @Override
    public Vector3f getCachedRightRotation() {
        return this.cachedRightRotation;
    }

    @Override
    public Vector3f getGlobalPosition() {
        return this.globalPosition;
    }

    @Override
    public Quaternionf getGlobalLeftRotation() {
        return this.globalLeftRotation;
    }

    @Override
    public Vector3f getGlobalScale() {
        return this.globalScale;
    }

    @Override
    public Quaternionf getGlobalRightRotation() {
        return this.globalRightRotation;
    }

    @Override
    public String getCustomId() {
        return this.customId;
    }

    @Override
    @Nullable
    public ModelBone getParent() {
        return this.parent;
    }

    @Override
    public boolean isRenderer() {
        return this.isRenderer;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    public boolean isHasGlobalRotation() {
        return this.hasGlobalRotation;
    }

    public Color getLastColor() {
        return this.lastColor;
    }

    @Override
    public boolean isEnchanted() {
        return this.enchanted;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isMarkedDestroy() {
        return this.markedDestroy;
    }

    @Override
    public void setCachedPosition(Vector3f cachedPosition) {
        this.cachedPosition = cachedPosition;
    }

    @Override
    public void setCachedLeftRotation(Vector3f cachedLeftRotation) {
        this.cachedLeftRotation = cachedLeftRotation;
    }

    @Override
    public void setCachedScale(Vector3f cachedScale) {
        this.cachedScale = cachedScale;
    }

    @Override
    public void setCachedRightRotation(Vector3f cachedRightRotation) {
        this.cachedRightRotation = cachedRightRotation;
    }

    @Override
    public void setGlobalPosition(Vector3f globalPosition) {
        this.globalPosition = globalPosition;
    }

    @Override
    public void setGlobalLeftRotation(Quaternionf globalLeftRotation) {
        this.globalLeftRotation = globalLeftRotation;
    }

    @Override
    public void setGlobalScale(Vector3f globalScale) {
        this.globalScale = globalScale;
    }

    @Override
    public void setGlobalRightRotation(Quaternionf globalRightRotation) {
        this.globalRightRotation = globalRightRotation;
    }

    @Override
    public void setCustomId(String customId) {
        this.customId = customId;
    }

    @Override
    public void setRenderer(boolean isRenderer) {
        this.isRenderer = isRenderer;
    }

    @Override
    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    @Override
    public void setHasGlobalRotation(boolean hasGlobalRotation) {
        this.hasGlobalRotation = hasGlobalRotation;
    }

    @Override
    public void setDefaultTint(Color defaultTint) {
        this.defaultTint = defaultTint;
    }

    @Override
    public void setDamageTint(Color damageTint) {
        this.damageTint = damageTint;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setMarkedDestroy(boolean markedDestroy) {
        this.markedDestroy = markedDestroy;
    }
}

