/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.mythic;

import com.google.common.collect.Lists;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.blueprint.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.mount.controller.MountControllerSupplier;
import com.ticxo.modelengine.core.ModelEngine;
import com.ticxo.modelengine.core.mythic.compatibility.MythicMountController;
import com.ticxo.modelengine.core.mythic.compatibility.ProjectileEntity;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.jetbrains.annotations.Nullable;

public class MythicUtils {
    public static String getOrNull(@Nullable PlaceholderString placeholderString) {
        return placeholderString == null ? null : placeholderString.get();
    }

    public static String getOrNull(@Nullable PlaceholderString placeholderString, PlaceholderMeta meta) {
        return placeholderString == null ? null : placeholderString.get(meta);
    }

    public static String getOrNull(@Nullable PlaceholderString placeholderString, AbstractEntity entity) {
        return placeholderString == null ? null : placeholderString.get(entity);
    }

    public static String getOrNull(@Nullable PlaceholderString placeholderString, PlaceholderMeta meta, AbstractEntity entity) {
        return placeholderString == null ? null : placeholderString.get(meta, entity);
    }

    public static String getOrNull(@Nullable PlaceholderString placeholderString, SkillCaster caster) {
        return placeholderString == null ? null : placeholderString.get(caster);
    }

    public static String getOrNullLowercase(@Nullable PlaceholderString placeholderString) {
        return placeholderString == null ? null : placeholderString.get().toLowerCase(Locale.ENGLISH);
    }

    public static String getOrNullLowercase(@Nullable PlaceholderString placeholderString, PlaceholderMeta meta) {
        return placeholderString == null ? null : placeholderString.get(meta).toLowerCase(Locale.ENGLISH);
    }

    public static String getOrNullLowercase(@Nullable PlaceholderString placeholderString, AbstractEntity entity) {
        return placeholderString == null ? null : placeholderString.get(entity).toLowerCase(Locale.ENGLISH);
    }

    public static String getOrNullLowercase(@Nullable PlaceholderString placeholderString, PlaceholderMeta meta, AbstractEntity entity) {
        return placeholderString == null ? null : placeholderString.get(meta, entity).toLowerCase(Locale.ENGLISH);
    }

    public static String getOrNullLowercase(@Nullable PlaceholderString placeholderString, SkillCaster caster) {
        return placeholderString == null ? null : placeholderString.get(caster).toLowerCase(Locale.ENGLISH);
    }

    public static Color getColor(@Nullable String colorString) {
        if (colorString == null) {
            return Color.WHITE;
        }
        if (colorString.startsWith("#")) {
            colorString = colorString.substring(1);
        }
        return Color.fromRGB((int)Integer.parseInt(colorString, 16));
    }

    public static ActiveModel getActiveModelOrNull(ModeledEntity entity, @Nullable String modelId) {
        return modelId == null ? null : (ActiveModel)entity.getModel(modelId.toLowerCase(Locale.ENGLISH)).orElse(null);
    }

    public static ModelBlueprint getBlueprintOrNull(@Nullable String modelid) {
        return modelid == null ? null : ModelEngineAPI.getBlueprint(modelid);
    }

    public static ProjectileEntity getProjectileEntity(SkillMetadata meta) {
        IParentSkill iParentSkill = meta.getCallingEvent();
        if (!(iParentSkill instanceof Projectile.ProjectileTracker)) {
            return null;
        }
        Projectile.ProjectileTracker projectileTracker = (Projectile.ProjectileTracker)iParentSkill;
        return ModelEngine.CORE.getMythicCompatibility().getMythicSupport().getTrackers().get(projectileTracker);
    }

    public static UUID getVFXUniqueId(SkillMetadata meta) {
        ProjectileEntity base = MythicUtils.getProjectileEntity(meta);
        if (base != null) {
            return base.getUUID();
        }
        return meta.getCaster().getEntity().getUniqueId();
    }

    public static void executeOptModelId(ModeledEntity entity, String modelId, Consumer<ActiveModel> consumer) {
        if (modelId == null) {
            for (ActiveModel activeModel : entity.getModels().values()) {
                consumer.accept(activeModel);
            }
        } else {
            ActiveModel activeModel = MythicUtils.getActiveModelOrNull(entity, modelId);
            if (activeModel != null) {
                consumer.accept(activeModel);
            }
        }
    }

    public static MountControllerSupplier createControllerSupplier(Skill skill, SkillMetadata metadata) {
        return (entity, mount) -> new MythicMountController(entity, mount, skill, metadata);
    }

    public static List<File> getPackModelFiles() {
        ArrayList files = Lists.newArrayList();
        for (Pack pack : MythicBukkit.inst().getPackManager().getPacks()) {
            File folder = pack.getPackFolder("Models");
            if (!folder.exists()) continue;
            MythicUtils.addFilesRecursively(folder, files);
        }
        return files;
    }

    private static void addFilesRecursively(File folder, List<File> files) {
        File[] fileList = folder.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (file.isFile() && file.getName().endsWith(".bbmodel")) {
                    files.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                MythicUtils.addFilesRecursively(file, files);
            }
        }
    }
}

