/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.mythic.compatibility;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.ModelGenerator;
import com.ticxo.modelengine.api.generator.blueprint.BlueprintBone;
import com.ticxo.modelengine.api.generator.blueprint.ModelBlueprint;
import com.ticxo.modelengine.api.nms.entity.HitboxEntity;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.math.OrientedBoundingBox;
import com.ticxo.modelengine.core.mythic.compatibility.MEGModel;
import com.ticxo.modelengine.core.mythic.compatibility.ProjectileEntity;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.AbstractModelEngineSupport;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.model.MobModel;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.util.BoundingBox;

public class ModelEngineSupportImpl
extends AbstractModelEngineSupport {
    private final Map<Projectile.ProjectileTracker, ProjectileEntity> trackers = Maps.newConcurrentMap();

    public ModelEngineSupportImpl() {
        super(MythicBukkit.inst());
    }

    public boolean isSubHitbox(UUID uuid) {
        return ModelEngineAPI.getInteractionTracker().getHitbox(uuid) != null;
    }

    public boolean isBoundToSubHitbox(UUID subHitbox, UUID bound) {
        HitboxEntity hitbox = ModelEngineAPI.getInteractionTracker().getHitbox(subHitbox);
        return hitbox != null && hitbox.getSubHitbox().getBoundEntities().containsKey(bound);
    }

    public UUID getParentUUID(UUID uuid) {
        HitboxEntity hitbox = ModelEngineAPI.getInteractionTracker().getHitbox(uuid);
        if (hitbox == null) {
            return uuid;
        }
        return hitbox.getBone().getActiveModel().getModeledEntity().getBase().getUUID();
    }

    public AbstractEntity getParent(AbstractEntity abstractEntity) {
        HitboxEntity hitbox = ModelEngineAPI.getInteractionTracker().getHitbox(abstractEntity.getUniqueId());
        if (hitbox == null) {
            return abstractEntity;
        }
        Object obj = hitbox.getBone().getActiveModel().getModeledEntity().getBase().getOriginal();
        if (obj instanceof Entity) {
            Entity entity = (Entity)obj;
            return BukkitAdapter.adapt((Entity)entity);
        }
        return abstractEntity;
    }

    public boolean overlapsOOBB(BoundingBox boundingBox, AbstractEntity abstractEntity) {
        HitboxEntity hitbox = ModelEngineAPI.getInteractionTracker().getHitbox(abstractEntity.getUniqueId());
        if (hitbox == null) {
            return false;
        }
        OrientedBoundingBox obb = hitbox.getOrientedBoundingBox();
        return obb != null && obb.intersects(boundingBox);
    }

    public AbstractModelEngineSupport.ModelConfig getBoneModel(String modelId, String boneId) throws IllegalArgumentException {
        ModelBlueprint blueprint = ModelEngineAPI.getBlueprint(modelId);
        if (blueprint == null) {
            throw new IllegalArgumentException("Unknown model " + modelId + ".");
        }
        BlueprintBone blueprintBone = blueprint.getFlatMap().get(boneId);
        if (blueprintBone == null) {
            throw new IllegalArgumentException("Unknown bone " + boneId + ".");
        }
        if (!blueprintBone.isRenderer()) {
            throw new IllegalArgumentException(boneId + " is not a renderer bone.");
        }
        return new AbstractModelEngineSupport.ModelConfig(blueprintBone.getDataId(), ConfigProperty.ITEM_MODEL.getBaseItem().getMaterial(), false);
    }

    public MobModel createMobModel(MythicMob mythicMob, MythicConfig mythicConfig) {
        return new MEGModel(mythicMob, mythicConfig);
    }

    public void queuePostModelRegistration(Runnable runnable) {
        ModelEngineAPI.getAPI().getModelGenerator().queueTask(ModelGenerator.Phase.POST_ASSETS, runnable);
    }

    public void load(MythicBukkit mythicBukkit) {
        MythicLogger.log((String)"Model Engine Compatibility Loaded.");
    }

    public void unload() {
    }

    public Map<Projectile.ProjectileTracker, ProjectileEntity> getTrackers() {
        return this.trackers;
    }
}

