/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.v1_20_R1.parser.behavior;

import com.ticxo.modelengine.api.entity.data.IEntityData;
import com.ticxo.modelengine.api.model.bone.render.BehaviorRendererParser;
import com.ticxo.modelengine.api.model.bone.render.renderer.HeldItemRenderer;
import com.ticxo.modelengine.api.utils.data.tracker.CollectionDataTracker;
import com.ticxo.modelengine.v1_20_R1.entity.EntityUtils;
import com.ticxo.modelengine.v1_20_R1.network.utils.NetworkUtils;
import com.ticxo.modelengine.v1_20_R1.network.utils.Packets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.joml.Quaternionf;

public class HeldItemParser
implements BehaviorRendererParser<HeldItemRenderer> {
    @Override
    public void sendToClients(HeldItemRenderer renderer) {
        IEntityData data = renderer.getModelRenderer().getActiveModel().getModeledEntity().getBase().getData();
        this.update(data.getTracking().keySet(), renderer);
        this.spawn(data.getStartTracking(), renderer);
        this.remove(data.getStopTracking(), renderer);
    }

    @Override
    public void destroy(HeldItemRenderer renderer) {
        IEntityData data = renderer.getActiveModel().getModeledEntity().getBase().getData();
        HashSet<Player> inRange = new HashSet<Player>(data.getStartTracking());
        inRange.addAll(data.getTracking().keySet());
        inRange.addAll(data.getStopTracking());
        this.remove(inRange, renderer);
    }

    private void spawn(Set<Player> targets, HeldItemRenderer renderer) {
        if (targets.isEmpty()) {
            return;
        }
        Packets set = new Packets();
        Location location = renderer.getActiveModel().getModeledEntity().getBase().getLocation();
        set.add((Packet<PacketListenerPlayOut>)this.pivotSpawn(location, renderer));
        set.add((Packet<PacketListenerPlayOut>)this.pivotData(renderer));
        for (HeldItemRenderer.Item item : renderer.getRendered().values()) {
            set.add((Packet<PacketListenerPlayOut>)this.itemSpawn(location, item));
            set.add((Packet<PacketListenerPlayOut>)this.itemData(item, true));
        }
        for (HeldItemRenderer.Item item : renderer.getSpawnQueue().values()) {
            set.add((Packet<PacketListenerPlayOut>)this.itemSpawn(location, item));
            set.add((Packet<PacketListenerPlayOut>)this.itemData(item, true));
        }
        set.add((Packet<PacketListenerPlayOut>)this.mount(renderer));
        NetworkUtils.sendBundled(targets, set);
    }

    private void update(Set<Player> targets, HeldItemRenderer renderer) {
        if (targets.isEmpty()) {
            return;
        }
        Packets set = new Packets();
        set.add((Packet<PacketListenerPlayOut>)this.teleport(renderer));
        for (Object item2 : renderer.getRendered().values()) {
            set.add((Packet<PacketListenerPlayOut>)this.itemData((HeldItemRenderer.Item)item2, false));
        }
        Location location = renderer.getActiveModel().getModeledEntity().getBase().getLocation();
        for (HeldItemRenderer.Item item3 : renderer.getSpawnQueue().values()) {
            set.add((Packet<PacketListenerPlayOut>)this.itemSpawn(location, item3));
            set.add((Packet<PacketListenerPlayOut>)this.itemData(item3, true));
        }
        Map destroy = renderer.getDestroyQueue();
        if (!destroy.isEmpty()) {
            PacketDataSerializer buf = NetworkUtils.createByteBuf();
            buf.d(destroy.size());
            destroy.forEach((s, item) -> buf.d(item.getId()));
            set.add((Packet<PacketListenerPlayOut>)new PacketPlayOutEntityDestroy(buf));
        }
        if (renderer.getPassengers().isDirty()) {
            set.add((Packet<PacketListenerPlayOut>)this.mount(renderer));
            renderer.getPassengers().clearDirty();
        }
        NetworkUtils.sendBundled(targets, set);
    }

    private void remove(Set<Player> targets, HeldItemRenderer renderer) {
        if (targets.isEmpty()) {
            return;
        }
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        Map items = renderer.getRendered();
        buf.d(1 + items.size());
        buf.d(renderer.getId());
        items.forEach((s, item) -> buf.d(item.getId()));
        NetworkUtils.send(targets, (Packet<PacketListenerPlayOut>)new PacketPlayOutEntityDestroy(buf));
    }

    private PacketPlayOutSpawnEntity pivotSpawn(Location location, HeldItemRenderer renderer) {
        return new PacketPlayOutSpawnEntity(renderer.getId(), renderer.getUuid(), location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f, EntityTypes.d, 0, Vec3D.b, 0.0);
    }

    private PacketPlayOutEntityMetadata pivotData(HeldItemRenderer renderer) {
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.d(renderer.getId());
        EntityUtils.writeData(buf, 0, DataWatcherRegistry.a, (byte)32);
        EntityUtils.writeData(buf, 1, DataWatcherRegistry.b, Integer.MAX_VALUE);
        EntityUtils.writeData(buf, 15, DataWatcherRegistry.a, (byte)16);
        buf.writeByte(255);
        return new PacketPlayOutEntityMetadata(buf);
    }

    private PacketPlayOutSpawnEntity itemSpawn(Location location, HeldItemRenderer.Item renderer) {
        return new PacketPlayOutSpawnEntity(renderer.getId(), renderer.getUuid(), location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f, EntityTypes.ae, 0, Vec3D.b, 0.0);
    }

    private PacketPlayOutEntityMetadata itemData(HeldItemRenderer.Item renderer, boolean spawn) {
        if (!spawn && !renderer.isDirty()) {
            return null;
        }
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.d(renderer.getId());
        if (spawn) {
            EntityUtils.writeData(buf, 0, DataWatcherRegistry.a, (byte)32);
            EntityUtils.writeData(buf, 1, DataWatcherRegistry.b, Integer.MAX_VALUE);
            EntityUtils.writeData(buf, 8, DataWatcherRegistry.b, 0);
            EntityUtils.writeData(buf, 9, DataWatcherRegistry.b, 1);
            EntityUtils.writeData(buf, 16, DataWatcherRegistry.d, Float.valueOf(4096.0f));
        } else if (renderer.isTransformDirty()) {
            EntityUtils.writeData(buf, 8, DataWatcherRegistry.b, 0);
        }
        renderer.getPosition().ifDirty(vector3f -> EntityUtils.writeData(buf, 10, DataWatcherRegistry.A, vector3f), spawn);
        renderer.getScale().ifDirty(vector3f -> EntityUtils.writeData(buf, 11, DataWatcherRegistry.A, vector3f), spawn);
        renderer.getRotation().ifDirty(quaternionf -> EntityUtils.writeData(buf, 12, DataWatcherRegistry.B, quaternionf.rotateY((float)Math.PI, new Quaternionf())), spawn);
        renderer.getWidth().ifDirty(width -> EntityUtils.writeData(buf, 19, DataWatcherRegistry.d, width), spawn);
        renderer.getHeight().ifDirty(height -> EntityUtils.writeData(buf, 20, DataWatcherRegistry.d, height), spawn);
        renderer.getModel().ifDirty(itemStack -> EntityUtils.writeData(buf, 22, DataWatcherRegistry.h, CraftItemStack.asNMSCopy((ItemStack)itemStack)), spawn);
        renderer.getDisplay().ifDirty(display -> EntityUtils.writeData(buf, 23, DataWatcherRegistry.a, display == null ? (byte)0 : (byte)display.ordinal()), spawn);
        buf.writeByte(255);
        renderer.clearDirty();
        return new PacketPlayOutEntityMetadata(buf);
    }

    private PacketPlayOutEntityTeleport teleport(HeldItemRenderer renderer) {
        Location location = renderer.getActiveModel().getModeledEntity().getBase().getLocation();
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.d(renderer.getId());
        buf.writeDouble(location.getX());
        buf.writeDouble(location.getY());
        buf.writeDouble(location.getZ());
        buf.writeByte(0);
        buf.writeByte(0);
        buf.writeBoolean(false);
        return new PacketPlayOutEntityTeleport(buf);
    }

    private PacketPlayOutMount mount(HeldItemRenderer renderer) {
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.d(renderer.getId());
        CollectionDataTracker<Integer> set = renderer.getPassengers();
        buf.d(set.size());
        set.forEach(arg_0 -> ((PacketDataSerializer)buf).d(arg_0));
        return new PacketPlayOutMount(buf);
    }
}

