/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.v1_20_R2.parser.model;

import com.google.common.collect.ImmutableSet;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.entity.BukkitEntity;
import com.ticxo.modelengine.api.entity.CullType;
import com.ticxo.modelengine.api.entity.data.IEntityData;
import com.ticxo.modelengine.api.model.render.DisplayRenderer;
import com.ticxo.modelengine.api.model.render.ModelRendererParser;
import com.ticxo.modelengine.v1_20_R2.entity.EntityUtils;
import com.ticxo.modelengine.v1_20_R2.network.utils.NetworkUtils;
import com.ticxo.modelengine.v1_20_R2.network.utils.Packets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DisplayParser
implements ModelRendererParser<DisplayRenderer> {
    private final Map<String, Set<Player>> players = new HashMap<String, Set<Player>>();
    private final Set<Runnable> cleanupQueue = new HashSet<Runnable>();

    @Override
    public void sendToClients(DisplayRenderer renderer) {
        IEntityData data = renderer.getActiveModel().getModeledEntity().getBase().getData();
        for (Map.Entry<Player, CullType> entry : data.getTracking().entrySet()) {
            switch (entry.getValue()) {
                case NO_CULL: {
                    if (renderer.pollFullUpdate(entry.getKey())) {
                        this.players.computeIfAbsent("NO_CULL_FORCE", s -> new HashSet()).add(entry.getKey());
                        break;
                    }
                    this.players.computeIfAbsent(entry.getValue().name(), s -> new HashSet()).add(entry.getKey());
                    break;
                }
                case MOVEMENT_ONLY: {
                    renderer.pushFullUpdate(entry.getKey());
                    this.players.computeIfAbsent(entry.getValue().name(), s -> new HashSet()).add(entry.getKey());
                    break;
                }
                case CULLED: {
                    this.players.computeIfAbsent(entry.getValue().name(), s -> new HashSet()).add(entry.getKey());
                }
            }
        }
        if (renderer.pollFirstSpawn()) {
            HashSet<Player> set = new HashSet<Player>();
            set.addAll((Collection)this.players.getOrDefault("MOVEMENT_ONLY", (Set<Player>)ImmutableSet.of()));
            set.addAll((Collection)this.players.getOrDefault("NO_CULL", (Set<Player>)ImmutableSet.of()));
            set.addAll((Collection)this.players.getOrDefault("NO_CULL_FORCE", (Set<Player>)ImmutableSet.of()));
            this.spawn(set, renderer);
        } else {
            this.spawn(data.getStartTracking(), renderer);
            this.updateRealtime(this.players.getOrDefault("MOVEMENT_ONLY", (Set<Player>)ImmutableSet.of()), renderer, true, false);
            this.updateRealtime(this.players.getOrDefault("NO_CULL", (Set<Player>)ImmutableSet.of()), renderer, false, false);
            this.updateRealtime(this.players.getOrDefault("NO_CULL_FORCE", (Set<Player>)ImmutableSet.of()), renderer, false, true);
            this.updateCulled(this.players.getOrDefault("CULLED", (Set<Player>)ImmutableSet.of()), renderer);
            this.remove(data.getStopTracking(), renderer);
        }
        this.players.forEach((cullType, players) -> players.clear());
        renderer.getPivot().clearDirty();
        renderer.getHitbox().clearDirty();
        this.cleanupQueue.forEach(Runnable::run);
        this.cleanupQueue.clear();
    }

    @Override
    public void destroy(DisplayRenderer renderer) {
        IEntityData data = renderer.getActiveModel().getModeledEntity().getBase().getData();
        HashSet<Player> inRange = new HashSet<Player>(data.getStartTracking());
        inRange.addAll(data.getTracking().keySet());
        inRange.addAll(data.getStopTracking());
        this.remove(inRange, renderer);
    }

    private void spawn(Set<Player> targets, DisplayRenderer renderer) {
        Player owner;
        BukkitEntity bukkitEntity;
        Entity entity;
        if (targets.isEmpty()) {
            return;
        }
        Packets set = new Packets();
        DisplayRenderer.Pivot pivot = renderer.getPivot();
        set.add(this.pivotSpawn(pivot));
        set.add((Packet<PacketListenerPlayOut>)this.pivotData(pivot));
        for (DisplayRenderer.Bone bone : renderer.getRendered().values()) {
            set.add((Packet<PacketListenerPlayOut>)this.displaySpawn(pivot, bone));
            set.add((Packet<PacketListenerPlayOut>)this.displayData(bone, true, false));
        }
        for (DisplayRenderer.Bone bone : renderer.getSpawnQueue().values()) {
            set.add((Packet<PacketListenerPlayOut>)this.displaySpawn(pivot, bone));
            set.add((Packet<PacketListenerPlayOut>)this.displayData(bone, true, false));
        }
        set.add((Packet<PacketListenerPlayOut>)this.pivotMount(pivot));
        BaseEntity<?> base = renderer.getActiveModel().getModeledEntity().getBase();
        if (base instanceof BukkitEntity && (entity = (bukkitEntity = (BukkitEntity)base).getOriginal()) instanceof Player && targets.contains(owner = (Player)entity)) {
            NetworkUtils.sendBundled(owner, set);
        }
        DisplayRenderer.Hitbox hitbox = renderer.getHitbox();
        set.add(this.hitboxSpawnPivot(hitbox));
        set.add((Packet<PacketListenerPlayOut>)this.hitboxDataPivot(hitbox));
        set.add((Packet<PacketListenerPlayOut>)this.hitboxSpawn(hitbox));
        set.add((Packet<PacketListenerPlayOut>)this.hitboxData(hitbox, true));
        set.add((Packet<PacketListenerPlayOut>)this.shadowSpawn(hitbox));
        set.add((Packet<PacketListenerPlayOut>)this.shadowData(hitbox, true));
        set.add((Packet<PacketListenerPlayOut>)this.hitboxMount(hitbox));
        NetworkUtils.sendBundled(targets, set, player -> !player.getUniqueId().equals(base.getUUID()));
    }

    private void updateRealtime(Set<Player> targets, DisplayRenderer renderer, boolean movementOnly, boolean dynamicOnly) {
        if (targets.isEmpty()) {
            return;
        }
        Packets set = new Packets();
        HashSet<Integer> destroy = new HashSet<Integer>();
        DisplayRenderer.Pivot pivot = renderer.getPivot();
        set.add(this.pivotTeleport(pivot));
        if (!movementOnly) {
            for (DisplayRenderer.Bone bone2 : renderer.getRendered().values()) {
                set.add((Packet<PacketListenerPlayOut>)this.displayData(bone2, false, dynamicOnly));
            }
        }
        for (DisplayRenderer.Bone bone2 : renderer.getSpawnQueue().values()) {
            set.add((Packet<PacketListenerPlayOut>)this.displaySpawn(pivot, bone2));
            set.add((Packet<PacketListenerPlayOut>)this.displayData(bone2, true, false));
        }
        renderer.getDestroyQueue().forEach((s, bone) -> destroy.add(bone.getId()));
        if (pivot.getPassengers().isDirty()) {
            set.add((Packet<PacketListenerPlayOut>)this.pivotMount(pivot));
        }
        DisplayRenderer.Hitbox hitbox = renderer.getHitbox();
        boolean updateHitboxMount = false;
        set.add(this.hitboxTeleport(hitbox));
        if (hitbox.getHitboxVisible().isDirty()) {
            if (hitbox.isHitboxVisible()) {
                set.add((Packet<PacketListenerPlayOut>)this.hitboxSpawn(hitbox));
                set.add((Packet<PacketListenerPlayOut>)this.hitboxData(hitbox, true));
                updateHitboxMount = true;
            } else {
                destroy.add(hitbox.getHitboxId());
            }
        } else {
            set.add((Packet<PacketListenerPlayOut>)this.hitboxData(hitbox, false));
        }
        if (hitbox.getShadowVisible().isDirty()) {
            if (hitbox.isShadowVisible()) {
                set.add((Packet<PacketListenerPlayOut>)this.shadowSpawn(hitbox));
                set.add((Packet<PacketListenerPlayOut>)this.shadowData(hitbox, true));
                updateHitboxMount = true;
            } else {
                destroy.add(hitbox.getShadowId());
            }
        } else {
            set.add((Packet<PacketListenerPlayOut>)this.shadowData(hitbox, false));
        }
        if (updateHitboxMount) {
            set.add((Packet<PacketListenerPlayOut>)this.hitboxMount(hitbox));
        }
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.c(destroy.size());
        destroy.forEach(arg_0 -> ((PacketDataSerializer)buf).c(arg_0));
        set.add((Packet<PacketListenerPlayOut>)new PacketPlayOutEntityDestroy(buf));
        NetworkUtils.sendBundled(targets, set);
    }

    private void updateCulled(Set<Player> targets, DisplayRenderer renderer) {
        if (targets.isEmpty()) {
            return;
        }
        Map destroy = renderer.getDestroyQueue();
        if (!destroy.isEmpty()) {
            PacketDataSerializer buf = NetworkUtils.createByteBuf();
            buf.c(destroy.size());
            destroy.forEach((s, item) -> buf.c(item.getId()));
            NetworkUtils.send(targets, (Packet<PacketListenerPlayOut>)new PacketPlayOutEntityDestroy(buf));
        }
    }

    private void remove(Set<Player> targets, DisplayRenderer renderer) {
        if (targets.isEmpty()) {
            return;
        }
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.c(4 + renderer.getRendered().size());
        buf.c(renderer.getPivot().getId());
        buf.c(renderer.getHitbox().getPivotId());
        buf.c(renderer.getHitbox().getHitboxId());
        buf.c(renderer.getHitbox().getShadowId());
        renderer.getRendered().forEach((s, bone) -> buf.c(bone.getId()));
        NetworkUtils.send(targets, (Packet<PacketListenerPlayOut>)new PacketPlayOutEntityDestroy(buf));
    }

    private Packets.PacketSupplier pivotSpawn(DisplayRenderer.Pivot pivot) {
        return NetworkUtils.createPivotSpawn(pivot.getId(), pivot.getUuid(), pivot.getPosition().get());
    }

    private PacketPlayOutEntityMetadata pivotData(DisplayRenderer.Pivot pivot) {
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.c(pivot.getId());
        EntityUtils.writeData(buf, 0, DataWatcherRegistry.a, (byte)32);
        EntityUtils.writeData(buf, 1, DataWatcherRegistry.b, Integer.MAX_VALUE);
        EntityUtils.writeData(buf, 8, DataWatcherRegistry.d, Float.valueOf(0.0f));
        buf.k(255);
        return new PacketPlayOutEntityMetadata(buf);
    }

    private PacketPlayOutMount pivotMount(DisplayRenderer.Pivot pivot) {
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.c(pivot.getId());
        buf.c(pivot.getPassengers().size());
        pivot.getPassengers().forEach(arg_0 -> ((PacketDataSerializer)buf).c(arg_0));
        return new PacketPlayOutMount(buf);
    }

    private Packets.PacketSupplier pivotTeleport(DisplayRenderer.Pivot pivot) {
        if (!pivot.getPosition().isDirty()) {
            return null;
        }
        this.cleanupQueue.add(() -> pivot.getPosition().clearDirty());
        return NetworkUtils.createPivotTeleport(pivot.getId(), pivot.getPosition().get());
    }

    private PacketPlayOutSpawnEntity displaySpawn(DisplayRenderer.Pivot pivot, DisplayRenderer.Bone bone) {
        Vector3f pos = pivot.getPosition().get();
        return new PacketPlayOutSpawnEntity(bone.getId(), bone.getUuid(), (double)pos.x, (double)pos.y, (double)pos.z, 0.0f, 0.0f, EntityTypes.ae, 0, Vec3D.b, 0.0);
    }

    private PacketPlayOutEntityMetadata displayData(DisplayRenderer.Bone bone, boolean force, boolean dynamicOnly) {
        if (!(force || dynamicOnly || bone.isDirty())) {
            return null;
        }
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.c(bone.getId());
        if (force) {
            EntityUtils.writeData(buf, 0, DataWatcherRegistry.a, (byte)32);
            EntityUtils.writeData(buf, 1, DataWatcherRegistry.b, Integer.MAX_VALUE);
            EntityUtils.writeData(buf, 8, DataWatcherRegistry.b, 0);
            EntityUtils.writeData(buf, 9, DataWatcherRegistry.b, 1);
        } else if (bone.isTransformDirty() || dynamicOnly) {
            EntityUtils.writeData(buf, 8, DataWatcherRegistry.b, 0);
        }
        bone.getPosition().ifDirty(vector3f -> EntityUtils.writeData(buf, 11, DataWatcherRegistry.A, vector3f), force || dynamicOnly);
        bone.getScale().ifDirty(vector3f -> EntityUtils.writeData(buf, 12, DataWatcherRegistry.A, vector3f), force || dynamicOnly);
        bone.getLeftRotation().ifDirty(quaternionf -> EntityUtils.writeData(buf, 13, DataWatcherRegistry.B, quaternionf.rotateY((float)Math.PI, new Quaternionf())), force || dynamicOnly);
        bone.getRightRotation().ifDirty(quaternionf -> EntityUtils.writeData(buf, 14, DataWatcherRegistry.B, quaternionf), force || dynamicOnly);
        bone.getVisibility().ifDirty(flag -> EntityUtils.writeData(buf, 17, DataWatcherRegistry.d, Float.valueOf(flag != false ? 4096.0f : 0.0f)), force || dynamicOnly);
        bone.getModel().ifDirty(itemStack -> EntityUtils.writeData(buf, 23, DataWatcherRegistry.h, CraftItemStack.asNMSCopy((ItemStack)itemStack)), force || dynamicOnly);
        bone.getDisplay().ifDirty(display -> EntityUtils.writeData(buf, 24, DataWatcherRegistry.a, display == null ? (byte)0 : (byte)display.ordinal()), force || dynamicOnly);
        buf.k(255);
        this.cleanupQueue.add(bone::clearDirty);
        return new PacketPlayOutEntityMetadata(buf);
    }

    private Packets.PacketSupplier hitboxSpawnPivot(DisplayRenderer.Hitbox hitbox) {
        return hitbox.isPivotVisible() ? NetworkUtils.createPivotSpawn(hitbox.getPivotId(), hitbox.getPivotUuid(), hitbox.getPosition().get()) : null;
    }

    private PacketPlayOutEntityMetadata hitboxDataPivot(DisplayRenderer.Hitbox hitbox) {
        if (!hitbox.isPivotVisible()) {
            return null;
        }
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.c(hitbox.getPivotId());
        EntityUtils.writeData(buf, 0, DataWatcherRegistry.a, (byte)32);
        EntityUtils.writeData(buf, 1, DataWatcherRegistry.b, Integer.MAX_VALUE);
        EntityUtils.writeData(buf, 8, DataWatcherRegistry.d, Float.valueOf(0.0f));
        buf.k(255);
        return new PacketPlayOutEntityMetadata(buf);
    }

    private PacketPlayOutSpawnEntity hitboxSpawn(DisplayRenderer.Hitbox hitbox) {
        if (!hitbox.isHitboxVisible()) {
            return null;
        }
        Vector3f pos = hitbox.getPosition().get();
        return new PacketPlayOutSpawnEntity(hitbox.getHitboxId(), hitbox.getHitboxUuid(), (double)pos.x, (double)pos.y, (double)pos.z, 0.0f, 0.0f, EntityTypes.ab, 0, Vec3D.b, 0.0);
    }

    private PacketPlayOutEntityMetadata hitboxData(DisplayRenderer.Hitbox hitbox, boolean spawn) {
        if (!hitbox.isHitboxVisible() || !hitbox.isHitboxDirty() && !spawn) {
            return null;
        }
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.c(hitbox.getHitboxId());
        if (spawn) {
            EntityUtils.writeData(buf, 1, DataWatcherRegistry.b, Integer.MAX_VALUE);
            EntityUtils.writeData(buf, 10, DataWatcherRegistry.k, false);
        }
        hitbox.getWidth().ifDirty(val -> EntityUtils.writeData(buf, 8, DataWatcherRegistry.d, val), spawn);
        hitbox.getHeight().ifDirty(val -> EntityUtils.writeData(buf, 9, DataWatcherRegistry.d, val), spawn);
        buf.k(255);
        return new PacketPlayOutEntityMetadata(buf);
    }

    private PacketPlayOutSpawnEntity shadowSpawn(DisplayRenderer.Hitbox hitbox) {
        if (!hitbox.isShadowVisible()) {
            return null;
        }
        Vector3f pos = hitbox.getPosition().get();
        return new PacketPlayOutSpawnEntity(hitbox.getShadowId(), hitbox.getShadowUuid(), (double)pos.x, (double)pos.y, (double)pos.z, 0.0f, 0.0f, EntityTypes.ae, 0, Vec3D.b, 0.0);
    }

    private PacketPlayOutEntityMetadata shadowData(DisplayRenderer.Hitbox hitbox, boolean spawn) {
        if (!hitbox.isShadowVisible() || !hitbox.getShadowRadius().isDirty() && !spawn) {
            return null;
        }
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.c(hitbox.getShadowId());
        if (spawn) {
            EntityUtils.writeData(buf, 1, DataWatcherRegistry.b, Integer.MAX_VALUE);
        }
        hitbox.getShadowRadius().ifDirty(val -> EntityUtils.writeData(buf, 18, DataWatcherRegistry.d, val), spawn);
        buf.k(255);
        return new PacketPlayOutEntityMetadata(buf);
    }

    private Packets.PacketSupplier hitboxTeleport(DisplayRenderer.Hitbox hitbox) {
        if (!hitbox.isPivotVisible() && !hitbox.getPosition().isDirty()) {
            return null;
        }
        this.cleanupQueue.add(() -> hitbox.getPosition().clearDirty());
        return NetworkUtils.createPivotTeleport(hitbox.getPivotId(), hitbox.getPosition().get());
    }

    private PacketPlayOutMount hitboxMount(DisplayRenderer.Hitbox hitbox) {
        if (!hitbox.isPivotVisible()) {
            return null;
        }
        boolean hitboxVisible = hitbox.isHitboxVisible();
        boolean shadowVisible = hitbox.isShadowVisible();
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.c(hitbox.getPivotId());
        buf.c(hitboxVisible && shadowVisible ? 2 : 1);
        if (hitboxVisible) {
            buf.c(hitbox.getHitboxId());
        }
        if (shadowVisible) {
            buf.c(hitbox.getShadowId());
        }
        return new PacketPlayOutMount(buf);
    }
}

