/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.MMOLineConfig;
import io.lumine.mythic.lib.api.condition.RegionCondition;
import io.lumine.mythic.lib.api.condition.type.MMOCondition;
import io.lumine.mythic.lib.comp.interaction.InteractionType;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class UtilityMethods {
    private static final double BOUNDING_BOX_EXPANSION = 0.2;
    private static final Random RANDOM = new Random();
    private static final Map<String, String> DEBUG_COLOR_PREFIX = new HashMap<String, String>();

    public static MMOCondition getCondition(String input) {
        String key;
        MMOLineConfig config = new MMOLineConfig(input);
        switch (key = config.getKey().toLowerCase()) {
            case "region": {
                if (!Bukkit.getPluginManager().isPluginEnabled("WorldGuard")) {
                    return null;
                }
                return new RegionCondition(config);
            }
        }
        return null;
    }

    public static List<Entity> getNearbyChunkEntities(Location loc) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        int cx = loc.getChunk().getX();
        int cz = loc.getChunk().getZ();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                entities.addAll(Arrays.asList(loc.getWorld().getChunkAt(cx + x, cz + z).getEntities()));
            }
        }
        return entities;
    }

    public static boolean canTarget(Player source, Entity target) {
        return UtilityMethods.canTarget(source, null, target, InteractionType.OFFENSE_SKILL);
    }

    public static boolean canTarget(Player source, Location loc, Entity target) {
        return UtilityMethods.canTarget(source, loc, target, InteractionType.OFFENSE_SKILL);
    }

    public static boolean canTarget(Player source, Entity target, InteractionType interaction) {
        return UtilityMethods.canTarget(source, null, target, interaction);
    }

    public static boolean canTarget(@Nullable Player source, @Nullable Location loc, @NotNull Entity target, @NotNull InteractionType interaction) {
        if (loc != null && !target.getBoundingBox().expand(0.2).contains(loc.toVector())) {
            return false;
        }
        return MythicLib.plugin.getEntities().canInteract(source, target, interaction);
    }

    public static boolean isRealPlayer(Entity entity) {
        return entity instanceof Player && !entity.hasMetadata("NPC");
    }

    public static boolean isMetaItem(@Nullable ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName();
    }

    public static void heal(@NotNull LivingEntity player, double heal) {
        UtilityMethods.heal(player, heal, false);
    }

    public static void heal(@NotNull LivingEntity player, double heal, boolean allowNegatives) {
        if (heal > 0.0 || allowNegatives) {
            player.setHealth(Math.min(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue(), player.getHealth() + heal));
        }
    }

    public static String caseOnWords(String input) {
        StringBuilder builder = new StringBuilder(input);
        boolean isLastSpace = true;
        for (int i = 0; i < builder.length(); ++i) {
            char ch = builder.charAt(i);
            if (isLastSpace && ch >= 'a' && ch <= 'z') {
                builder.setCharAt(i, (char)(ch + -32));
                isLastSpace = false;
                continue;
            }
            isLastSpace = ch == ' ';
        }
        return builder.toString();
    }

    public static void dropItemNaturally(Location loc, ItemStack stack) {
        double dx = ((double)(RANDOM.nextFloat() * 0.5f) + 0.25) / 10.0;
        double dy = ((double)(RANDOM.nextFloat() * 0.5f) + 0.25) / 10.0;
        double dz = ((double)(RANDOM.nextFloat() * 0.5f) + 0.25) / 10.0;
        loc.getWorld().dropItem(loc.add(0.5, 0.5, 0.5), stack).setVelocity(new Vector(dx, dy, dz));
    }

    @Deprecated
    public static List<Player> getNearbyPlayers(Location loc) {
        ArrayList<Player> players = new ArrayList<Player>();
        int cx = loc.getChunk().getX();
        int cz = loc.getChunk().getZ();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (Entity target : loc.getWorld().getChunkAt(cx + x, cz + z).getEntities()) {
                    if (!(target instanceof Player)) continue;
                    players.add((Player)target);
                }
            }
        }
        return players;
    }

    public static void loadDefaultFile(String path, String name) {
        File file;
        String newPath = path.isEmpty() ? "" : "/" + path;
        File folder = new File(MythicLib.plugin.getDataFolder() + newPath);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!(file = new File(MythicLib.plugin.getDataFolder() + newPath, name)).exists()) {
            try {
                Files.copy(MythicLib.plugin.getResource("default/" + (path.isEmpty() ? "" : path + "/") + name), file.getAbsoluteFile().toPath(), new CopyOption[0]);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    public static boolean isVanished(Player player) {
        for (MetadataValue meta : player.getMetadata("vanished")) {
            if (!meta.asBoolean()) continue;
            return true;
        }
        return false;
    }

    public static String enumName(String str) {
        return str.toUpperCase().replace("-", "_").replace(" ", "_");
    }

    public static String ymlName(String str) {
        return str.toLowerCase().replace("_", "-").replace(" ", "-");
    }

    public static double[] getYawPitch(Vector axis) {
        double _2PI = Math.PI * 2;
        double x = axis.getX();
        double z = axis.getZ();
        if (x == 0.0 && z == 0.0) {
            return new double[]{0.0, axis.getY() > 0.0 ? -90.0 : 90.0};
        }
        double theta = Math.atan2(-x, z);
        double yaw = (float)Math.toDegrees((theta + _2PI) % _2PI);
        double xz = Math.sqrt(x * x + z * z);
        double pitch = (float)Math.toDegrees(Math.atan(-axis.getY() / xz));
        return new double[]{yaw, pitch};
    }

    @Nullable
    public static Player getPlayerDamager(EntityDamageByEntityEvent event) {
        ProjectileSource shooter;
        if (UtilityMethods.isRealPlayer(event.getDamager())) {
            return (Player)event.getDamager();
        }
        if (event.getDamager() instanceof Projectile && (shooter = ((Projectile)event.getDamager()).getShooter()) instanceof Entity && UtilityMethods.isRealPlayer((Entity)shooter)) {
            return (Player)shooter;
        }
        return null;
    }

    public static Vector rotate(Vector rotated, Vector axis) {
        double[] pitchYaw = UtilityMethods.getYawPitch(axis);
        return UtilityMethods.rotate(rotated, Math.toRadians(pitchYaw[0]), Math.toRadians(pitchYaw[1]));
    }

    public static Vector rotate(Vector rotated, double yaw, double pitch) {
        return UtilityMethods.rotAxisY(UtilityMethods.rotAxisX(rotated, pitch), -yaw);
    }

    private static Vector rotAxisX(Vector rotated, double angle) {
        double y = rotated.getY() * Math.cos(angle) - rotated.getZ() * Math.sin(angle);
        double z = rotated.getY() * Math.sin(angle) + rotated.getZ() * Math.cos(angle);
        return rotated.setY(y).setZ(z);
    }

    private static Vector rotAxisY(Vector rotated, double angle) {
        double x = rotated.getX() * Math.cos(angle) + rotated.getZ() * Math.sin(angle);
        double z = rotated.getX() * -Math.sin(angle) + rotated.getZ() * Math.cos(angle);
        return rotated.setX(x).setZ(z);
    }

    public static double getAltitude(Entity entity) {
        return UtilityMethods.getAltitude(entity.getLocation());
    }

    public static double getAltitude(Location loc) {
        Location moving = loc.clone();
        while (!moving.getBlock().getType().isSolid()) {
            moving.add(0.0, -1.0, 0.0);
        }
        return loc.getY() - (double)moving.getBlockY() - 1.0;
    }

    public static void debug(@NotNull JavaPlugin plugin, @Nullable String prefix, @NotNull String message) {
        Validate.notNull((Object)plugin, (String)"Plugin cannot be null");
        Validate.notNull((Object)message, (String)"Message cannot be null");
        String colorPrefix = DEBUG_COLOR_PREFIX.getOrDefault(plugin.getName(), "");
        if (MythicLib.plugin.getMMOConfig().debugMode) {
            plugin.getLogger().log(Level.INFO, colorPrefix + "[Debug" + (prefix == null ? "" : ": " + prefix) + "] " + message);
        }
    }

    static {
        DEBUG_COLOR_PREFIX.put("MythicLib", "\u00a7a");
        DEBUG_COLOR_PREFIX.put("MMOItems", "\u00a7c");
        DEBUG_COLOR_PREFIX.put("MMOCore", "\u00a76");
        DEBUG_COLOR_PREFIX.put("RPGInventory", "\u00a7e");
    }
}

